# Copyright 2013 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Generates the config files which will be needed by the hadoop servers such
# as 'slaves' listing all datanode hostnames, 'masters' listing the namenode,
# and the xml files which go under the 'conf/' directory of the hadoop
# installation.

set -e

SET_DEFAULT_FS_ARGS=''

# Set FS specific config variables
if [[ "${DEFAULT_FS}" == 'gs' ]]; then
  SET_DEFAULT_FS_ARGS="--default_bucket=${CONFIGBUCKET}"
elif [[ "${DEFAULT_FS}" == 'hdfs' ]]; then
  SET_DEFAULT_FS_ARGS="--namenode_uri=${NAMENODE_URI}"
fi

# Download and use ghconfig for xml configuration.
if [[ ! -f "$(which ghconfig)" ]]; then
  wget "${GHCONFIG}" -O /tmp/ghconfig.tar.gz
  tar -C /usr/share/google -xzvf /tmp/ghconfig.tar.gz
  ln -s /usr/share/google/ghconfig*/ghconfig /usr/local/bin
fi

ghconfig set_default_fs \
    --hadoop_conf_dir ${HADOOP_CONF_DIR} \
    --default_fs ${DEFAULT_FS} \
    ${SET_DEFAULT_FS_ARGS}

chown -R hadoop:hadoop ${HADOOP_CONF_DIR}
