# Copyright 2013 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Downloads and installs all appropriate hadoop packages as user 'hadoop'.
# Also adds installation specific configs into the login scripts of user
# 'hadoop'.

set -e

HADOOP_TARBALL=${HADOOP_TARBALL_URI##*/}
HADOOP_TARBALL_URI_SCHEME=${HADOOP_TARBALL_URI%%://*}
if [[ "${HADOOP_TARBALL_URI_SCHEME}" == gs ]]; then
  gsutil cp ${HADOOP_TARBALL_URI} /home/hadoop/${HADOOP_TARBALL}
elif [[ "${HADOOP_TARBALL_URI_SCHEME}" =~ ^https?$ ]]; then
  wget ${HADOOP_TARBALL_URI} -O /home/hadoop/${HADOOP_TARBALL}
else
  echo "Unknown scheme \"${HADOOP_TARBALL_URI_SCHEME}\" in HADOOP_TARBALL_URI: \
$HADOOP_TARBALL_URI" >&2
  exit 1
fi
tar -C /home/hadoop -xvzf /home/hadoop/${HADOOP_TARBALL}
mv /home/hadoop/hadoop*/ ${HADOOP_INSTALL_DIR}

# Update login scripts
cat << EOF >> /home/hadoop/.bashrc
if [[ -e "${HADOOP_INSTALL_DIR}/libexec/hadoop-config.sh" ]]; then
  . "${HADOOP_INSTALL_DIR}/libexec/hadoop-config.sh"
else
  . "${HADOOP_INSTALL_DIR}/bin/hadoop-config.sh"
fi
export PATH=\$PATH:${HADOOP_INSTALL_DIR}/bin
EOF
echo '. /home/hadoop/.bashrc' >> /home/hadoop/.bash_profile

chown -R hadoop:hadoop /home/hadoop/ ${HADOOP_INSTALL_DIR}
