# Copyright 2013 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Downloads and installs the relevant gcs-connector-<version>.jar.
# Also configures it for use with hadoop.

set -e

# Grab the ghfs jarfile, add it to installation /lib directory.
GHFS_JARNAME=$(echo ${GHFSJAR} | sed -e 's/.*\/\([-a-zA-Z0-9_\.]*\.jar\).*/\1/')
wget "${GHFSJAR}" -O ${HADOOP_INSTALL_DIR}/lib/${GHFS_JARNAME}
chown hadoop:hadoop ${HADOOP_INSTALL_DIR}/lib/${GHFS_JARNAME}

# Download and use ghconfig for xml configuration.
if [[ ! -f "$(which ghconfig)" ]]; then
  wget "${GHCONFIG}" -O /tmp/ghconfig.tar.gz
  tar -C /usr/share/google -xzvf /tmp/ghconfig.tar.gz
  ln -s /usr/share/google/ghconfig*/ghconfig /usr/local/bin
fi

PROJECT="$(curl http://metadata/computeMetadata/v1beta1/project/project-id)"
ghconfig configure_ghfs \
    --hadoop_conf_dir ${HADOOP_CONF_DIR} \
    --ghfs_jar_path ${HADOOP_INSTALL_DIR}/lib/${GHFS_JARNAME} \
    --system_bucket ${CONFIGBUCKET} \
    --enable_service_account_auth \
    --project_id ${PROJECT}

chown -R hadoop:hadoop ${HADOOP_CONF_DIR}

# Test installation
FS_CMD="sudo -u hadoop ${HADOOP_INSTALL_DIR}/bin/hadoop fs"
if ! ${FS_CMD} -test -d gs://${CONFIGBUCKET}
then
  if ! gsutil ls -b gs://${CONFIGBUCKET}; then
    echo "Error: Could not access GCS on VM $(hostname)" >&2
  else
    cat << EOF >&2
Error: There was a problem accessing your configuration bucket using the GCS
connector. Check configuration files. Also make sure have the GCS JSON API
enabled as described at https://developers.google.com/storage/docs/json_api/.
EOF
  fi
  exit 1
fi
