# Copyright 1999-2013 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/x11-libs/pango/pango-1.32.5.ebuild,v 1.13 2013/06/06 14:24:31 tetromino Exp $

EAPI="4"
GCONF_DEBUG="yes"
GNOME2_LA_PUNT="yes"

inherit autotools eutils gnome2 multilib toolchain-funcs

DESCRIPTION="Internationalized text layout and rendering library"
HOMEPAGE="http://www.pango.org/"

LICENSE="LGPL-2+ FTL"
SLOT="0"
KEYWORDS="*"

IUSE="X cros_host +introspection"

RDEPEND="
	>=media-libs/harfbuzz-0.9.9[glib(+),truetype(+)]
	>=dev-libs/glib-2.33.12:2
	>=media-libs/fontconfig-2.5.0:1.0
	media-libs/freetype:2
	>=x11-libs/cairo-1.7.6[X?]
	introspection? ( >=dev-libs/gobject-introspection-0.9.5 )
	X? (
		x11-libs/libXrender
		x11-libs/libX11
		>=x11-libs/libXft-2.0.0 )"
DEPEND="${RDEPEND}
	>=dev-util/gtk-doc-am-1.13
	virtual/pkgconfig
	X? ( x11-proto/xproto )
	!<=sys-devel/autoconf-2.63:2.5"

src_prepare() {
	tc-export CXX
	DOCS="AUTHORS ChangeLog* NEWS README THANKS"
	G2CONF="${G2CONF}
		$(use_enable introspection)
		$(use_with X xft)
		"$(usex X --x-includes="${SYSROOT}${EPREFIX}/usr/include" "")"
		"$(usex X --x-libraries="${SYSROOT}${EPREFIX}/usr/$(get_libdir)" "")

	epatch "${FILESDIR}/${PN}-1.32.1-lib64.patch"
	epatch "${FILESDIR}/${P}-AM_CONFIG_HEADER.patch" # fixed in 1.34
	epatch "${FILESDIR}/${P}-basic_fc_hf.patch" # fixed in 1.32.6

	#Disable reading $HOME/.config/pango/pangorc if building for the target.
	if  ! use cros_host ; then
		epatch "${FILESDIR}/${P}-pangorc.patch"
	fi
	eautoreconf

	gnome2_src_prepare

}

src_install() {
	gnome2_src_install

	local PANGO_CONFDIR="/etc/pango/${CHOST}"
	dodir "${PANGO_CONFDIR}"
	keepdir "${PANGO_CONFDIR}"

	# TODO(msb): Ugly Hack fix for pango-querymodules. pango-querymodules
	# needs to be run on the target, but during the build process, we can't.
	# We ran it in chroot and edited the result to generate a 'template'
	# with @libdir which we replace here with the real library
	# location on the target.
	sed "s:@libdir@:$(get_libdir):g" "${FILESDIR}"/pango.modules \
		>pango.modules || die
	insinto "${PANGO_CONFDIR}"
	doins pango.modules || die
}

pkg_postinst() {
	gnome2_pkg_postinst

	if [ "${ROOT}" = "/" ] ; then
		einfo "Generating modules listing..."
		local PANGO_CONFDIR="${EROOT}/etc/pango/${CHOST}"
		local pango_conf="${PANGO_CONFDIR}/pango.modules"
		local tmp_file=$(mktemp -t tmp_pango_ebuild.XXXXXXXXXX)

		# be atomic!
		if pango-querymodules --system \
			"${EROOT}"usr/$(get_libdir)/pango/1.8.0/modules/*$(get_modname) \
				> "${tmp_file}"; then
			cat "${tmp_file}" > "${pango_conf}" || {
				rm "${tmp_file}"; die; }
		else
			ewarn "Cannot update pango.modules, file generation failed"
		fi
		rm "${tmp_file}"
	fi

	if [[ ${REPLACING_VERSIONS} < 1.30.1 ]]; then
		elog "In >=${PN}-1.30.1, default configuration file locations moved from"
		elog "~/.pangorc and ~/.pangox_aliases to ~/.config/pango/pangorc and"
		elog "~/.config/pango/pangox.aliases"
	fi
}
