# Copyright 1999-2014 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sys-apps/findutils/findutils-4.4.2-r2.ebuild,v 1.1 2014/09/08 23:14:34 vapier Exp $

EAPI="4"

inherit eutils flag-o-matic toolchain-funcs

SELINUX_PATCH="findutils-4.4.2-selinux.diff"

DESCRIPTION="GNU utilities for finding files"
HOMEPAGE="http://www.gnu.org/software/findutils/"
SRC_URI="mirror://gnu-alpha/${PN}/${P}.tar.gz
	mirror://gnu/${PN}/${P}.tar.gz"

LICENSE="GPL-3+"
SLOT="0"
KEYWORDS="*"
IUSE="debug nls selinux static"

RDEPEND="selinux? ( sys-libs/libselinux )
	nls? ( virtual/libintl )"
DEPEND="${RDEPEND}
	nls? ( sys-devel/gettext )"

src_prepare() {
	epatch "${FILESDIR}"/${P}-gnulib-date-x32.patch

	# Don't build or install locate because it conflicts with slocate,
	# which is a secure version of locate.  See bug 18729
	sed -i '/^SUBDIRS/s/locate//' Makefile.in

	use selinux && epatch "${FILESDIR}/${SELINUX_PATCH}"
}

src_configure() {
	use static && append-ldflags -static

	program_prefix=$(usex userland_GNU '' g)
	econf \
		--program-prefix=${program_prefix} \
		$(use_enable debug) \
		$(use_enable nls) \
		--libexecdir='$(libdir)'/find
}

src_compile() {
	emake AR="$(tc-getAR)"
}

src_install() {
	default

	# We don't need this, so punt it.
	rm "${ED}"/usr/bin/${program_prefix}oldfind || die
}
