# Copyright 2012 The Chromium OS Authors
# Distributed under the terms of the GNU General Public License v2
# $Header:

EAPI="4"
CROS_WORKON_COMMIT=("fc73b98529ad1eb187f97a4177beda4224f473d1" "bcf8389d9bb046341a0342c35fdda7321d22ea10")
CROS_WORKON_TREE=("2c05b4c44921d555719760f8a7bf1d38b35a749d" "ba668586092f3e66ae2e36db59bfce9cd7482291")
CROS_WORKON_PROJECT=(
	"chromiumos/third_party/coreboot"
	"chromiumos/platform/vboot_reference"
)
CROS_WORKON_LOCALNAME=(
	"coreboot"
	"../platform/vboot_reference"
)
CROS_WORKON_DESTDIR=(
	"${S}"
	"${S}/3rdparty/vboot"
)

inherit cros-workon toolchain-funcs

RDEPEND="sys-apps/pciutils"
DEPEND="${RDEPEND}"

DESCRIPTION="Utilities for modifying coreboot firmware images"
HOMEPAGE="http://coreboot.org"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="*"
IUSE="cros_host mma bitmap_in_cbfs"

src_configure() {
	cros-workon_src_configure
}

is_x86() {
	use x86 || use amd64
}

src_compile() {
	tc-export CC
	if use cros_host; then
		emake -C util/cbfstool obj="${PWD}/util/cbfstool"
	else
		emake -C util/cbmem CC="${CC}"
	fi
	if is_x86; then
		if use cros_host; then
			emake -C util/ifdtool
		else
			emake -C util/superiotool CC="${CC}"
			emake -C util/inteltool CC="${CC}"
			emake -C util/nvramtool CC="${CC}"
		fi
		if use mma; then
			emake -C util/cbfstool obj="${PWD}/util/cbfstool"
			emake -C util/cbmem CC="${CC}"
		fi
	fi
	use bitmap_in_cbfs && emake -C util/archive CC="${CC}"
}

src_install() {
	if use cros_host; then
		dobin util/cbfstool/cbfstool
	else
		dobin util/cbmem/cbmem
	fi
	if is_x86; then
		if use cros_host; then
			dobin util/ifdtool/ifdtool
		else
			dobin util/superiotool/superiotool
			dobin util/inteltool/inteltool
			dobin util/nvramtool/nvramtool
		fi
		if use mma; then
			dobin util/mma/mma_setup_test.sh
			dobin util/mma/mma_get_result.sh
			dobin util/mma/mma_automated_test.sh
			dobin util/cbfstool/cbfstool
			insinto /etc/init
			doins util/mma/mma.conf
		fi
	fi
	use bitmap_in_cbfs && dobin util/archive/archive
}
