# Copyright 1999-2013 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-python/python-dateutil/python-dateutil-2.1-r1.ebuild,v 1.14 2013/12/23 16:23:13 ago Exp $

EAPI=5
PYTHON_COMPAT=( python{2_6,2_7,3_2,3_3} pypy2_0 )

inherit distutils-r1

DESCRIPTION="Extensions to the standard Python datetime module"
HOMEPAGE="https://launchpad.net/dateutil http://pypi.python.org/pypi/python-dateutil"
SRC_URI="mirror://pypi/${PN:0:1}/${PN}/${P}.tar.gz"

LICENSE="BSD"
SLOT="0"
KEYWORDS="*"
IUSE="examples"

RDEPEND="dev-python/six[${PYTHON_USEDEP}]
	sys-libs/timezone-data
	!<dev-python/python-dateutil-2.1"
DEPEND="${RDEPEND}
	dev-python/setuptools[${PYTHON_USEDEP}]"

PATCHES=(
	# Bug 410725.
	"${FILESDIR}/${P}-open-utf-8.patch"
)

python_prepare_all() {
	# Use zoneinfo in /usr/share/zoneinfo.
	sed -i -e "s/zoneinfo.gettz/gettz/g" test.py || die

	# Fix parsing of date in non-English locales.
	sed -e 's/subprocess.getoutput("date")/subprocess.getoutput("LC_ALL=C date")/' \
		-i example.py || die

	distutils-r1_python_prepare_all
}

python_test() {
	"${PYTHON}" test.py || die
}

python_install() {
	distutils-r1_python_install

	rm -f "${D}$(python_get_sitedir)/dateutil/zoneinfo"/*.tar.*
}

python_install_all() {
	distutils-r1_python_install_all

	if use examples; then
		docinto examples
		dodoc example.py sandbox/*.py
	fi
}
