# Copyright 1999-2013 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-python/numpy/numpy-1.7.1.ebuild,v 1.12 2013/12/29 09:08:14 hattya Exp $

EAPI=5

PYTHON_COMPAT=( python{2_6,2_7,3_2,3_3} )

FORTRAN_NEEDED=lapack

inherit distutils-r1 eutils flag-o-matic fortran-2 multilib toolchain-funcs versionator

#DOC_PV="${PV}"
# upstream is lagging on docs
DOC_PV=1.7.0

DESCRIPTION="Fast array and numerical python library"
HOMEPAGE="http://numpy.scipy.org/"
SRC_URI="mirror://sourceforge/numpy/${P}.tar.gz
	doc? (
		http://docs.scipy.org/doc/${P}/${PN}-html-${DOC_PV}.zip
		http://docs.scipy.org/doc/${P}/${PN}-ref-${DOC_PV}.pdf
		http://docs.scipy.org/doc/${P}/${PN}-user-${DOC_PV}.pdf
	)"

LICENSE="BSD"
SLOT="0"
KEYWORDS="*"
IUSE="doc lapack test"

RDEPEND="
	dev-python/setuptools[${PYTHON_USEDEP}]
	lapack? ( virtual/cblas virtual/lapack )"
DEPEND="${RDEPEND}
	doc? ( app-arch/unzip )
	lapack? ( virtual/pkgconfig )
	test? ( >=dev-python/nose-0.10[${PYTHON_USEDEP}] )"

# Uses distutils.command.config.
DISTUTILS_IN_SOURCE_BUILD=1

src_unpack() {
	unpack ${P}.tar.gz
	if use doc; then
		unzip -qo "${DISTDIR}"/${PN}-html-${DOC_PV}.zip -d html || die
	fi
}

pc_incdir() {
	$(tc-getPKG_CONFIG) --cflags-only-I $@ | \
		sed -e 's/^-I//' -e 's/[ ]*-I/:/g' -e 's/[ ]*$//'
}

pc_libdir() {
	$(tc-getPKG_CONFIG) --libs-only-L $@ | \
		sed -e 's/^-L//' -e 's/[ ]*-L/:/g' -e 's/[ ]*$//'
}

pc_libs() {
	$(tc-getPKG_CONFIG) --libs-only-l $@ | \
		sed -e 's/[ ]-l*\(pthread\|m\)[ ]*//g' \
		-e 's/^-l//' -e 's/[ ]*-l/,/g' -e 's/[ ]*$//'
}

python_prepare_all() {
	epatch "${FILESDIR}"/${PN}-1.7.0-atlas.patch
	# applied upstream
	epatch "${FILESDIR}"/${PN}-1.7.1-distutils-python33.patch

	if use lapack; then
		append-ldflags "$($(tc-getPKG_CONFIG) --libs-only-other cblas lapack)"
		local libdir="${EPREFIX}"/usr/$(get_libdir)
		# make sure _dotblas.so gets built
		sed -i -e '/NO_ATLAS_INFO/,+1d' numpy/core/setup.py || die
		cat >> site.cfg <<-EOF
			[blas]
			include_dirs = $(pc_incdir cblas)
			library_dirs = $(pc_libdir cblas blas):${libdir}
			blas_libs = $(pc_libs cblas blas)
			[lapack]
			library_dirs = $(pc_libdir lapack):${libdir}
			lapack_libs = $(pc_libs lapack)
		EOF
	else
		export {ATLAS,PTATLAS,BLAS,LAPACK,MKL}=None
	fi

	export CC="$(tc-getCC) ${CFLAGS}"

	append-flags -fno-strict-aliasing

	# See progress in http://projects.scipy.org/scipy/numpy/ticket/573
	# with the subtle difference that we don't want to break Darwin where
	# -shared is not a valid linker argument
	if [[ ${CHOST} != *-darwin* ]]; then
		append-ldflags -shared
	fi

	# only one fortran to link with:
	# linking with cblas and lapack library will force
	# autodetecting and linking to all available fortran compilers
	if use lapack; then
		append-fflags -fPIC
		NUMPY_FCONFIG="config_fc --noopt --noarch"
		# workaround bug 335908
		[[ $(tc-getFC) == *gfortran* ]] && NUMPY_FCONFIG+=" --fcompiler=gnu95"
	fi

	# don't version f2py, we will handle it.
	sed -i -e '/f2py_exe/s:+os\.path.*$::' numpy/f2py/setup.py || die

	distutils-r1_python_prepare_all
}

python_compile() {
	distutils-r1_python_compile ${NUMPY_FCONFIG}
}

python_test() {
	distutils_install_for_testing ${NUMPY_FCONFIG}

	cd "${TMPDIR}" || die
	${EPYTHON} -c "
import numpy, sys
r = numpy.test(verbose=3)
sys.exit(0 if r.wasSuccessful() else 1)" || die "Tests fail with ${EPYTHON}"
}

python_install() {
	distutils-r1_python_install ${NUMPY_FCONFIG}
}

python_install_all() {
	distutils-r1_python_install_all

	dodoc COMPATIBILITY DEV_README.txt THANKS.txt

	docinto f2py
	dodoc numpy/f2py/docs/*.txt
	doman numpy/f2py/f2py.1

	if use doc; then
		dohtml -r "${WORKDIR}"/html/*
		insinto /usr/share/doc/${PF}
		doins "${DISTDIR}"/${PN}-{user,ref}-${DOC_PV}.pdf
	fi
}
