# Copyright 1999-2015 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-python/logilab-common/logilab-common-0.63.2.ebuild,v 1.1 2015/01/26 17:00:30 vapier Exp $

EAPI=5

PYTHON_COMPAT=( python{2_7,3_2,3_3,3_4} pypy )

inherit distutils-r1 eutils

DESCRIPTION="Useful miscellaneous modules used by Logilab projects"
HOMEPAGE="http://www.logilab.org/project/logilab-common http://pypi.python.org/pypi/logilab-common"
SRC_URI="ftp://ftp.logilab.org/pub/common/${P}.tar.gz mirror://pypi/${PN:0:1}/${PN}/${P}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="*"
IUSE="test doc"

RDEPEND="dev-python/setuptools[${PYTHON_USEDEP}]"

# Tests using dev-python/psycopg are skipped when dev-python/psycopg isn't installed.
# egenix-mx-base tests are optional and supports python2 only.
DEPEND="${RDEPEND}
	test? (
		$(python_gen_cond_dep 'dev-python/egenix-mx-base[${PYTHON_USEDEP}]' python2_7)
		dev-python/pytz[${PYTHON_USEDEP}]
		!dev-python/psycopg[-mxdatetime]
	)
	doc? ( $(python_gen_cond_dep 'dev-python/epydoc[${PYTHON_USEDEP}]' python2_7) )"

PATCHES=(
	# Make sure setuptools does not create a zip file in python_test;
	# this is buggy and causes tests to fail.
	"${FILESDIR}/${PN}-0.59.1-zipsafe.patch"
)
# Req'd for impl specific failures in the testsuite
DISTUTILS_IN_SOURCE_BUILD=1

python_prepare_all() {
	sed -e 's:(CURDIR):{S}/${P}:' -i doc/makefile || die
	distutils-r1_python_prepare_all
}

python_compile_all() {
	if use doc; then
		# Based on the doc build in Arfrever's ebuild. It works
		pushd doc > /dev/null
		mkdir -p apidoc || die
		epydoc --parse-only -o apidoc --html -v --no-private --exclude=__pkginfo__ --exclude=setup --exclude=test \
			-n "Logilab's common library" "$(ls -d ../build/lib/logilab/common/)" build \
			|| die "Generation of documentation failed"
	fi
}

python_test() {
	distutils_install_for_testing

	# https://www.logilab.org/ticket/149345
	# Prevent timezone related failure.
	export TZ=UTC

	# Make sure that the tests use correct modules.
	pushd "${TEST_DIR}"/lib > /dev/null || die

	if python_is_python3; then
	# http://www.logilab.org/ticket/241813, 241807
	# The suite can be made to pass under py3.4 by disabling the class MxDateTC in unittest_date.py
	# These are covered by issue 241813.  Any and all methods to disable them temporarily
	# (assuming they will ever be fixed) are simply cumbersome in the extreme, thus impractical.
	# The failures are specific to py3.4's unittest's parameters in _addSkip and not the package itself.
		if [[ "${EPYTHON}" == "python3.4" ]]; then
			sed -e 's:test_any:_&:' \
				-i $(find . -name unittest_compat.py) || die
			sed -e 's:test_add_days_worked:_&:' \
				-i $(find . -name unittest_date.py) || die
		fi
	# Still one related failure under py3.4
	# Returns a clean run under py3.3, though leaving fails exposed in this bump of 0.62.1
	# https://www.logilab.org/ticket/269904
	# Also unittest_date.py known to fail related to absence of installed egenix-mx-base
	#	rm $(find . -name unittest_umessage.py) || die
	fi
	"${TEST_DIR}"/scripts/pytest || die "Tests fail with ${EPYTHON}"
	popd > /dev/null || die
}

python_install_all() {
	distutils-r1_python_install_all

	doman doc/pytest.1
	use doc &&  dohtml -r doc/apidoc/.
}
