
#=============================================================================
# Copyright 2006-2009 Kitware, Inc.
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================
# (To distribute this file outside of CMake, substitute the full
#  License text for the above reference.)

# Block multiple inclusion because "CMakeCInformation.cmake" includes
# "Platform/${CMAKE_SYSTEM_NAME}" even though the generic module
# "CMakeSystemSpecificInformation.cmake" already included it.
# The extra inclusion is a work-around documented next to the include()
# call, so this can be removed when the work-around is removed.
if(__UNIX_PATHS_INCLUDED)
  return()
endif()
set(__UNIX_PATHS_INCLUDED 1)

set(UNIX 1)

# also add the install directory of the running cmake to the search directories
# CMAKE_ROOT is CMAKE_INSTALL_PREFIX/share/cmake, so we need to go two levels up
get_filename_component(_CMAKE_INSTALL_DIR "${CMAKE_ROOT}" PATH)
get_filename_component(_CMAKE_INSTALL_DIR "${_CMAKE_INSTALL_DIR}" PATH)

# List common installation prefixes.  These will be used for all
# search types.
list(APPEND CMAKE_SYSTEM_PREFIX_PATH
  # Standard
  /usr/local /usr /
  /usr/local /usr /

  # CMake install location
  "${_CMAKE_INSTALL_DIR}"

  # Project install destination.
  "${CMAKE_INSTALL_PREFIX}"
  )

# List common include file locations not under the common prefixes.
list(APPEND CMAKE_SYSTEM_INCLUDE_PATH
  /usr/include
  )

list(APPEND CMAKE_SYSTEM_LIBRARY_PATH
  /usr/x86_64-pc-linux-gnu/lib//gcc
  /usr/x86_64-pc-linux-gnu/lib/
  /usr/lib64
  /usr/libx32
  /usr/lib32
  /usr/lib
  /lib
  )

list(APPEND CMAKE_SYSTEM_PROGRAM_PATH
  /usr/bin
  /bin
  )

list(APPEND CMAKE_PLATFORM_IMPLICIT_LINK_DIRECTORIES
  /usr/x86_64-pc-linux-gnu/lib//gcc
  /usr/x86_64-pc-linux-gnu/lib/
  /usr/lib64
  /usr/libx32
  /usr/lib32
  /usr/lib
  /lib
  /lib /usr/lib /usr/lib32 /usr/lib64 /usr/libx32
  )

list(APPEND CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES
  /usr/include
  /usr/include
  )
list(APPEND CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES
  /usr/include
  /usr/include
  )

# Enable use of lib64 search path variants by default.
set_property(GLOBAL PROPERTY FIND_LIBRARY_USE_LIB64_PATHS TRUE)
