/* Copyright (C) 2010 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by the GPL v2 license that can
 * be found in the LICENSE file.
 * 
 * Parts of this file are derived from the Linux kernel from the file with
 * the same name and path under include/.
 */
#ifndef VERITY_INCLUDE_ASM_PAGE_H_
#define VERITY_INCLUDE_ASM_PAGE_H_

#include <linux/types.h>

#define PAGE_SIZE 4096
#define PAGE_SHIFT 12

/* A, uh, simple page dummy. */
struct page {
  u8 data[PAGE_SIZE];
};

#define page_address(p) ((p)->data)
#define virt_to_page(x) ((struct page *)(x))

#endif  /* VERITY_INCLUDE_ASM_PAGE_H_ */
