// Automatic generation of D-Bus interface mock proxies for:
//  - org.chromium.UpdateEngineInterface
#ifndef ____CHROMEOS_DBUS_BINDING___VAR_CACHE_PORTAGE_CHROMEOS_BASE_UPDATE_ENGINE_CLIENT_OUT_DEFAULT_GEN_INCLUDE_UPDATE_ENGINE_DBUS_PROXY_MOCKS_H
#define ____CHROMEOS_DBUS_BINDING___VAR_CACHE_PORTAGE_CHROMEOS_BASE_UPDATE_ENGINE_CLIENT_OUT_DEFAULT_GEN_INCLUDE_UPDATE_ENGINE_DBUS_PROXY_MOCKS_H
#include <string>
#include <vector>

#include <base/callback_forward.h>
#include <base/logging.h>
#include <base/macros.h>
#include <brillo/any.h>
#include <brillo/errors/error.h>
#include <brillo/variant_dictionary.h>
#include <gmock/gmock.h>

#include "update_engine/dbus-proxies.h"

namespace org {
namespace chromium {

// Mock object for UpdateEngineInterfaceProxyInterface.
class UpdateEngineInterfaceProxyMock : public UpdateEngineInterfaceProxyInterface {
 public:
  UpdateEngineInterfaceProxyMock() = default;

  MOCK_METHOD4(AttemptUpdate,
               bool(const std::string& /*in_app_version*/,
                    const std::string& /*in_omaha_url*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD5(AttemptUpdateAsync,
               void(const std::string& /*in_app_version*/,
                    const std::string& /*in_omaha_url*/,
                    const base::Callback<void()>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD5(AttemptUpdateWithFlags,
               bool(const std::string& /*in_app_version*/,
                    const std::string& /*in_omaha_url*/,
                    int32_t /*in_flags*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD6(AttemptUpdateWithFlagsAsync,
               void(const std::string& /*in_app_version*/,
                    const std::string& /*in_omaha_url*/,
                    int32_t /*in_flags*/,
                    const base::Callback<void()>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(AttemptRollback,
               bool(bool /*in_powerwash*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD4(AttemptRollbackAsync,
               void(bool /*in_powerwash*/,
                    const base::Callback<void()>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(CanRollback,
               bool(bool* /*out_can_rollback*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(CanRollbackAsync,
               void(const base::Callback<void(bool /*can_rollback*/)>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD2(ResetStatus,
               bool(brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(ResetStatusAsync,
               void(const base::Callback<void()>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD7(GetStatus,
               bool(int64_t* /*out_last_checked_time*/,
                    double* /*out_progress*/,
                    std::string* /*out_current_operation*/,
                    std::string* /*out_new_version*/,
                    int64_t* /*out_new_size*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetStatusAsync,
               void(const base::Callback<void(int64_t /*last_checked_time*/, double /*progress*/, const std::string& /*current_operation*/, const std::string& /*new_version*/, int64_t /*new_size*/)>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD2(RebootIfNeeded,
               bool(brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(RebootIfNeededAsync,
               void(const base::Callback<void()>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD4(SetChannel,
               bool(const std::string& /*in_target_channel*/,
                    bool /*in_is_powerwash_allowed*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD5(SetChannelAsync,
               void(const std::string& /*in_target_channel*/,
                    bool /*in_is_powerwash_allowed*/,
                    const base::Callback<void()>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD4(GetChannel,
               bool(bool /*in_get_current_channel*/,
                    std::string* /*out_channel*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD4(GetChannelAsync,
               void(bool /*in_get_current_channel*/,
                    const base::Callback<void(const std::string& /*channel*/)>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(SetP2PUpdatePermission,
               bool(bool /*in_enabled*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD4(SetP2PUpdatePermissionAsync,
               void(bool /*in_enabled*/,
                    const base::Callback<void()>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetP2PUpdatePermission,
               bool(bool* /*out_enabled*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetP2PUpdatePermissionAsync,
               void(const base::Callback<void(bool /*enabled*/)>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(SetUpdateOverCellularPermission,
               bool(bool /*in_allowed*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD4(SetUpdateOverCellularPermissionAsync,
               void(bool /*in_allowed*/,
                    const base::Callback<void()>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetUpdateOverCellularPermission,
               bool(bool* /*out_allowed*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetUpdateOverCellularPermissionAsync,
               void(const base::Callback<void(bool /*allowed*/)>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetDurationSinceUpdate,
               bool(int64_t* /*out_usec_wallclock*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetDurationSinceUpdateAsync,
               void(const base::Callback<void(int64_t /*usec_wallclock*/)>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetPrevVersion,
               bool(std::string* /*out_prev_version*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetPrevVersionAsync,
               void(const base::Callback<void(const std::string& /*prev_version*/)>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetRollbackPartition,
               bool(std::string* /*out_rollback_partition_name*/,
                    brillo::ErrorPtr* /*error*/,
                    int /*timeout_ms*/));
  MOCK_METHOD3(GetRollbackPartitionAsync,
               void(const base::Callback<void(const std::string& /*rollback_partition_name*/)>& /*success_callback*/,
                    const base::Callback<void(brillo::Error*)>& /*error_callback*/,
                    int /*timeout_ms*/));
  MOCK_METHOD2(RegisterStatusUpdateSignalHandler,
               void(const base::Callback<void(int64_t,
                                              double,
                                              const std::string&,
                                              const std::string&,
                                              int64_t)>& /*signal_callback*/,
                    dbus::ObjectProxy::OnConnectedCallback /*on_connected_callback*/));
  MOCK_CONST_METHOD0(GetObjectPath, const dbus::ObjectPath&());

 private:
  DISALLOW_COPY_AND_ASSIGN(UpdateEngineInterfaceProxyMock);
};
}  // namespace chromium
}  // namespace org

#endif  // ____CHROMEOS_DBUS_BINDING___VAR_CACHE_PORTAGE_CHROMEOS_BASE_UPDATE_ENGINE_CLIENT_OUT_DEFAULT_GEN_INCLUDE_UPDATE_ENGINE_DBUS_PROXY_MOCKS_H
