# Copyright (c) 2013 The Chromium OS Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# Missing from socket
SO_TIMESTAMP = 29

# The remainder of this file was generated by extracting #defines from
# src/bluetooth.h and src/hci.h and converting them into Python variable
# declarations using:
#
#     grep '#define' | sed -e 's/^[ \t]*#define //' \
#                          -e 's/\([ \t]\)/\1= /'

# Constants from src/bluetooth.h

AF_BLUETOOTH = 31
PF_BLUETOOTH = AF_BLUETOOTH

BTPROTO_L2CAP  = 0
BTPROTO_HCI    = 1
BTPROTO_SCO    = 2
BTPROTO_RFCOMM = 3
BTPROTO_BNEP   = 4
BTPROTO_CMTP   = 5
BTPROTO_HIDP   = 6
BTPROTO_AVDTP  = 7

SOL_HCI       = 0
SOL_L2CAP     = 6
SOL_SCO       = 17
SOL_RFCOMM    = 18
SOL_BLUETOOTH = 274

BT_SECURITY        = 4
BT_SECURITY_SDP    = 0
BT_SECURITY_LOW    = 1
BT_SECURITY_MEDIUM = 2
BT_SECURITY_HIGH   = 3

BT_DEFER_SETUP = 7

BT_FLUSHABLE = 8

BT_FLUSHABLE_OFF = 0
BT_FLUSHABLE_ON  = 1

BT_CHANNEL_POLICY                 = 10
BT_CHANNEL_POLICY_BREDR_ONLY      = 0
BT_CHANNEL_POLICY_BREDR_PREFERRED = 1
BT_CHANNEL_POLICY_AMP_PREFERRED   = 2

BDADDR_BREDR     = 0x00
BDADDR_LE_PUBLIC = 0x01
BDADDR_LE_RANDOM = 0x02

BDADDR_ANY   = "00:00:00:00:00:00"
BDADDR_ALL   = "FF:FF:FF:FF:FF:FF"
BDADDR_LOCAL = "00:00:00:FF:FF:FF"

# Constants from src/l2cap.h
L2CAP_DEFAULT_MTU   = 672
L2CAP_DEFAULT_FLUSH_TO  = 0xFFFF
L2CAP_OPTIONS   = 0x01
L2CAP_CONNINFO  = 0x02
L2CAP_LM    = 0x03
L2CAP_LM_MASTER =   0x0001
L2CAP_LM_AUTH   =   0x0002
L2CAP_LM_ENCRYPT    = 0x0004
L2CAP_LM_TRUSTED    = 0x0008
L2CAP_LM_RELIABLE   = 0x0010
L2CAP_LM_SECURE =   0x0020
L2CAP_COMMAND_REJ   = 0x01
L2CAP_CONN_REQ  =   0x02
L2CAP_CONN_RSP  =   0x03
L2CAP_CONF_REQ  =   0x04
L2CAP_CONF_RSP  =   0x05
L2CAP_DISCONN_REQ   = 0x06
L2CAP_DISCONN_RSP   = 0x07
L2CAP_ECHO_REQ  =   0x08
L2CAP_ECHO_RSP  =   0x09
L2CAP_INFO_REQ  =   0x0a
L2CAP_INFO_RSP  =   0x0b
L2CAP_CREATE_REQ    = 0x0c
L2CAP_CREATE_RSP    = 0x0d
L2CAP_MOVE_REQ  =   0x0e
L2CAP_MOVE_RSP  =   0x0f
L2CAP_MOVE_CFM  =   0x10
L2CAP_MOVE_CFM_RSP  = 0x11
L2CAP_FEAT_FLOWCTL  = 0x00000001
L2CAP_FEAT_RETRANS  = 0x00000002
L2CAP_FEAT_BIDIR_QOS    = 0x00000004
L2CAP_FEAT_ERTM =   0x00000008
L2CAP_FEAT_STREAMING    = 0x00000010
L2CAP_FEAT_FCS  =   0x00000020
L2CAP_FEAT_EXT_FLOW = 0x00000040
L2CAP_FEAT_FIXED_CHAN   = 0x00000080
L2CAP_FEAT_EXT_WINDOW   = 0x00000100
L2CAP_FEAT_UCD  =   0x00000200
L2CAP_FC_L2CAP  =   0x02
L2CAP_FC_CONNLESS   = 0x04
L2CAP_FC_A2MP   =   0x08
L2CAP_HDR_SIZE = 4
L2CAP_CMD_HDR_SIZE = 4
L2CAP_CMD_REJ_SIZE = 2
L2CAP_CONN_REQ_SIZE = 4
L2CAP_CONN_RSP_SIZE = 8
L2CAP_CR_SUCCESS    = 0x0000
L2CAP_CR_PEND   =   0x0001
L2CAP_CR_BAD_PSM    = 0x0002
L2CAP_CR_SEC_BLOCK  = 0x0003
L2CAP_CR_NO_MEM =   0x0004
L2CAP_CS_NO_INFO    = 0x0000
L2CAP_CS_AUTHEN_PEND    = 0x0001
L2CAP_CS_AUTHOR_PEND    = 0x0002
L2CAP_CONF_REQ_SIZE = 4
L2CAP_CONF_RSP_SIZE = 6
L2CAP_CONF_SUCCESS  = 0x0000
L2CAP_CONF_UNACCEPT = 0x0001
L2CAP_CONF_REJECT   = 0x0002
L2CAP_CONF_UNKNOWN  = 0x0003
L2CAP_CONF_PENDING  = 0x0004
L2CAP_CONF_EFS_REJECT   = 0x0005
L2CAP_CONF_OPT_SIZE = 2
L2CAP_CONF_MTU  =   0x01
L2CAP_CONF_FLUSH_TO = 0x02
L2CAP_CONF_QOS  =   0x03
L2CAP_CONF_RFC  =   0x04
L2CAP_CONF_FCS  =   0x05
L2CAP_CONF_EFS  =   0x06
L2CAP_CONF_EWS  =   0x07
L2CAP_CONF_MAX_SIZE = 22
L2CAP_MODE_BASIC    = 0x00
L2CAP_MODE_RETRANS  = 0x01
L2CAP_MODE_FLOWCTL  = 0x02
L2CAP_MODE_ERTM =   0x03
L2CAP_MODE_STREAMING    = 0x04
L2CAP_SERVTYPE_NOTRAFFIC    = 0x00
L2CAP_SERVTYPE_BESTEFFORT   = 0x01
L2CAP_SERVTYPE_GUARANTEED   = 0x02
L2CAP_DISCONN_REQ_SIZE = 4
L2CAP_DISCONN_RSP_SIZE = 4
L2CAP_INFO_REQ_SIZE = 2
L2CAP_INFO_RSP_SIZE = 4
L2CAP_IT_CL_MTU =   0x0001
L2CAP_IT_FEAT_MASK  = 0x0002
L2CAP_IR_SUCCESS    = 0x0000
L2CAP_IR_NOTSUPP    = 0x0001
L2CAP_CREATE_REQ_SIZE = 5
L2CAP_CREATE_RSP_SIZE = 8
L2CAP_MOVE_REQ_SIZE = 3
L2CAP_MOVE_RSP_SIZE = 4
L2CAP_MOVE_CFM_SIZE = 4
L2CAP_MOVE_CFM_RSP_SIZE = 2

# Constants from src/rfcomm.h
RFCOMM_DEFAULT_MTU  = 127
RFCOMM_PSM = 3
RFCOMM_CONNINFO = 0x02
RFCOMM_LM   = 0x03
RFCOMM_LM_MASTER    = 0x0001
RFCOMM_LM_AUTH  =   0x0002
RFCOMM_LM_ENCRYPT   = 0x0004
RFCOMM_LM_TRUSTED   = 0x0008
RFCOMM_LM_RELIABLE  = 0x0010
RFCOMM_LM_SECURE    = 0x0020
RFCOMM_MAX_DEV  = 256
RFCOMM_REUSE_DLC    = 0
RFCOMM_RELEASE_ONHUP    = 1
RFCOMM_HANGUP_NOW   = 2
RFCOMM_TTY_ATTACHED = 3

# Constants from src/hci.h
HCI_MAX_DEV	= 16
HCI_MAX_ACL_SIZE	= (1492 + 4)
HCI_MAX_SCO_SIZE	= 255
HCI_MAX_EVENT_SIZE	= 260
HCI_MAX_FRAME_SIZE	= (HCI_MAX_ACL_SIZE + 4)
HCI_DEV_REG	= 1
HCI_DEV_UNREG	= 2
HCI_DEV_UP	= 3
HCI_DEV_DOWN	= 4
HCI_DEV_SUSPEND	= 5
HCI_DEV_RESUME	= 6
HCI_VIRTUAL	= 0
HCI_USB	= 	1
HCI_PCCARD	= 2
HCI_UART	= 3
HCI_RS232	= 4
HCI_PCI	= 	5
HCI_SDIO	= 6
HCI_BREDR	= 0x00
HCI_AMP	= 	0x01
HCI_COMMAND_PKT	= 	0x01
HCI_ACLDATA_PKT	= 	0x02
HCI_SCODATA_PKT	= 	0x03
HCI_EVENT_PKT	= 	0x04
HCI_VENDOR_PKT	= 	0xff
HCI_2DH1	= 0x0002
HCI_3DH1	= 0x0004
HCI_DM1	= 	0x0008
HCI_DH1	= 	0x0010
HCI_2DH3	= 0x0100
HCI_3DH3	= 0x0200
HCI_DM3	= 	0x0400
HCI_DH3	= 	0x0800
HCI_2DH5	= 0x1000
HCI_3DH5	= 0x2000
HCI_DM5	= 	0x4000
HCI_DH5	= 	0x8000
HCI_HV1	= 	0x0020
HCI_HV2	= 	0x0040
HCI_HV3	= 	0x0080
HCI_EV3	= 	0x0008
HCI_EV4	= 	0x0010
HCI_EV5	= 	0x0020
HCI_2EV3	= 0x0040
HCI_3EV3	= 0x0080
HCI_2EV5	= 0x0100
HCI_3EV5	= 0x0200
SCO_PTYPE_MASK	= (HCI_HV1 | HCI_HV2 | HCI_HV3)
ACL_PTYPE_MASK	= (HCI_DM1 | HCI_DH1 | HCI_DM3 | HCI_DH3 | HCI_DM5 | HCI_DH5)
HCI_UNKNOWN_COMMAND	= 		0x01
HCI_NO_CONNECTION	= 		0x02
HCI_HARDWARE_FAILURE	= 		0x03
HCI_PAGE_TIMEOUT	= 		0x04
HCI_AUTHENTICATION_FAILURE	= 	0x05
HCI_PIN_OR_KEY_MISSING	= 		0x06
HCI_MEMORY_FULL	= 			0x07
HCI_CONNECTION_TIMEOUT	= 		0x08
HCI_MAX_NUMBER_OF_CONNECTIONS	= 	0x09
HCI_MAX_NUMBER_OF_SCO_CONNECTIONS	= 0x0a
HCI_ACL_CONNECTION_EXISTS	= 	0x0b
HCI_COMMAND_DISALLOWED	= 		0x0c
HCI_REJECTED_LIMITED_RESOURCES	= 	0x0d
HCI_REJECTED_SECURITY	= 		0x0e
HCI_REJECTED_PERSONAL	= 		0x0f
HCI_HOST_TIMEOUT	= 		0x10
HCI_UNSUPPORTED_FEATURE	= 		0x11
HCI_INVALID_PARAMETERS	= 		0x12
HCI_OE_USER_ENDED_CONNECTION	= 	0x13
HCI_OE_LOW_RESOURCES	= 		0x14
HCI_OE_POWER_OFF	= 		0x15
HCI_CONNECTION_TERMINATED	= 	0x16
HCI_REPEATED_ATTEMPTS	= 		0x17
HCI_PAIRING_NOT_ALLOWED	= 		0x18
HCI_UNKNOWN_LMP_PDU	= 		0x19
HCI_UNSUPPORTED_REMOTE_FEATURE	= 	0x1a
HCI_SCO_OFFSET_REJECTED	= 		0x1b
HCI_SCO_INTERVAL_REJECTED	= 	0x1c
HCI_AIR_MODE_REJECTED	= 		0x1d
HCI_INVALID_LMP_PARAMETERS	= 	0x1e
HCI_UNSPECIFIED_ERROR	= 		0x1f
HCI_UNSUPPORTED_LMP_PARAMETER_VALUE	= 0x20
HCI_ROLE_CHANGE_NOT_ALLOWED	= 	0x21
HCI_LMP_RESPONSE_TIMEOUT	= 	0x22
HCI_LMP_ERROR_TRANSACTION_COLLISION	= 0x23
HCI_LMP_PDU_NOT_ALLOWED	= 		0x24
HCI_ENCRYPTION_MODE_NOT_ACCEPTED	= 0x25
HCI_UNIT_LINK_KEY_USED	= 		0x26
HCI_QOS_NOT_SUPPORTED	= 		0x27
HCI_INSTANT_PASSED	= 		0x28
HCI_PAIRING_NOT_SUPPORTED	= 	0x29
HCI_TRANSACTION_COLLISION	= 	0x2a
HCI_QOS_UNACCEPTABLE_PARAMETER	= 	0x2c
HCI_QOS_REJECTED	= 		0x2d
HCI_CLASSIFICATION_NOT_SUPPORTED	= 0x2e
HCI_INSUFFICIENT_SECURITY	= 	0x2f
HCI_PARAMETER_OUT_OF_RANGE	= 	0x30
HCI_ROLE_SWITCH_PENDING	= 		0x32
HCI_SLOT_VIOLATION	= 		0x34
HCI_ROLE_SWITCH_FAILED	= 		0x35
HCI_EIR_TOO_LARGE	= 		0x36
HCI_SIMPLE_PAIRING_NOT_SUPPORTED	= 0x37
HCI_HOST_BUSY_PAIRING	= 		0x38
ACL_START_NO_FLUSH	= 0x00
ACL_CONT	= 	0x01
ACL_START	= 	0x02
ACL_ACTIVE_BCAST	= 0x04
ACL_PICO_BCAST	= 	0x08
SCO_LINK	= 0x00
ACL_LINK	= 0x01
ESCO_LINK	= 0x02
LMP_3SLOT	= 0x01
LMP_5SLOT	= 0x02
LMP_ENCRYPT	= 0x04
LMP_SOFFSET	= 0x08
LMP_TACCURACY	= 0x10
LMP_RSWITCH	= 0x20
LMP_HOLD	= 0x40
LMP_SNIFF	= 0x80
LMP_PARK	= 0x01
LMP_RSSI	= 0x02
LMP_QUALITY	= 0x04
LMP_SCO	= 	0x08
LMP_HV2	= 	0x10
LMP_HV3	= 	0x20
LMP_ULAW	= 0x40
LMP_ALAW	= 0x80
LMP_CVSD	= 0x01
LMP_PSCHEME	= 0x02
LMP_PCONTROL	= 0x04
LMP_TRSP_SCO	= 0x08
LMP_BCAST_ENC	= 0x80
LMP_EDR_ACL_2M	= 0x02
LMP_EDR_ACL_3M	= 0x04
LMP_ENH_ISCAN	= 0x08
LMP_ILACE_ISCAN	= 0x10
LMP_ILACE_PSCAN	= 0x20
LMP_RSSI_INQ	= 0x40
LMP_ESCO	= 0x80
LMP_EV4	= 	0x01
LMP_EV5	= 	0x02
LMP_AFH_CAP_SLV	= 0x08
LMP_AFH_CLS_SLV	= 0x10
LMP_NO_BREDR	= 0x20
LMP_LE	= 	0x40
LMP_EDR_3SLOT	= 0x80
LMP_EDR_5SLOT	= 0x01
LMP_SNIFF_SUBR	= 0x02
LMP_PAUSE_ENC	= 0x04
LMP_AFH_CAP_MST	= 0x08
LMP_AFH_CLS_MST	= 0x10
LMP_EDR_ESCO_2M	= 0x20
LMP_EDR_ESCO_3M	= 0x40
LMP_EDR_3S_ESCO	= 0x80
LMP_EXT_INQ	= 0x01
LMP_LE_BREDR	= 0x02
LMP_SIMPLE_PAIR	= 0x08
LMP_ENCAPS_PDU	= 0x10
LMP_ERR_DAT_REP	= 0x20
LMP_NFLUSH_PKTS	= 0x40
LMP_LSTO	= 0x01
LMP_INQ_TX_PWR	= 0x02
LMP_EPC	= 	0x04
LMP_EXT_FEAT	= 0x80
LMP_HOST_SSP	= 	0x01
LMP_HOST_LE	= 	0x02
LMP_HOST_LE_BREDR	= 0x04
HCI_LP_RSWITCH	= 0x0001
HCI_LP_HOLD	= 0x0002
HCI_LP_SNIFF	= 0x0004
HCI_LP_PARK	= 0x0008
HCI_LM_ACCEPT	= 0x8000
HCI_LM_MASTER	= 0x0001
HCI_LM_AUTH	= 0x0002
HCI_LM_ENCRYPT	= 0x0004
HCI_LM_TRUSTED	= 0x0008
HCI_LM_RELIABLE	= 0x0010
HCI_LM_SECURE	= 0x0020
HCI_LK_COMBINATION	= 	0x00
HCI_LK_LOCAL_UNIT	= 	0x01
HCI_LK_REMOTE_UNIT	= 	0x02
HCI_LK_DEBUG_COMBINATION	= 0x03
HCI_LK_UNAUTH_COMBINATION	= 0x04
HCI_LK_AUTH_COMBINATION	= 	0x05
HCI_LK_CHANGED_COMBINATION	= 0x06
HCI_LK_INVALID	= 		0xFF
OGF_LINK_CTL	= 	0x01
OCF_INQUIRY	= 		0x0001
INQUIRY_CP_SIZE = 5
STATUS_BDADDR_RP_SIZE = 7
OCF_INQUIRY_CANCEL	= 	0x0002
OCF_PERIODIC_INQUIRY	= 	0x0003
PERIODIC_INQUIRY_CP_SIZE = 9
OCF_EXIT_PERIODIC_INQUIRY	= 0x0004
OCF_CREATE_CONN	= 		0x0005
CREATE_CONN_CP_SIZE = 13
OCF_DISCONNECT	= 		0x0006
DISCONNECT_CP_SIZE = 3
OCF_ADD_SCO	= 		0x0007
ADD_SCO_CP_SIZE = 4
OCF_CREATE_CONN_CANCEL	= 	0x0008
CREATE_CONN_CANCEL_CP_SIZE = 6
OCF_ACCEPT_CONN_REQ	= 	0x0009
ACCEPT_CONN_REQ_CP_SIZE	= 7
OCF_REJECT_CONN_REQ	= 	0x000A
REJECT_CONN_REQ_CP_SIZE	= 7
OCF_LINK_KEY_REPLY	= 	0x000B
LINK_KEY_REPLY_CP_SIZE = 22
OCF_LINK_KEY_NEG_REPLY	= 	0x000C
OCF_PIN_CODE_REPLY	= 	0x000D
PIN_CODE_REPLY_CP_SIZE = 23
OCF_PIN_CODE_NEG_REPLY	= 	0x000E
OCF_SET_CONN_PTYPE	= 	0x000F
SET_CONN_PTYPE_CP_SIZE = 4
OCF_AUTH_REQUESTED	= 	0x0011
AUTH_REQUESTED_CP_SIZE = 2
OCF_SET_CONN_ENCRYPT	= 	0x0013
SET_CONN_ENCRYPT_CP_SIZE = 3
OCF_CHANGE_CONN_LINK_KEY	= 0x0015
CHANGE_CONN_LINK_KEY_CP_SIZE = 2
OCF_MASTER_LINK_KEY	= 	0x0017
MASTER_LINK_KEY_CP_SIZE = 1
OCF_REMOTE_NAME_REQ	= 	0x0019
REMOTE_NAME_REQ_CP_SIZE = 10
OCF_REMOTE_NAME_REQ_CANCEL	= 0x001A
REMOTE_NAME_REQ_CANCEL_CP_SIZE = 6
OCF_READ_REMOTE_FEATURES	= 0x001B
READ_REMOTE_FEATURES_CP_SIZE = 2
OCF_READ_REMOTE_EXT_FEATURES	= 0x001C
READ_REMOTE_EXT_FEATURES_CP_SIZE = 3
OCF_READ_REMOTE_VERSION	= 	0x001D
READ_REMOTE_VERSION_CP_SIZE = 2
OCF_READ_CLOCK_OFFSET	= 	0x001F
READ_CLOCK_OFFSET_CP_SIZE = 2
OCF_READ_LMP_HANDLE	= 	0x0020
OCF_SETUP_SYNC_CONN	= 	0x0028
SETUP_SYNC_CONN_CP_SIZE = 17
OCF_ACCEPT_SYNC_CONN_REQ	= 0x0029
ACCEPT_SYNC_CONN_REQ_CP_SIZE = 21
OCF_REJECT_SYNC_CONN_REQ	= 0x002A
REJECT_SYNC_CONN_REQ_CP_SIZE = 7
OCF_IO_CAPABILITY_REPLY	= 	0x002B
IO_CAPABILITY_REPLY_CP_SIZE = 9
OCF_USER_CONFIRM_REPLY	= 	0x002C
USER_CONFIRM_REPLY_CP_SIZE = 6
OCF_USER_CONFIRM_NEG_REPLY	= 0x002D
OCF_USER_PASSKEY_REPLY	= 	0x002E
USER_PASSKEY_REPLY_CP_SIZE = 10
OCF_USER_PASSKEY_NEG_REPLY	= 0x002F
OCF_REMOTE_OOB_DATA_REPLY	= 0x0030
REMOTE_OOB_DATA_REPLY_CP_SIZE = 38
OCF_REMOTE_OOB_DATA_NEG_REPLY	= 0x0033
OCF_IO_CAPABILITY_NEG_REPLY	= 0x0034
IO_CAPABILITY_NEG_REPLY_CP_SIZE = 7
OCF_CREATE_PHYSICAL_LINK	= 	0x0035
CREATE_PHYSICAL_LINK_CP_SIZE = 35
OCF_ACCEPT_PHYSICAL_LINK	= 	0x0036
OCF_DISCONNECT_PHYSICAL_LINK	= 	0x0037
DISCONNECT_PHYSICAL_LINK_CP_SIZE = 2
OCF_CREATE_LOGICAL_LINK	= 	0x0038
CREATE_LOGICAL_LINK_CP_SIZE = 33
OCF_ACCEPT_LOGICAL_LINK	= 	0x0039
OCF_DISCONNECT_LOGICAL_LINK	= 	0x003A
DISCONNECT_LOGICAL_LINK_CP_SIZE = 2
OCF_LOGICAL_LINK_CANCEL	= 	0x003B
LOGICAL_LINK_CANCEL_CP_SIZE = 2
LOGICAL_LINK_CANCEL_RP_SIZE = 3
OCF_FLOW_SPEC_MODIFY	= 	0x003C
OGF_LINK_POLICY	= 	0x02
OCF_HOLD_MODE	= 		0x0001
HOLD_MODE_CP_SIZE = 6
OCF_SNIFF_MODE	= 		0x0003
SNIFF_MODE_CP_SIZE = 10
OCF_EXIT_SNIFF_MODE	= 	0x0004
EXIT_SNIFF_MODE_CP_SIZE = 2
OCF_PARK_MODE	= 		0x0005
PARK_MODE_CP_SIZE = 6
OCF_EXIT_PARK_MODE	= 	0x0006
EXIT_PARK_MODE_CP_SIZE = 2
OCF_QOS_SETUP	= 		0x0007
HCI_QOS_CP_SIZE = 17
QOS_SETUP_CP_SIZE = (3 + HCI_QOS_CP_SIZE)
OCF_ROLE_DISCOVERY	= 	0x0009
ROLE_DISCOVERY_CP_SIZE = 2
ROLE_DISCOVERY_RP_SIZE = 4
OCF_SWITCH_ROLE	= 		0x000B
SWITCH_ROLE_CP_SIZE = 7
OCF_READ_LINK_POLICY	= 	0x000C
READ_LINK_POLICY_CP_SIZE = 2
READ_LINK_POLICY_RP_SIZE = 5
OCF_WRITE_LINK_POLICY	= 	0x000D
WRITE_LINK_POLICY_CP_SIZE = 4
WRITE_LINK_POLICY_RP_SIZE = 3
OCF_READ_DEFAULT_LINK_POLICY	= 0x000E
OCF_WRITE_DEFAULT_LINK_POLICY	= 0x000F
OCF_FLOW_SPECIFICATION	= 	0x0010
OCF_SNIFF_SUBRATING	= 	0x0011
SNIFF_SUBRATING_CP_SIZE = 8
OGF_HOST_CTL	= 	0x03
OCF_SET_EVENT_MASK	= 	0x0001
SET_EVENT_MASK_CP_SIZE = 8
OCF_RESET	= 		0x0003
OCF_SET_EVENT_FLT	= 	0x0005
SET_EVENT_FLT_CP_SIZE = 2
FLT_CLEAR_ALL	= 		0x00
FLT_INQ_RESULT	= 		0x01
FLT_CONN_SETUP	= 		0x02
INQ_RESULT_RETURN_ALL	= 	0x00
INQ_RESULT_RETURN_CLASS	= 	0x01
INQ_RESULT_RETURN_BDADDR	= 0x02
CONN_SETUP_ALLOW_ALL	= 	0x00
CONN_SETUP_ALLOW_CLASS	= 	0x01
CONN_SETUP_ALLOW_BDADDR	= 	0x02
CONN_SETUP_AUTO_OFF	= 	0x01
CONN_SETUP_AUTO_ON	= 	0x02
OCF_FLUSH	= 		0x0008
OCF_READ_PIN_TYPE	= 	0x0009
READ_PIN_TYPE_RP_SIZE = 2
OCF_WRITE_PIN_TYPE	= 	0x000A
WRITE_PIN_TYPE_CP_SIZE = 1
OCF_CREATE_NEW_UNIT_KEY	= 	0x000B
OCF_READ_STORED_LINK_KEY	= 0x000D
READ_STORED_LINK_KEY_CP_SIZE = 7
READ_STORED_LINK_KEY_RP_SIZE = 5
OCF_WRITE_STORED_LINK_KEY	= 0x0011
WRITE_STORED_LINK_KEY_CP_SIZE = 1
READ_WRITE_LINK_KEY_RP_SIZE = 2
OCF_DELETE_STORED_LINK_KEY	= 0x0012
DELETE_STORED_LINK_KEY_CP_SIZE = 7
DELETE_STORED_LINK_KEY_RP_SIZE = 3
HCI_MAX_NAME_LENGTH	= 	248
OCF_CHANGE_LOCAL_NAME	= 	0x0013
CHANGE_LOCAL_NAME_CP_SIZE = 248
OCF_READ_LOCAL_NAME	= 	0x0014
READ_LOCAL_NAME_RP_SIZE = 249
OCF_READ_CONN_ACCEPT_TIMEOUT	= 0x0015
READ_CONN_ACCEPT_TIMEOUT_RP_SIZE = 3
OCF_WRITE_CONN_ACCEPT_TIMEOUT	= 0x0016
WRITE_CONN_ACCEPT_TIMEOUT_CP_SIZE = 2
OCF_READ_PAGE_TIMEOUT	= 	0x0017
READ_PAGE_TIMEOUT_RP_SIZE = 3
OCF_WRITE_PAGE_TIMEOUT	= 	0x0018
WRITE_PAGE_TIMEOUT_CP_SIZE = 2
OCF_READ_SCAN_ENABLE	= 	0x0019
READ_SCAN_ENABLE_RP_SIZE = 2
OCF_WRITE_SCAN_ENABLE	= 	0x001A
SCAN_DISABLED	= 	0x00
SCAN_INQUIRY	= 	0x01
SCAN_PAGE	= 	0x02
OCF_READ_PAGE_ACTIVITY	= 	0x001B
READ_PAGE_ACTIVITY_RP_SIZE = 5
OCF_WRITE_PAGE_ACTIVITY	= 	0x001C
WRITE_PAGE_ACTIVITY_CP_SIZE = 4
OCF_READ_INQ_ACTIVITY	= 	0x001D
READ_INQ_ACTIVITY_RP_SIZE = 5
OCF_WRITE_INQ_ACTIVITY	= 	0x001E
WRITE_INQ_ACTIVITY_CP_SIZE = 4
OCF_READ_AUTH_ENABLE	= 	0x001F
OCF_WRITE_AUTH_ENABLE	= 	0x0020
AUTH_DISABLED	= 	0x00
AUTH_ENABLED	= 	0x01
OCF_READ_ENCRYPT_MODE	= 	0x0021
OCF_WRITE_ENCRYPT_MODE	= 	0x0022
ENCRYPT_DISABLED	= 0x00
ENCRYPT_P2P	= 	0x01
ENCRYPT_BOTH	= 	0x02
OCF_READ_CLASS_OF_DEV	= 	0x0023
READ_CLASS_OF_DEV_RP_SIZE = 4
OCF_WRITE_CLASS_OF_DEV	= 	0x0024
WRITE_CLASS_OF_DEV_CP_SIZE = 3
OCF_READ_VOICE_SETTING	= 	0x0025
READ_VOICE_SETTING_RP_SIZE = 3
OCF_WRITE_VOICE_SETTING	= 	0x0026
WRITE_VOICE_SETTING_CP_SIZE = 2
OCF_READ_AUTOMATIC_FLUSH_TIMEOUT	= 0x0027
OCF_WRITE_AUTOMATIC_FLUSH_TIMEOUT	= 0x0028
OCF_READ_NUM_BROADCAST_RETRANS	= 0x0029
OCF_WRITE_NUM_BROADCAST_RETRANS	= 0x002A
OCF_READ_HOLD_MODE_ACTIVITY	= 0x002B
OCF_WRITE_HOLD_MODE_ACTIVITY	= 0x002C
OCF_READ_TRANSMIT_POWER_LEVEL	= 0x002D
READ_TRANSMIT_POWER_LEVEL_CP_SIZE = 3
READ_TRANSMIT_POWER_LEVEL_RP_SIZE = 4
OCF_READ_SYNC_FLOW_ENABLE	= 0x002E
OCF_WRITE_SYNC_FLOW_ENABLE	= 0x002F
OCF_SET_CONTROLLER_TO_HOST_FC	= 0x0031
OCF_HOST_BUFFER_SIZE	= 	0x0033
HOST_BUFFER_SIZE_CP_SIZE = 7
OCF_HOST_NUM_COMP_PKTS	= 	0x0035
HOST_NUM_COMP_PKTS_CP_SIZE = 1
OCF_READ_LINK_SUPERVISION_TIMEOUT	= 0x0036
READ_LINK_SUPERVISION_TIMEOUT_RP_SIZE = 5
OCF_WRITE_LINK_SUPERVISION_TIMEOUT	= 0x0037
WRITE_LINK_SUPERVISION_TIMEOUT_CP_SIZE = 4
WRITE_LINK_SUPERVISION_TIMEOUT_RP_SIZE = 3
OCF_READ_NUM_SUPPORTED_IAC	= 0x0038
MAX_IAC_LAP = 0x40
OCF_READ_CURRENT_IAC_LAP	= 0x0039
READ_CURRENT_IAC_LAP_RP_SIZE = 2+3*MAX_IAC_LAP
OCF_WRITE_CURRENT_IAC_LAP	= 0x003A
WRITE_CURRENT_IAC_LAP_CP_SIZE = 1+3*MAX_IAC_LAP
OCF_READ_PAGE_SCAN_PERIOD_MODE	= 0x003B
OCF_WRITE_PAGE_SCAN_PERIOD_MODE	= 0x003C
OCF_READ_PAGE_SCAN_MODE	= 	0x003D
OCF_WRITE_PAGE_SCAN_MODE	= 0x003E
OCF_SET_AFH_CLASSIFICATION	= 0x003F
SET_AFH_CLASSIFICATION_CP_SIZE = 10
SET_AFH_CLASSIFICATION_RP_SIZE = 1
OCF_READ_INQUIRY_SCAN_TYPE	= 0x0042
READ_INQUIRY_SCAN_TYPE_RP_SIZE = 2
OCF_WRITE_INQUIRY_SCAN_TYPE	= 0x0043
WRITE_INQUIRY_SCAN_TYPE_CP_SIZE = 1
WRITE_INQUIRY_SCAN_TYPE_RP_SIZE = 1
OCF_READ_INQUIRY_MODE	= 	0x0044
READ_INQUIRY_MODE_RP_SIZE = 2
OCF_WRITE_INQUIRY_MODE	= 	0x0045
WRITE_INQUIRY_MODE_CP_SIZE = 1
WRITE_INQUIRY_MODE_RP_SIZE = 1
OCF_READ_PAGE_SCAN_TYPE	= 	0x0046
OCF_WRITE_PAGE_SCAN_TYPE	= 0x0047
PAGE_SCAN_TYPE_STANDARD	= 	0x00
PAGE_SCAN_TYPE_INTERLACED	= 0x01
OCF_READ_AFH_MODE	= 	0x0048
READ_AFH_MODE_RP_SIZE = 2
OCF_WRITE_AFH_MODE	= 	0x0049
WRITE_AFH_MODE_CP_SIZE = 1
WRITE_AFH_MODE_RP_SIZE = 1
HCI_MAX_EIR_LENGTH	= 	240
OCF_READ_EXT_INQUIRY_RESPONSE	= 0x0051
READ_EXT_INQUIRY_RESPONSE_RP_SIZE = 242
OCF_WRITE_EXT_INQUIRY_RESPONSE	= 0x0052
WRITE_EXT_INQUIRY_RESPONSE_CP_SIZE = 241
WRITE_EXT_INQUIRY_RESPONSE_RP_SIZE = 1
OCF_REFRESH_ENCRYPTION_KEY	= 0x0053
REFRESH_ENCRYPTION_KEY_CP_SIZE = 2
REFRESH_ENCRYPTION_KEY_RP_SIZE = 1
OCF_READ_SIMPLE_PAIRING_MODE	= 0x0055
READ_SIMPLE_PAIRING_MODE_RP_SIZE = 2
OCF_WRITE_SIMPLE_PAIRING_MODE	= 0x0056
WRITE_SIMPLE_PAIRING_MODE_CP_SIZE = 1
WRITE_SIMPLE_PAIRING_MODE_RP_SIZE = 1
OCF_READ_LOCAL_OOB_DATA	= 	0x0057
READ_LOCAL_OOB_DATA_RP_SIZE = 33
OCF_READ_INQ_RESPONSE_TX_POWER_LEVEL	= 0x0058
READ_INQ_RESPONSE_TX_POWER_LEVEL_RP_SIZE = 2
OCF_READ_INQUIRY_TRANSMIT_POWER_LEVEL	= 0x0058
READ_INQUIRY_TRANSMIT_POWER_LEVEL_RP_SIZE = 2
OCF_WRITE_INQUIRY_TRANSMIT_POWER_LEVEL	= 0x0059
WRITE_INQUIRY_TRANSMIT_POWER_LEVEL_CP_SIZE = 1
WRITE_INQUIRY_TRANSMIT_POWER_LEVEL_RP_SIZE = 1
OCF_READ_DEFAULT_ERROR_DATA_REPORTING	= 0x005A
READ_DEFAULT_ERROR_DATA_REPORTING_RP_SIZE = 2
OCF_WRITE_DEFAULT_ERROR_DATA_REPORTING	= 0x005B
WRITE_DEFAULT_ERROR_DATA_REPORTING_CP_SIZE = 1
WRITE_DEFAULT_ERROR_DATA_REPORTING_RP_SIZE = 1
OCF_ENHANCED_FLUSH	= 	0x005F
ENHANCED_FLUSH_CP_SIZE = 3
OCF_SEND_KEYPRESS_NOTIFY	= 0x0060
SEND_KEYPRESS_NOTIFY_CP_SIZE = 7
SEND_KEYPRESS_NOTIFY_RP_SIZE = 1
OCF_READ_LOGICAL_LINK_ACCEPT_TIMEOUT	=  0x0061
READ_LOGICAL_LINK_ACCEPT_TIMEOUT_RP_SIZE = 3
OCF_WRITE_LOGICAL_LINK_ACCEPT_TIMEOUT	= 0x0062
WRITE_LOGICAL_LINK_ACCEPT_TIMEOUT_CP_SIZE = 2
OCF_SET_EVENT_MASK_PAGE_2	= 0x0063
OCF_READ_LOCATION_DATA	= 	0x0064
OCF_WRITE_LOCATION_DATA	= 0x0065
OCF_READ_FLOW_CONTROL_MODE	= 0x0066
OCF_WRITE_FLOW_CONTROL_MODE	= 0x0067
OCF_READ_ENHANCED_TRANSMIT_POWER_LEVEL	= 0x0068
READ_ENHANCED_TRANSMIT_POWER_LEVEL_RP_SIZE = 6
OCF_READ_BEST_EFFORT_FLUSH_TIMEOUT	= 0x0069
READ_BEST_EFFORT_FLUSH_TIMEOUT_RP_SIZE = 5
OCF_WRITE_BEST_EFFORT_FLUSH_TIMEOUT	= 0x006A
WRITE_BEST_EFFORT_FLUSH_TIMEOUT_CP_SIZE = 6
WRITE_BEST_EFFORT_FLUSH_TIMEOUT_RP_SIZE = 1
OCF_READ_LE_HOST_SUPPORTED	= 0x006C
READ_LE_HOST_SUPPORTED_RP_SIZE = 3
OCF_WRITE_LE_HOST_SUPPORTED	= 0x006D
WRITE_LE_HOST_SUPPORTED_CP_SIZE = 2
OGF_INFO_PARAM	= 	0x04
OCF_READ_LOCAL_VERSION	= 	0x0001
READ_LOCAL_VERSION_RP_SIZE = 9
OCF_READ_LOCAL_COMMANDS	= 	0x0002
READ_LOCAL_COMMANDS_RP_SIZE = 65
OCF_READ_LOCAL_FEATURES	= 	0x0003
READ_LOCAL_FEATURES_RP_SIZE = 9
OCF_READ_LOCAL_EXT_FEATURES	= 0x0004
READ_LOCAL_EXT_FEATURES_CP_SIZE = 1
READ_LOCAL_EXT_FEATURES_RP_SIZE = 11
OCF_READ_BUFFER_SIZE	= 	0x0005
READ_BUFFER_SIZE_RP_SIZE = 8
OCF_READ_COUNTRY_CODE	= 	0x0007
OCF_READ_BD_ADDR	= 	0x0009
READ_BD_ADDR_RP_SIZE = 7
OCF_READ_DATA_BLOCK_SIZE	= 0x000A
OGF_STATUS_PARAM	= 0x05
OCF_READ_FAILED_CONTACT_COUNTER	= 	0x0001
READ_FAILED_CONTACT_COUNTER_RP_SIZE = 4
OCF_RESET_FAILED_CONTACT_COUNTER	= 0x0002
RESET_FAILED_CONTACT_COUNTER_RP_SIZE = 4
OCF_READ_LINK_QUALITY	= 	0x0003
READ_LINK_QUALITY_RP_SIZE = 4
OCF_READ_RSSI	= 		0x0005
READ_RSSI_RP_SIZE = 4
OCF_READ_AFH_MAP	= 	0x0006
READ_AFH_MAP_RP_SIZE = 14
OCF_READ_CLOCK	= 		0x0007
READ_CLOCK_CP_SIZE = 3
READ_CLOCK_RP_SIZE = 9
OCF_READ_LOCAL_AMP_INFO	= 0x0009
READ_LOCAL_AMP_INFO_RP_SIZE = 31
OCF_READ_LOCAL_AMP_ASSOC	= 0x000A
READ_LOCAL_AMP_ASSOC_CP_SIZE = 5
READ_LOCAL_AMP_ASSOC_RP_SIZE = 252
OCF_WRITE_REMOTE_AMP_ASSOC	= 0x000B
WRITE_REMOTE_AMP_ASSOC_CP_SIZE = 253
WRITE_REMOTE_AMP_ASSOC_RP_SIZE = 2
OGF_TESTING_CMD	= 	0x3e
OCF_READ_LOOPBACK_MODE	= 		0x0001
OCF_WRITE_LOOPBACK_MODE	= 		0x0002
OCF_ENABLE_DEVICE_UNDER_TEST_MODE	= 0x0003
OCF_WRITE_SIMPLE_PAIRING_DEBUG_MODE	= 0x0004
WRITE_SIMPLE_PAIRING_DEBUG_MODE_CP_SIZE = 1
WRITE_SIMPLE_PAIRING_DEBUG_MODE_RP_SIZE = 1
OGF_LE_CTL	= 	0x08
OCF_LE_SET_EVENT_MASK	= 		0x0001
LE_SET_EVENT_MASK_CP_SIZE = 8
OCF_LE_READ_BUFFER_SIZE	= 		0x0002
LE_READ_BUFFER_SIZE_RP_SIZE = 4
OCF_LE_READ_LOCAL_SUPPORTED_FEATURES	= 0x0003
LE_READ_LOCAL_SUPPORTED_FEATURES_RP_SIZE = 9
OCF_LE_SET_RANDOM_ADDRESS	= 	0x0005
LE_SET_RANDOM_ADDRESS_CP_SIZE = 6
OCF_LE_SET_ADVERTISING_PARAMETERS	= 0x0006
LE_SET_ADVERTISING_PARAMETERS_CP_SIZE = 15
OCF_LE_READ_ADVERTISING_CHANNEL_TX_POWER	= 0x0007
LE_READ_ADVERTISING_CHANNEL_TX_POWER_RP_SIZE = 2
OCF_LE_SET_ADVERTISING_DATA	= 	0x0008
LE_SET_ADVERTISING_DATA_CP_SIZE = 32
OCF_LE_SET_SCAN_RESPONSE_DATA	= 	0x0009
LE_SET_SCAN_RESPONSE_DATA_CP_SIZE = 32
OCF_LE_SET_ADVERTISE_ENABLE	= 	0x000A
LE_SET_ADVERTISE_ENABLE_CP_SIZE = 1
OCF_LE_SET_SCAN_PARAMETERS	= 	0x000B
LE_SET_SCAN_PARAMETERS_CP_SIZE = 7
OCF_LE_SET_SCAN_ENABLE	= 		0x000C
LE_SET_SCAN_ENABLE_CP_SIZE = 2
OCF_LE_CREATE_CONN	= 		0x000D
LE_CREATE_CONN_CP_SIZE = 25
OCF_LE_CREATE_CONN_CANCEL	= 	0x000E
OCF_LE_READ_WHITE_LIST_SIZE	= 	0x000F
LE_READ_WHITE_LIST_SIZE_RP_SIZE = 2
OCF_LE_CLEAR_WHITE_LIST	= 		0x0010
OCF_LE_ADD_DEVICE_TO_WHITE_LIST	= 	0x0011
LE_ADD_DEVICE_TO_WHITE_LIST_CP_SIZE = 7
OCF_LE_REMOVE_DEVICE_FROM_WHITE_LIST	= 0x0012
LE_REMOVE_DEVICE_FROM_WHITE_LIST_CP_SIZE = 7
OCF_LE_CONN_UPDATE	= 		0x0013
LE_CONN_UPDATE_CP_SIZE = 14
OCF_LE_SET_HOST_CHANNEL_CLASSIFICATION	= 0x0014
LE_SET_HOST_CHANNEL_CLASSIFICATION_CP_SIZE = 5
OCF_LE_READ_CHANNEL_MAP	= 		0x0015
LE_READ_CHANNEL_MAP_CP_SIZE = 2
LE_READ_CHANNEL_MAP_RP_SIZE = 8
OCF_LE_READ_REMOTE_USED_FEATURES	= 0x0016
LE_READ_REMOTE_USED_FEATURES_CP_SIZE = 2
OCF_LE_ENCRYPT	= 			0x0017
LE_ENCRYPT_CP_SIZE = 32
LE_ENCRYPT_RP_SIZE = 17
OCF_LE_RAND	= 			0x0018
LE_RAND_RP_SIZE = 9
OCF_LE_START_ENCRYPTION	= 		0x0019
LE_START_ENCRYPTION_CP_SIZE = 28
OCF_LE_LTK_REPLY	= 		0x001A
LE_LTK_REPLY_CP_SIZE = 18
LE_LTK_REPLY_RP_SIZE = 3
OCF_LE_LTK_NEG_REPLY	= 		0x001B
LE_LTK_NEG_REPLY_CP_SIZE = 2
LE_LTK_NEG_REPLY_RP_SIZE = 3
OCF_LE_READ_SUPPORTED_STATES	= 	0x001C
LE_READ_SUPPORTED_STATES_RP_SIZE = 9
OCF_LE_RECEIVER_TEST	= 		0x001D
LE_RECEIVER_TEST_CP_SIZE = 1
OCF_LE_TRANSMITTER_TEST	= 		0x001E
LE_TRANSMITTER_TEST_CP_SIZE = 3
OCF_LE_TEST_END	= 			0x001F
LE_TEST_END_RP_SIZE = 3
OGF_VENDOR_CMD	= 	0x3f
EVT_INQUIRY_COMPLETE	= 	0x01
EVT_INQUIRY_RESULT	= 	0x02
INQUIRY_INFO_SIZE = 14
EVT_CONN_COMPLETE	= 	0x03
EVT_CONN_COMPLETE_SIZE = 11
EVT_CONN_REQUEST	= 	0x04
EVT_CONN_REQUEST_SIZE = 10
EVT_DISCONN_COMPLETE	= 	0x05
EVT_DISCONN_COMPLETE_SIZE = 4
EVT_AUTH_COMPLETE	= 	0x06
EVT_AUTH_COMPLETE_SIZE = 3
EVT_REMOTE_NAME_REQ_COMPLETE	= 0x07
EVT_REMOTE_NAME_REQ_COMPLETE_SIZE = 255
EVT_ENCRYPT_CHANGE	= 	0x08
EVT_ENCRYPT_CHANGE_SIZE = 5
EVT_CHANGE_CONN_LINK_KEY_COMPLETE	= 0x09
EVT_CHANGE_CONN_LINK_KEY_COMPLETE_SIZE = 3
EVT_MASTER_LINK_KEY_COMPLETE	= 	0x0A
EVT_MASTER_LINK_KEY_COMPLETE_SIZE = 4
EVT_READ_REMOTE_FEATURES_COMPLETE	= 0x0B
EVT_READ_REMOTE_FEATURES_COMPLETE_SIZE = 11
EVT_READ_REMOTE_VERSION_COMPLETE	= 0x0C
EVT_READ_REMOTE_VERSION_COMPLETE_SIZE = 8
EVT_QOS_SETUP_COMPLETE	= 	0x0D
EVT_QOS_SETUP_COMPLETE_SIZE = (4 + HCI_QOS_CP_SIZE)
EVT_CMD_COMPLETE = 		0x0E
EVT_CMD_COMPLETE_SIZE = 3
EVT_CMD_STATUS = 			0x0F
EVT_CMD_STATUS_SIZE = 4
EVT_HARDWARE_ERROR	= 	0x10
EVT_HARDWARE_ERROR_SIZE = 1
EVT_FLUSH_OCCURRED	= 	0x11
EVT_FLUSH_OCCURRED_SIZE = 2
EVT_ROLE_CHANGE	= 		0x12
EVT_ROLE_CHANGE_SIZE = 8
EVT_NUM_COMP_PKTS	= 	0x13
EVT_NUM_COMP_PKTS_SIZE = 1
EVT_MODE_CHANGE	= 		0x14
EVT_MODE_CHANGE_SIZE = 6
EVT_RETURN_LINK_KEYS	= 	0x15
EVT_RETURN_LINK_KEYS_SIZE = 1
EVT_PIN_CODE_REQ	= 	0x16
EVT_PIN_CODE_REQ_SIZE = 6
EVT_LINK_KEY_REQ	= 	0x17
EVT_LINK_KEY_REQ_SIZE = 6
EVT_LINK_KEY_NOTIFY	= 	0x18
EVT_LINK_KEY_NOTIFY_SIZE = 23
EVT_LOOPBACK_COMMAND	= 	0x19
EVT_DATA_BUFFER_OVERFLOW	= 0x1A
EVT_DATA_BUFFER_OVERFLOW_SIZE = 1
EVT_MAX_SLOTS_CHANGE	= 	0x1B
EVT_MAX_SLOTS_CHANGE_SIZE = 3
EVT_READ_CLOCK_OFFSET_COMPLETE	= 0x1C
EVT_READ_CLOCK_OFFSET_COMPLETE_SIZE = 5
EVT_CONN_PTYPE_CHANGED	= 	0x1D
EVT_CONN_PTYPE_CHANGED_SIZE = 5
EVT_QOS_VIOLATION	= 	0x1E
EVT_QOS_VIOLATION_SIZE = 2
EVT_PSCAN_REP_MODE_CHANGE	= 0x20
EVT_PSCAN_REP_MODE_CHANGE_SIZE = 7
EVT_FLOW_SPEC_COMPLETE	= 	0x21
EVT_FLOW_SPEC_COMPLETE_SIZE = (5 + HCI_QOS_CP_SIZE)
EVT_INQUIRY_RESULT_WITH_RSSI	= 0x22
INQUIRY_INFO_WITH_RSSI_SIZE = 14
INQUIRY_INFO_WITH_RSSI_AND_PSCAN_MODE_SIZE = 15
EVT_READ_REMOTE_EXT_FEATURES_COMPLETE	= 0x23
EVT_READ_REMOTE_EXT_FEATURES_COMPLETE_SIZE = 13
EVT_SYNC_CONN_COMPLETE	= 	0x2C
EVT_SYNC_CONN_COMPLETE_SIZE = 17
EVT_SYNC_CONN_CHANGED	= 	0x2D
EVT_SYNC_CONN_CHANGED_SIZE = 9
EVT_SNIFF_SUBRATING	= 	0x2E
EVT_SNIFF_SUBRATING_SIZE = 11
EVT_EXTENDED_INQUIRY_RESULT	= 0x2F
EXTENDED_INQUIRY_INFO_SIZE = 254
EVT_ENCRYPTION_KEY_REFRESH_COMPLETE	= 0x30
EVT_ENCRYPTION_KEY_REFRESH_COMPLETE_SIZE = 3
EVT_IO_CAPABILITY_REQUEST	= 0x31
EVT_IO_CAPABILITY_REQUEST_SIZE = 6
EVT_IO_CAPABILITY_RESPONSE	= 0x32
EVT_IO_CAPABILITY_RESPONSE_SIZE = 9
EVT_USER_CONFIRM_REQUEST	= 0x33
EVT_USER_CONFIRM_REQUEST_SIZE = 10
EVT_USER_PASSKEY_REQUEST	= 0x34
EVT_USER_PASSKEY_REQUEST_SIZE = 6
EVT_REMOTE_OOB_DATA_REQUEST	= 0x35
EVT_REMOTE_OOB_DATA_REQUEST_SIZE = 6
EVT_SIMPLE_PAIRING_COMPLETE	= 0x36
EVT_SIMPLE_PAIRING_COMPLETE_SIZE = 7
EVT_LINK_SUPERVISION_TIMEOUT_CHANGED	= 0x38
EVT_LINK_SUPERVISION_TIMEOUT_CHANGED_SIZE = 4
EVT_ENHANCED_FLUSH_COMPLETE	= 0x39
EVT_ENHANCED_FLUSH_COMPLETE_SIZE = 2
EVT_USER_PASSKEY_NOTIFY	= 	0x3B
EVT_USER_PASSKEY_NOTIFY_SIZE = 10
EVT_KEYPRESS_NOTIFY	= 	0x3C
EVT_KEYPRESS_NOTIFY_SIZE = 7
EVT_REMOTE_HOST_FEATURES_NOTIFY	= 0x3D
EVT_REMOTE_HOST_FEATURES_NOTIFY_SIZE = 14
EVT_LE_META_EVENT	= 0x3E
EVT_LE_META_EVENT_SIZE = 1
EVT_LE_CONN_COMPLETE	= 0x01
EVT_LE_CONN_COMPLETE_SIZE = 18
EVT_LE_ADVERTISING_REPORT	= 0x02
LE_ADVERTISING_INFO_SIZE = 9
EVT_LE_CONN_UPDATE_COMPLETE	= 0x03
EVT_LE_CONN_UPDATE_COMPLETE_SIZE = 9
EVT_LE_READ_REMOTE_USED_FEATURES_COMPLETE	= 0x04
EVT_LE_READ_REMOTE_USED_FEATURES_COMPLETE_SIZE = 11
EVT_LE_LTK_REQUEST	= 0x05
EVT_LE_LTK_REQUEST_SIZE = 12
EVT_PHYSICAL_LINK_COMPLETE	= 	0x40
EVT_PHYSICAL_LINK_COMPLETE_SIZE = 2
EVT_CHANNEL_SELECTED	= 	0x41
EVT_DISCONNECT_PHYSICAL_LINK_COMPLETE	= 0x42
EVT_DISCONNECT_PHYSICAL_LINK_COMPLETE_SIZE = 3
EVT_PHYSICAL_LINK_LOSS_EARLY_WARNING	= 0x43
EVT_PHYSICAL_LINK_LOSS_WARNING_SIZE = 2
EVT_PHYSICAL_LINK_RECOVERY	= 	0x44
EVT_PHYSICAL_LINK_RECOVERY_SIZE = 1
EVT_LOGICAL_LINK_COMPLETE	= 	0x45
EVT_LOGICAL_LINK_COMPLETE_SIZE = 5
EVT_DISCONNECT_LOGICAL_LINK_COMPLETE	= 0x46
EVT_FLOW_SPEC_MODIFY_COMPLETE	= 	0x47
EVT_FLOW_SPEC_MODIFY_COMPLETE_SIZE = 3
EVT_NUMBER_COMPLETED_BLOCKS	= 	0x48
EVT_AMP_STATUS_CHANGE	= 		0x4D
EVT_AMP_STATUS_CHANGE_SIZE = 2
EVT_TESTING	= 		0xFE
EVT_VENDOR	= 		0xFF
EVT_STACK_INTERNAL	= 	0xFD
EVT_STACK_INTERNAL_SIZE = 2
EVT_SI_DEVICE	= 0x01
EVT_SI_DEVICE_SIZE = 4
HCI_TYPE_LEN	= 1
HCI_COMMAND_HDR_SIZE = 	3
HCI_EVENT_HDR_SIZE = 	2
HCI_ACL_HDR_SIZE = 	4
HCI_SCO_HDR_SIZE = 	3
HCI_MSG_HDR_SIZE	= 6
HCI_DATA_DIR	= 1
HCI_FILTER	= 2
HCI_TIME_STAMP	= 3
HCI_CMSG_DIR	= 0x0001
HCI_CMSG_TSTAMP	= 0x0002
HCI_DEV_NONE	= 0xffff
HCI_CHANNEL_RAW	= 	0
HCI_CHANNEL_MONITOR	= 2
HCI_CHANNEL_CONTROL	= 3
HCI_FLT_TYPE_BITS	= 31
HCI_FLT_EVENT_BITS	= 63
HCI_FLT_OGF_BITS	= 63
HCI_FLT_OCF_BITS	= 127
IREQ_CACHE_FLUSH = 0x0001

# Constants from src/sco.h
SCO_DEFAULT_MTU =   500
SCO_DEFAULT_FLUSH_TO    = 0xFFFF
SCO_OPTIONS = 0x01
SCO_CONNINFO    = 0x02
