/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.BadPaddingException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import sun.security.ssl.Alerts;
import sun.security.ssl.AppInputStream;
import sun.security.ssl.AppOutputStream;
import sun.security.ssl.BaseSSLSocketImpl;
import sun.security.ssl.CipherBox;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.ClientHandshaker;
import sun.security.ssl.Debug;
import sun.security.ssl.Handshaker;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.ServerHandshaker;

public final class SSLSocketImpl
extends BaseSSLSocketImpl {
    private static final int cs_START = 0;
    private static final int cs_HANDSHAKE = 1;
    private static final int cs_DATA = 2;
    private static final int cs_RENEGOTIATE = 3;
    private static final int cs_ERROR = 4;
    private static final int cs_SENT_CLOSE = 5;
    private static final int cs_CLOSED = 6;
    private static final int cs_APP_CLOSED = 7;
    private int connectionState;
    private boolean expectingFinished;
    private SSLException closeReason;
    private byte doClientAuth;
    private boolean roleIsServer;
    private CipherSuiteList enabledCipherSuites;
    private boolean enableSessionCreation = true;
    private String host;
    private boolean autoClose = true;
    private AccessControlContext acc;
    private String identificationAlg = null;
    private Object handshakeLock;
    ReentrantLock writeLock;
    private Object readLock;
    private InputRecord inrec;
    private MAC readMAC;
    private MAC writeMAC;
    private CipherBox readCipher;
    private CipherBox writeCipher;
    private SSLContextImpl sslContext;
    private SSLSessionImpl sess;
    private Handshaker handshaker;
    private HashMap<HandshakeCompletedListener, AccessControlContext> handshakeListeners;
    private InputStream sockInput;
    private OutputStream sockOutput;
    private AppInputStream input;
    private AppOutputStream output;
    private ProtocolList enabledProtocols;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLSocketImpl(SSLContextImpl context, String host, int port) throws IOException, UnknownHostException {
        this.host = host;
        this.init(context, false);
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connect(socketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl context, InetAddress host, int port) throws IOException {
        this.init(context, false);
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connect(socketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl context, String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException {
        this.host = host;
        this.init(context, false);
        this.bind(new InetSocketAddress(localAddr, localPort));
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connect(socketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl context, InetAddress host, int port, InetAddress localAddr, int localPort) throws IOException {
        this.init(context, false);
        this.bind(new InetSocketAddress(localAddr, localPort));
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connect(socketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl context, boolean serverMode, CipherSuiteList suites, byte clientAuth, boolean sessionCreation, ProtocolList protocols) throws IOException {
        this.doClientAuth = clientAuth;
        this.enableSessionCreation = sessionCreation;
        this.init(context, serverMode);
        this.enabledCipherSuites = suites;
        this.enabledProtocols = protocols;
    }

    SSLSocketImpl(SSLContextImpl context) {
        this.init(context, false);
    }

    SSLSocketImpl(SSLContextImpl context, Socket sock, String host, int port, boolean autoClose) throws IOException {
        super(sock);
        if (!sock.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.host = host;
        this.init(context, false);
        this.autoClose = autoClose;
        this.doneConnect();
    }

    private void init(SSLContextImpl context, boolean isServer) {
        this.sslContext = context;
        this.sess = SSLSessionImpl.nullSession;
        this.roleIsServer = isServer;
        this.connectionState = 0;
        this.readCipher = CipherBox.NULL;
        this.readMAC = MAC.NULL;
        this.writeCipher = CipherBox.NULL;
        this.writeMAC = MAC.NULL;
        this.enabledCipherSuites = CipherSuiteList.getDefault();
        this.enabledProtocols = ProtocolList.getDefault();
        this.handshakeLock = new Object();
        this.writeLock = new ReentrantLock();
        this.readLock = new Object();
        this.inrec = null;
        this.acc = AccessController.getContext();
        this.input = new AppInputStream(this);
        this.output = new AppOutputStream(this);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.self != this) {
            throw new SocketException("Already connected");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new SocketException("Cannot handle non-Inet socket addresses.");
        }
        super.connect(endpoint, timeout);
        this.doneConnect();
    }

    void doneConnect() throws IOException {
        if (this.self == this) {
            this.sockInput = super.getInputStream();
            this.sockOutput = super.getOutputStream();
        } else {
            this.sockInput = this.self.getInputStream();
            this.sockOutput = this.self.getOutputStream();
        }
        this.initHandshaker();
    }

    private synchronized int getConnectionState() {
        return this.connectionState;
    }

    private synchronized void setConnectionState(int state) {
        this.connectionState = state;
    }

    AccessControlContext getAcc() {
        return this.acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRecord(OutputRecord r) throws IOException {
        block14: while (r.contentType() == 23) {
            switch (this.getConnectionState()) {
                case 1: {
                    this.performInitialHandshake();
                    continue block14;
                }
                case 2: 
                case 3: {
                    break block14;
                }
                case 4: {
                    this.fatal((byte)0, "error while writing to socket");
                    continue block14;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (this.closeReason != null) {
                        throw this.closeReason;
                    }
                    throw new SocketException("Socket closed");
                }
                default: {
                    throw new SSLProtocolException("State error, send app data");
                }
            }
        }
        if (!r.isEmpty()) {
            if (r.isAlert((byte)0) && this.getSoLinger() >= 0) {
                boolean interrupted;
                block24: {
                    interrupted = Thread.interrupted();
                    try {
                        if (this.writeLock.tryLock(this.getSoLinger(), TimeUnit.SECONDS)) {
                            try {
                                this.writeRecordInternal(r);
                                break block24;
                            }
                            finally {
                                this.writeLock.unlock();
                            }
                        }
                        SSLException ssle = new SSLException("SO_LINGER timeout, close_notify message cannot be sent.");
                        if (this.self != this && !this.autoClose) {
                            this.fatal((byte)-1, ssle);
                        } else if (debug != null && Debug.isOn("ssl")) {
                            System.out.println(SSLSocketImpl.threadName() + ", received Exception: " + ssle);
                        }
                        this.sess.invalidate();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.writeLock.lock();
                try {
                    this.writeRecordInternal(r);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    private void writeRecordInternal(OutputRecord r) throws IOException {
        r.addMAC(this.writeMAC);
        r.encrypt(this.writeCipher);
        r.write(this.sockOutput);
    }

    void readDataRecord(InputRecord r) throws IOException {
        if (this.getConnectionState() == 1) {
            this.performInitialHandshake();
        }
        this.readRecord(r, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecord(InputRecord r, boolean needAppData) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            int state;
            block19: while ((state = this.getConnectionState()) != 6 && state != 4 && state != 7) {
                try {
                    r.setAppDataValid(false);
                    r.read(this.sockInput, this.sockOutput);
                }
                catch (SSLProtocolException e) {
                    try {
                        this.fatal((byte)10, e);
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (EOFException eof) {
                    boolean rethrow;
                    boolean handshaking = this.getConnectionState() <= 1;
                    boolean bl = rethrow = requireCloseNotify || handshaking;
                    if (debug != null && Debug.isOn("ssl")) {
                        System.out.println(SSLSocketImpl.threadName() + ", received EOFException: " + (rethrow ? "error" : "ignored"));
                    }
                    if (rethrow) {
                        SSLException e = handshaking ? new SSLHandshakeException("Remote host closed connection during handshake") : new SSLProtocolException("Remote host closed connection incorrectly");
                        e.initCause(eof);
                        throw e;
                    }
                    this.closeInternal(false);
                    continue;
                }
                try {
                    r.decrypt(this.readCipher);
                }
                catch (BadPaddingException e) {
                    r.checkMAC(this.readMAC);
                    byte alertType = r.contentType() == 22 ? (byte)40 : 20;
                    this.fatal(alertType, "Invalid padding", e);
                }
                if (!r.checkMAC(this.readMAC)) {
                    if (r.contentType() == 22) {
                        this.fatal((byte)40, "bad handshake record MAC");
                    } else {
                        this.fatal((byte)20, "bad record MAC");
                    }
                }
                SSLSocketImpl sSLSocketImpl = this;
                synchronized (sSLSocketImpl) {
                    switch (r.contentType()) {
                        case 22: {
                            this.initHandshaker();
                            this.handshaker.process_record(r, this.expectingFinished);
                            this.expectingFinished = false;
                            if (this.handshaker.isDone()) {
                                this.sess = this.handshaker.getSession();
                                this.handshaker = null;
                                this.connectionState = 2;
                                if (this.handshakeListeners != null) {
                                    HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.sess);
                                    NotifyHandshakeThread t = new NotifyHandshakeThread(this.handshakeListeners.entrySet(), event);
                                    t.start();
                                }
                            }
                            if (needAppData || this.connectionState != 2) {
                                continue block19;
                            }
                            return;
                        }
                        case 23: {
                            if (this.connectionState != 2 && this.connectionState != 3 && this.connectionState != 5) {
                                throw new SSLProtocolException("Data received in non-data state: " + this.connectionState);
                            }
                            if (this.expectingFinished) {
                                throw new SSLProtocolException("Expecting finished message, received data");
                            }
                            if (!needAppData) {
                                throw new SSLException("Discarding app data");
                            }
                            r.setAppDataValid(true);
                            return;
                        }
                        case 21: {
                            this.recvAlert(r);
                            continue block19;
                        }
                        case 20: {
                            if (this.connectionState != 1 && this.connectionState != 3 || r.available() != 1 || r.read() != 1) {
                                this.fatal((byte)10, "illegal change cipher spec msg, state = " + this.connectionState);
                            }
                            this.changeReadCiphers();
                            this.expectingFinished = true;
                            continue block19;
                        }
                    }
                    if (debug != null && Debug.isOn("ssl")) {
                        System.out.println(SSLSocketImpl.threadName() + ", Received record type: " + r.contentType());
                    }
                }
            }
            r.close();
            return;
        }
    }

    AppInputStream getAppInputStream() {
        return this.input;
    }

    ServerHandshaker getServerHandshaker() throws SSLException {
        this.initHandshaker();
        if (!this.isConnected()) {
            this.connectionState = 0;
        }
        if (!(this.handshaker instanceof ServerHandshaker)) {
            throw new SSLProtocolException("unexpected handshaker instance");
        }
        return (ServerHandshaker)this.handshaker;
    }

    private void initHandshaker() {
        switch (this.connectionState) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        this.connectionState = this.connectionState == 0 ? 1 : 3;
        this.handshaker = this.roleIsServer ? new ServerHandshaker(this, this.sslContext, this.enabledProtocols, this.doClientAuth) : new ClientHandshaker(this, this.sslContext, this.enabledProtocols);
        this.handshaker.enabledCipherSuites = this.enabledCipherSuites;
        this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        if (this.connectionState == 3) {
            this.handshaker.output.r.setHelloVersion(this.protocolVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInitialHandshake() throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.getConnectionState() == 1) {
                if (this.inrec == null) {
                    this.inrec = new InputRecord();
                    this.inrec.setHandshakeHash(this.input.r.getHandshakeHash());
                    this.inrec.setHelloVersion(this.input.r.getHelloVersion());
                    this.inrec.enableFormatChecks();
                }
                this.kickstartHandshake();
                this.readRecord(this.inrec, false);
                this.inrec = null;
            }
        }
    }

    public void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    private void startHandshake(boolean resumable) throws IOException {
        this.checkWrite();
        try {
            if (this.getConnectionState() == 1) {
                this.performInitialHandshake();
            } else {
                this.kickstartHandshake();
            }
        }
        catch (Exception e) {
            this.handleException(e, resumable);
        }
    }

    private synchronized void kickstartHandshake() throws IOException {
        switch (this.connectionState) {
            case 1: {
                break;
            }
            case 2: {
                this.initHandshaker();
                break;
            }
            case 3: {
                return;
            }
            case 0: {
                throw new SocketException("handshaking attempted on unconnected socket");
            }
            default: {
                throw new SocketException("connection is closed");
            }
        }
        if (!this.handshaker.started()) {
            if (this.handshaker instanceof ClientHandshaker) {
                this.handshaker.kickstart();
            } else if (this.connectionState != 1) {
                this.handshaker.kickstart();
                this.handshaker.handshakeHash.reset();
            }
        }
    }

    public boolean isClosed() {
        return this.getConnectionState() == 7;
    }

    boolean checkEOF() throws IOException {
        switch (this.getConnectionState()) {
            case 0: {
                throw new SocketException("Socket is not connected");
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 7: {
                throw new SocketException("Socket is closed");
            }
        }
        if (this.closeReason == null) {
            return true;
        }
        SSLException e = new SSLException("Connection has been shutdown: " + this.closeReason);
        e.initCause(this.closeReason);
        throw e;
    }

    void checkWrite() throws IOException {
        if (this.checkEOF() || this.getConnectionState() == 5) {
            throw new SocketException("Connection closed by remote host");
        }
    }

    protected void closeSocket() throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.threadName() + ", called closeSocket()");
        }
        if (this.self == this) {
            super.close();
        } else {
            this.self.close();
        }
    }

    public void close() throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.threadName() + ", called close()");
        }
        this.closeInternal(true);
        this.setConnectionState(7);
    }

    /*
     * Exception decompiling
     */
    private void closeInternal(boolean selfInitiated) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void waitForClose(boolean rethrow) throws IOException {
        block8: {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(SSLSocketImpl.threadName() + ", waiting for close_notify or alert: state " + this.getConnectionState());
            }
            try {
                int state;
                while ((state = this.getConnectionState()) != 6 && state != 4 && state != 7) {
                    if (this.inrec == null) {
                        this.inrec = new InputRecord();
                    }
                    try {
                        this.readRecord(this.inrec, true);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                this.inrec = null;
            }
            catch (IOException e) {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(SSLSocketImpl.threadName() + ", Exception while waiting for close " + e);
                }
                if (!rethrow) break block8;
                throw e;
            }
        }
    }

    void handleException(Exception e) throws IOException {
        this.handleException(e, true);
    }

    private synchronized void handleException(Exception e, boolean resumable) throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.threadName() + ", handling exception: " + e.toString());
        }
        if (e instanceof InterruptedIOException && resumable) {
            throw (IOException)e;
        }
        if (this.closeReason != null) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw Alerts.getSSLException((byte)80, e, "Unexpected exception");
        }
        boolean isSSLException = e instanceof SSLException;
        if (!isSSLException && e instanceof IOException) {
            try {
                this.fatal((byte)10, e);
            }
            catch (IOException ee) {
                // empty catch block
            }
            throw (IOException)e;
        }
        byte alertType = isSSLException ? (e instanceof SSLHandshakeException ? (byte)40 : 10) : (byte)80;
        this.fatal(alertType, e);
    }

    void warning(byte description) {
        this.sendAlert((byte)1, description);
    }

    synchronized void fatal(byte description, String diagnostic) throws IOException {
        this.fatal(description, diagnostic, null);
    }

    synchronized void fatal(byte description, Throwable cause) throws IOException {
        this.fatal(description, null, cause);
    }

    synchronized void fatal(byte description, String diagnostic, Throwable cause) throws IOException {
        if (this.input != null && this.input.r != null) {
            this.input.r.close();
        }
        this.sess.invalidate();
        int oldState = this.connectionState;
        this.connectionState = 4;
        if (this.closeReason == null) {
            if (oldState == 1) {
                this.sockInput.skip(this.sockInput.available());
            }
            if (description != -1) {
                this.sendAlert((byte)2, description);
            }
            this.closeReason = cause instanceof SSLException ? (SSLException)cause : Alerts.getSSLException(description, cause, diagnostic);
        }
        this.closeSocket();
        this.connectionState = oldState == 7 ? 7 : 6;
        throw this.closeReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recvAlert(InputRecord r) throws IOException {
        byte level = (byte)r.read();
        byte description = (byte)r.read();
        if (description == -1) {
            this.fatal((byte)47, "Short alert message");
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.print(SSLSocketImpl.threadName());
                System.out.print(", RECV " + this.protocolVersion + " ALERT:  ");
                if (level == 2) {
                    System.out.print("fatal, ");
                } else if (level == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level " + (0xFF & level) + ">, ");
                }
                System.out.println(Alerts.alertDescription(description));
            }
        }
        if (level == 1) {
            if (description == 0) {
                if (this.connectionState == 1) {
                    this.fatal((byte)10, "Received close_notify during handshake");
                } else {
                    this.closeInternal(false);
                }
            } else if (this.handshaker != null) {
                this.handshaker.handshakeAlert(description);
            }
        } else {
            String reason = "Received fatal alert: " + Alerts.alertDescription(description);
            if (this.closeReason == null) {
                this.closeReason = Alerts.getSSLException(description, reason);
            }
            this.fatal((byte)10, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlert(byte level, byte description) {
        block11: {
            boolean useDebug;
            if (this.connectionState >= 5) {
                return;
            }
            OutputRecord r = new OutputRecord(21);
            r.setVersion(this.protocolVersion);
            boolean bl = useDebug = debug != null && Debug.isOn("ssl");
            if (useDebug) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.print(SSLSocketImpl.threadName());
                    System.out.print(", SEND " + this.protocolVersion + " ALERT:  ");
                    if (level == 2) {
                        System.out.print("fatal, ");
                    } else if (level == 1) {
                        System.out.print("warning, ");
                    } else {
                        System.out.print("<level = " + (0xFF & level) + ">, ");
                    }
                    System.out.println("description = " + Alerts.alertDescription(description));
                }
            }
            r.write(level);
            r.write(description);
            try {
                this.writeRecord(r);
            }
            catch (IOException e) {
                if (!useDebug) break block11;
                System.out.println(SSLSocketImpl.threadName() + ", Exception sending alert: " + e);
            }
        }
    }

    private void changeReadCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        try {
            this.readCipher = this.handshaker.newReadCipher();
            this.readMAC = this.handshaker.newReadMAC();
        }
        catch (GeneralSecurityException e) {
            throw (SSLException)new SSLException("Algorithm missing:  ").initCause(e);
        }
    }

    void changeWriteCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        try {
            this.writeCipher = this.handshaker.newWriteCipher();
            this.writeMAC = this.handshaker.newWriteMAC();
        }
        catch (GeneralSecurityException e) {
            throw (SSLException)new SSLException("Algorithm missing:  ").initCause(e);
        }
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.output.r.setVersion(protocolVersion);
    }

    synchronized String getHost() {
        if (this.host == null) {
            this.host = this.getInetAddress().getHostName();
        }
        return this.host;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.input;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSession getSession() {
        block6: {
            if (this.getConnectionState() == 1) {
                try {
                    this.startHandshake(false);
                }
                catch (IOException e) {
                    if (debug == null || !Debug.isOn("handshake")) break block6;
                    System.out.println(SSLSocketImpl.threadName() + ", IOException in getSession():  " + e);
                }
            }
        }
        SSLSocketImpl sSLSocketImpl = this;
        synchronized (sSLSocketImpl) {
            return this.sess;
        }
    }

    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        }
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized void setNeedClientAuth(boolean flag) {
        this.doClientAuth = (byte)(flag ? 2 : 0);
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.started()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    public synchronized boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    public synchronized void setWantClientAuth(boolean flag) {
        byte by = this.doClientAuth = flag ? (byte)1 : 0;
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.started()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    public synchronized boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    public synchronized void setUseClientMode(boolean flag) {
        switch (this.connectionState) {
            case 0: {
                this.roleIsServer = !flag;
                break;
            }
            case 1: {
                assert (this.handshaker != null);
                if (!this.handshaker.started()) {
                    this.roleIsServer = !flag;
                    this.connectionState = 0;
                    this.initHandshaker();
                    break;
                }
            }
            default: {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(SSLSocketImpl.threadName() + ", setUseClientMode() invoked in state = " + this.connectionState);
                }
                throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
            }
        }
    }

    public synchronized boolean getUseClientMode() {
        return !this.roleIsServer;
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getSupported().toStringArray();
    }

    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = new CipherSuiteList(suites);
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.enabledCipherSuites = this.enabledCipherSuites;
        }
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    public String[] getSupportedProtocols() {
        return ProtocolList.getSupported().toStringArray();
    }

    public synchronized void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = new ProtocolList(protocols);
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setEnabledProtocols(this.enabledProtocols);
        }
    }

    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.threadName() + ", setSoTimeout(" + timeout + ") called");
        }
        if (this.self == this) {
            super.setSoTimeout(timeout);
        } else {
            this.self.setSoTimeout(timeout);
        }
    }

    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.handshakeListeners == null) {
            this.handshakeListeners = new HashMap(4);
        }
        this.handshakeListeners.put(listener, AccessController.getContext());
    }

    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (this.handshakeListeners == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (this.handshakeListeners.remove(listener) == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.handshakeListeners.isEmpty()) {
            this.handshakeListeners = null;
        }
    }

    public synchronized boolean trySetHostnameVerification(String identificationAlgorithm) {
        if (this.sslContext.getX509TrustManager() instanceof X509ExtendedTrustManager) {
            this.identificationAlg = identificationAlgorithm;
            return true;
        }
        return false;
    }

    public synchronized String getHostnameVerification() {
        return this.identificationAlg;
    }

    private static String threadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        StringBuffer retval = new StringBuffer(80);
        retval.append(Integer.toHexString(this.hashCode()));
        retval.append("[");
        retval.append(this.sess.getCipherSuite());
        retval.append(": ");
        if (this.self == this) {
            retval.append(super.toString());
        } else {
            retval.append(this.self.toString());
        }
        retval.append("]");
        return retval.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotifyHandshakeThread
    extends Thread {
        private Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> targets;
        private HandshakeCompletedEvent event;

        NotifyHandshakeThread(Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> entrySet, HandshakeCompletedEvent e) {
            super("HandshakeCompletedNotify-Thread");
            this.targets = entrySet;
            this.event = e;
        }

        @Override
        public void run() {
            for (Map.Entry<HandshakeCompletedListener, AccessControlContext> entry : this.targets) {
                final HandshakeCompletedListener l = entry.getKey();
                AccessControlContext acc = entry.getValue();
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        l.handshakeCompleted(NotifyHandshakeThread.this.event);
                        return null;
                    }
                }, acc);
            }
        }
    }
}

