/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.ServerHandshaker;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private SSLContextImpl sslContext;
    private byte doClientAuth = 0;
    private boolean useServerMode = true;
    private boolean enableSessionCreation = true;
    private CipherSuiteList enabledCipherSuites = null;
    private ProtocolList enabledProtocols = null;
    private boolean checkedEnabled = false;

    SSLServerSocketImpl(int port, int backlog, SSLContextImpl context) throws IOException, SSLException {
        super(port, backlog);
        this.initServer(context);
    }

    SSLServerSocketImpl(int port, int backlog, InetAddress address, SSLContextImpl context) throws IOException {
        super(port, backlog, address);
        this.initServer(context);
    }

    SSLServerSocketImpl(SSLContextImpl context) throws IOException {
        this.initServer(context);
    }

    private void initServer(SSLContextImpl context) throws SSLException {
        if (context == null) {
            throw new SSLException("No Authentication context given");
        }
        this.sslContext = context;
        this.enabledCipherSuites = CipherSuiteList.getDefault();
        this.enabledProtocols = ProtocolList.getDefault();
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getSupported().toStringArray();
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = new CipherSuiteList(suites);
        this.checkedEnabled = false;
    }

    public String[] getSupportedProtocols() {
        return ProtocolList.getSupported().toStringArray();
    }

    public synchronized void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = new ProtocolList(protocols);
    }

    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    public void setNeedClientAuth(boolean flag) {
        this.doClientAuth = (byte)(flag ? 2 : 0);
    }

    public boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    public void setWantClientAuth(boolean flag) {
        this.doClientAuth = flag ? (byte)1 : 0;
    }

    public boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    public void setUseClientMode(boolean flag) {
        this.useServerMode = !flag;
    }

    public boolean getUseClientMode() {
        return !this.useServerMode;
    }

    public void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public Socket accept() throws IOException {
        this.checkEnabledSuites();
        SSLSocketImpl s = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols);
        this.implAccept(s);
        s.doneConnect();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnabledSuites() throws IOException {
        SSLServerSocketImpl sSLServerSocketImpl = this;
        synchronized (sSLServerSocketImpl) {
            if (this.checkedEnabled) {
                return;
            }
            if (!this.useServerMode) {
                return;
            }
            SSLSocketImpl tmp = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols);
            try {
                ServerHandshaker handshaker = tmp.getServerHandshaker();
                Iterator<CipherSuite> t = this.enabledCipherSuites.iterator();
                while (true) {
                    if (t.hasNext()) {
                        CipherSuite suite = t.next();
                        if (!handshaker.trySetCipherSuite(suite)) continue;
                        this.checkedEnabled = true;
                        return;
                        continue;
                    }
                    break;
                }
            }
            finally {
                tmp.closeSocket();
            }
            throw new SSLException("No available certificate or key corresponds to the SSL cipher suites which are enabled.");
        }
    }

    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

