/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

final class CipherBox {
    static final CipherBox NULL = new CipherBox();
    private static final Debug debug = Debug.getInstance("ssl");
    private final ProtocolVersion protocolVersion;
    private final Cipher cipher;
    private int blockSize;

    private CipherBox() {
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.cipher = null;
    }

    private CipherBox(ProtocolVersion protocolVersion, CipherSuite.BulkCipher bulkCipher, SecretKey key, IvParameterSpec iv, boolean encrypt) throws NoSuchAlgorithmException {
        try {
            this.protocolVersion = protocolVersion;
            this.cipher = JsseJce.getCipher(bulkCipher.transformation);
            int mode = encrypt ? 1 : 2;
            this.cipher.init(mode, (Key)key, iv);
            this.blockSize = this.cipher.getBlockSize();
            if (this.blockSize == 1) {
                this.blockSize = 0;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, e);
        }
        catch (ExceptionInInitializerError e) {
            throw new NoSuchAlgorithmException("Could not create cipher " + bulkCipher, e);
        }
    }

    static CipherBox newCipherBox(ProtocolVersion version, CipherSuite.BulkCipher cipher, SecretKey key, IvParameterSpec iv, boolean encrypt) throws NoSuchAlgorithmException {
        if (!cipher.allowed) {
            throw new NoSuchAlgorithmException("Unsupported cipher " + cipher);
        }
        if (cipher == CipherSuite.B_NULL) {
            return NULL;
        }
        return new CipherBox(version, cipher, key, iv, encrypt);
    }

    int encrypt(byte[] buf, int offset, int len) {
        if (this.cipher == null) {
            return len;
        }
        try {
            int newLen;
            if (this.blockSize != 0) {
                len = CipherBox.addPadding(buf, offset, len, this.blockSize);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + len);
                    hd.encodeBuffer((InputStream)new ByteArrayInputStream(buf, offset, len), (OutputStream)System.out);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if ((newLen = this.cipher.update(buf, offset, len, buf, offset)) != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return newLen;
        }
        catch (ShortBufferException e) {
            throw new ArrayIndexOutOfBoundsException(e.toString());
        }
    }

    int encrypt(ByteBuffer bb) {
        int len = bb.remaining();
        if (this.cipher == null) {
            bb.position(bb.limit());
            return len;
        }
        try {
            int pos = bb.position();
            if (this.blockSize != 0) {
                len = CipherBox.addPadding(bb, this.blockSize);
                bb.position(pos);
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    System.out.println("Padded plaintext before ENCRYPTION:  len = " + len);
                    hd.encodeBuffer(bb, (OutputStream)System.out);
                }
                catch (IOException e) {
                    // empty catch block
                }
                bb.position(pos);
            }
            ByteBuffer dup = bb.duplicate();
            int newLen = this.cipher.update(dup, bb);
            if (bb.position() != dup.position()) {
                throw new RuntimeException("bytebuffer padding error");
            }
            if (newLen != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            return newLen;
        }
        catch (ShortBufferException e) {
            RuntimeException exc = new RuntimeException(e.toString());
            exc.initCause(e);
            throw exc;
        }
    }

    int decrypt(byte[] buf, int offset, int len) throws BadPaddingException {
        if (this.cipher == null) {
            return len;
        }
        try {
            int newLen = this.cipher.update(buf, offset, len, buf, offset);
            if (newLen != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + newLen);
                    hd.encodeBuffer((InputStream)new ByteArrayInputStream(buf, offset, newLen), (OutputStream)System.out);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                newLen = CipherBox.removePadding(buf, offset, newLen, this.blockSize, this.protocolVersion);
            }
            return newLen;
        }
        catch (ShortBufferException e) {
            throw new ArrayIndexOutOfBoundsException(e.toString());
        }
    }

    int decrypt(ByteBuffer bb) throws BadPaddingException {
        int len = bb.remaining();
        if (this.cipher == null) {
            bb.position(bb.limit());
            return len;
        }
        try {
            int pos = bb.position();
            ByteBuffer dup = bb.duplicate();
            int newLen = this.cipher.update(dup, bb);
            if (newLen != len) {
                throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
            }
            if (debug != null && Debug.isOn("plaintext")) {
                bb.position(pos);
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    System.out.println("Padded plaintext after DECRYPTION:  len = " + newLen);
                    hd.encodeBuffer(bb, (OutputStream)System.out);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.blockSize != 0) {
                bb.position(pos);
                newLen = CipherBox.removePadding(bb, this.blockSize, this.protocolVersion);
            }
            return newLen;
        }
        catch (ShortBufferException e) {
            RuntimeException exc = new RuntimeException(e.toString());
            exc.initCause(e);
            throw exc;
        }
    }

    private static int addPadding(byte[] buf, int offset, int len, int blockSize) {
        int newlen = len + 1;
        if (newlen % blockSize != 0) {
            newlen += blockSize - 1;
            newlen -= newlen % blockSize;
        }
        int pad = newlen - len;
        if (buf.length < newlen + offset) {
            throw new IllegalArgumentException("no space to pad buffer");
        }
        offset += len;
        for (int i = 0; i < pad; ++i) {
            buf[offset++] = (byte)(pad - 1);
        }
        return newlen;
    }

    private static int addPadding(ByteBuffer bb, int blockSize) {
        int len = bb.remaining();
        int offset = bb.position();
        int newlen = len + 1;
        if (newlen % blockSize != 0) {
            newlen += blockSize - 1;
            newlen -= newlen % blockSize;
        }
        int pad = newlen - len;
        bb.limit(newlen + offset);
        offset += len;
        for (int i = 0; i < pad; ++i) {
            bb.put(offset++, (byte)(pad - 1));
        }
        bb.position(offset);
        bb.limit(offset);
        return newlen;
    }

    private static int removePadding(byte[] buf, int offset, int len, int blockSize, ProtocolVersion protocolVersion) throws BadPaddingException {
        int padOffset = offset + len - 1;
        int pad = buf[padOffset] & 0xFF;
        int newlen = len - (pad + 1);
        if (newlen < 0) {
            throw new BadPaddingException("Padding length invalid: " + pad);
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            for (int i = 1; i <= pad; ++i) {
                int val = buf[padOffset - i] & 0xFF;
                if (val == pad) continue;
                throw new BadPaddingException("Invalid TLS padding: " + val);
            }
        } else if (pad > blockSize) {
            throw new BadPaddingException("Invalid SSLv3 padding: " + pad);
        }
        return newlen;
    }

    private static int removePadding(ByteBuffer bb, int blockSize, ProtocolVersion protocolVersion) throws BadPaddingException {
        int offset;
        int padOffset;
        int pad;
        int len = bb.remaining();
        int newlen = len - ((pad = bb.get(padOffset = (offset = bb.position()) + len - 1) & 0xFF) + 1);
        if (newlen < 0) {
            throw new BadPaddingException("Padding length invalid: " + pad);
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            bb.put(padOffset, (byte)0);
            for (int i = 1; i <= pad; ++i) {
                int val = bb.get(padOffset - i) & 0xFF;
                if (val == pad) continue;
                throw new BadPaddingException("Invalid TLS padding: " + val);
            }
        } else if (pad > blockSize) {
            throw new BadPaddingException("Invalid SSLv3 padding: " + pad);
        }
        bb.position(offset + newlen);
        bb.limit(offset + newlen);
        return newlen;
    }
}

