/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class PCBC
extends FeedbackCipher {
    private final byte[] k = new byte[this.blockSize];
    private byte[] kSave = null;

    PCBC(SymmetricCipher embeddedCipher) {
        super(embeddedCipher);
    }

    String getFeedback() {
        return "PCBC";
    }

    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException {
        if (key == null || iv == null || iv.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = iv;
        this.reset();
        this.embeddedCipher.init(decrypting, algorithm, key);
    }

    void reset() {
        System.arraycopy(this.iv, 0, this.k, 0, this.blockSize);
    }

    void save() {
        if (this.kSave == null) {
            this.kSave = new byte[this.blockSize];
        }
        System.arraycopy(this.k, 0, this.kSave, 0, this.blockSize);
    }

    void restore() {
        System.arraycopy(this.kSave, 0, this.k, 0, this.blockSize);
    }

    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        int endIndex = plainOffset + plainLen;
        while (plainOffset < endIndex) {
            int i;
            for (i = 0; i < this.blockSize; ++i) {
                int n = i;
                this.k[n] = (byte)(this.k[n] ^ plain[i + plainOffset]);
            }
            this.embeddedCipher.encryptBlock(this.k, 0, cipher, cipherOffset);
            for (i = 0; i < this.blockSize; ++i) {
                this.k[i] = (byte)(plain[i + plainOffset] ^ cipher[i + cipherOffset]);
            }
            plainOffset += this.blockSize;
            cipherOffset += this.blockSize;
        }
    }

    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) {
        int endIndex = cipherOffset + cipherLen;
        while (cipherOffset < endIndex) {
            int i;
            this.embeddedCipher.decryptBlock(cipher, cipherOffset, plain, plainOffset);
            for (i = 0; i < this.blockSize; ++i) {
                int n = i + plainOffset;
                plain[n] = (byte)(plain[n] ^ this.k[i]);
            }
            for (i = 0; i < this.blockSize; ++i) {
                this.k[i] = (byte)(plain[i + plainOffset] ^ cipher[i + cipherOffset]);
            }
            plainOffset += this.blockSize;
            cipherOffset += this.blockSize;
        }
    }
}

