/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XPlotter;

public class XPlottingViewer
extends PlotterPanel
implements ActionListener {
    private static final int PLOTTER_DECIMALS = 4;
    private JButton plotButton;
    private static HashMap<String, XPlottingViewer> plotterCache = new HashMap();
    private static HashMap<String, Timer> timerCache = new HashMap();
    private JPanel bordered;
    private Number value;
    private MBeansTab tab;
    private XMBean mbean;
    private String attributeName;
    private String key;
    private JTable table;

    private XPlottingViewer(String key, XMBean mbean, String attributeName, Object value, JTable table, MBeansTab tab) {
        super((String)null);
        this.tab = tab;
        this.key = key;
        this.mbean = mbean;
        this.table = table;
        this.attributeName = attributeName;
        Plotter plotter = this.createPlotter(mbean, attributeName, key, table);
        this.setupDisplay(plotter);
    }

    static void dispose(MBeansTab tab) {
        String key;
        Iterator<String> it = plotterCache.keySet().iterator();
        while (it.hasNext()) {
            key = it.next();
            if (!key.startsWith(String.valueOf(tab.hashCode()))) continue;
            it.remove();
        }
        it = timerCache.keySet().iterator();
        while (it.hasNext()) {
            key = it.next();
            if (!key.startsWith(String.valueOf(tab.hashCode()))) continue;
            Timer t = timerCache.get(key);
            t.cancel();
            it.remove();
        }
    }

    public static boolean isViewableValue(Object value) {
        return value instanceof Number;
    }

    public static Component loadPlotting(XMBean mbean, String attributeName, Object value, JTable table, MBeansTab tab) {
        XPlottingViewer comp = null;
        if (XPlottingViewer.isViewableValue(value)) {
            String key = String.valueOf(tab.hashCode()) + " " + String.valueOf(mbean.hashCode()) + " " + mbean.getObjectName().getCanonicalName() + attributeName;
            XPlottingViewer plotter = plotterCache.get(key);
            if (plotter == null) {
                plotter = new XPlottingViewer(key, mbean, attributeName, value, table, tab);
                plotterCache.put(key, plotter);
            }
            comp = plotter;
        }
        return comp;
    }

    public void actionPerformed(ActionEvent evt) {
        plotterCache.remove(this.key);
        Timer t = timerCache.remove(this.key);
        t.cancel();
        ((XMBeanAttributes)this.table).collapse(this.attributeName, this);
    }

    public Plotter createPlotter(final XMBean xmbean, final String attributeName, String key, JTable table) {
        final XPlotter plotter = new XPlotter(table, Plotter.Unit.NONE){
            Dimension prefSize;
            {
                this.prefSize = new Dimension(400, 170);
            }

            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            public Dimension getMinimumSize() {
                return this.prefSize;
            }
        };
        plotter.createSequence(attributeName, attributeName, null, true);
        TimerTask timerTask = new TimerTask(){

            public void run() {
                XPlottingViewer.this.tab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            long v;
                            Number n = (Number)xmbean.getMBeanServerConnection().getAttribute(xmbean.getObjectName(), attributeName);
                            if (n instanceof Float || n instanceof Double) {
                                plotter.setDecimals(4);
                                double d = n instanceof Float ? (double)((Float)n).floatValue() : (Double)n;
                                v = Math.round(d * Math.pow(10.0, 4.0));
                            } else {
                                v = n.longValue();
                            }
                            plotter.addValues(System.currentTimeMillis(), v);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        String timerName = "Timer-" + key;
        Timer timer = new Timer(timerName, true);
        timer.schedule(timerTask, 0L, (long)this.tab.getUpdateInterval());
        timerCache.put(key, timer);
        return plotter;
    }

    private void setupDisplay(Plotter plotter) {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.plotButton = new JButton(Resources.getText("Discard chart", new Object[0]));
        this.plotButton.addActionListener(this);
        this.plotButton.setEnabled(true);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.gridx = 0;
        buttonConstraints.gridy = 0;
        buttonConstraints.fill = 3;
        buttonConstraints.anchor = 10;
        gbl.setConstraints(this.plotButton, buttonConstraints);
        this.add(this.plotButton);
        GridBagConstraints plotterConstraints = new GridBagConstraints();
        plotterConstraints.gridx = 0;
        plotterConstraints.gridy = 1;
        plotterConstraints.weightx = 1.0;
        plotterConstraints.fill = 3;
        gbl.setConstraints(plotter, plotterConstraints);
        this.setPlotter(plotter);
        this.repaint();
    }
}

