/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.EventObject;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XTable;
import sun.tools.jconsole.inspector.XTextFieldEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMBeanAttributes
extends XTable {
    private static final String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Value", new Object[0])};
    private boolean editable = true;
    private XMBean mbean;
    private MBeanInfo mbeanInfo;
    private MBeanAttributeInfo[] attributesInfo;
    private HashMap<String, Object> attributes;
    private HashMap<String, Object> unavailableAttributes;
    private HashMap<String, Object> viewableAttributes;
    private WeakHashMap<XMBean, HashMap<String, ZoomedCell>> viewersCache = new WeakHashMap();
    private TableModelListener attributesListener;
    private MBeansTab mbeansTab;
    private XTable table;
    private TableCellEditor valueCellEditor = new ValueCellEditor();
    private int rowMinHeight = -1;
    private AttributesMouseListener mouseListener = new AttributesMouseListener();
    private static TableCellEditor editor = new Utils.ReadOnlyTableCellEditor(new JTextField());

    public XMBeanAttributes(MBeansTab mbeansTab) {
        this.mbeansTab = mbeansTab;
        ((DefaultTableModel)this.getModel()).setColumnIdentifiers(columnNames);
        this.attributesListener = new AttributesListener(this);
        this.getModel().addTableModelListener(this.attributesListener);
        this.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.addMouseListener(this.mouseListener);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnEditors();
        this.addKeyListener(new Utils.CopyKeyAdapter());
    }

    @Override
    public synchronized Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (row >= this.getRowCount()) {
            return null;
        }
        return super.prepareRenderer(renderer, row, column);
    }

    void updateRowHeight(Object obj, int row) {
        ZoomedCell cell = null;
        if (obj instanceof ZoomedCell) {
            cell = (ZoomedCell)obj;
            if (cell.isInited()) {
                this.setRowHeight(row, cell.getHeight());
            } else if (this.rowMinHeight != -1) {
                this.setRowHeight(row, this.rowMinHeight);
            }
        } else if (this.rowMinHeight != -1) {
            this.setRowHeight(row, this.rowMinHeight);
        }
    }

    @Override
    public synchronized TableCellRenderer getCellRenderer(int row, int column) {
        ZoomedCell cell;
        Object obj;
        if (row >= this.getRowCount()) {
            return null;
        }
        if (column == 1 && (obj = this.getModel().getValueAt(row, column)) instanceof ZoomedCell && (cell = (ZoomedCell)obj).isInited()) {
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)cell.getRenderer();
            renderer.setToolTipText(this.getToolTip(row, column));
            return renderer;
        }
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)super.getCellRenderer(row, column);
        if (!(this.isCellError(row, column) || this.isColumnEditable(column) && this.isWritable(row) && Utils.isEditableType(this.getClassName(row)))) {
            renderer.setForeground(this.getDefaultColor());
        }
        return renderer;
    }

    private void setColumnEditors() {
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < columnNames.length; ++i) {
            TableColumn tc = tcm.getColumn(i);
            if (this.isColumnEditable(i)) {
                tc.setCellEditor(this.valueCellEditor);
                continue;
            }
            tc.setCellEditor(editor);
        }
    }

    public void cancelCellEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    public void stopCellEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    @Override
    public final boolean editCellAt(int row, int column, EventObject e) {
        TableCellEditor editor;
        boolean retVal = super.editCellAt(row, column, e);
        if (retVal && (editor = this.getColumnModel().getColumn(column).getCellEditor()) == this.valueCellEditor) {
            ((JComponent)((Object)editor)).requestFocus();
        }
        return retVal;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.isColumnEditable(col)) {
            return true;
        }
        Object obj = this.getModel().getValueAt(row, col);
        if (obj instanceof ZoomedCell) {
            ZoomedCell cell = (ZoomedCell)obj;
            return cell.isMaximized();
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (!this.isCellError(row, column) && this.isColumnEditable(column) && this.isWritable(row) && Utils.isEditableType(this.getClassName(row))) {
            super.setValueAt(value, row, column);
        }
    }

    @Override
    public boolean isTableEditable() {
        return true;
    }

    @Override
    public void setTableValue(Object value, int row) {
    }

    @Override
    public boolean isColumnEditable(int column) {
        if (column < this.getColumnCount()) {
            return this.getColumnName(column).equals(Resources.getText("Value", new Object[0]));
        }
        return false;
    }

    @Override
    public String getClassName(int row) {
        int index = this.convertRowToIndex(row);
        if (index != -1) {
            return this.attributesInfo[index].getType();
        }
        return null;
    }

    @Override
    public String getValueName(int row) {
        int index = this.convertRowToIndex(row);
        if (index != -1) {
            return this.attributesInfo[index].getName();
        }
        return null;
    }

    @Override
    public Object getValue(int row) {
        return ((DefaultTableModel)this.getModel()).getValueAt(row, 1);
    }

    @Override
    public String getToolTip(int row, int column) {
        int index;
        if (this.isCellError(row, column)) {
            return (String)this.unavailableAttributes.get(this.getValueName(row));
        }
        if (this.isColumnEditable(column)) {
            Object value = this.getValue(row);
            String tip = null;
            if (value != null) {
                tip = value.toString();
                if (this.isAttributeViewable(row, 1)) {
                    tip = Resources.getText("Double click to expand/collapse", new Object[0]) + ". " + tip;
                }
            }
            return tip;
        }
        if (column == 0 && (index = this.convertRowToIndex(row)) != -1) {
            return this.attributesInfo[index].getDescription();
        }
        return null;
    }

    @Override
    public synchronized boolean isWritable(int row) {
        int index = this.convertRowToIndex(row);
        if (index != -1) {
            return this.attributesInfo[index].isWritable();
        }
        return false;
    }

    @Override
    public synchronized int getRowCount() {
        return super.getRowCount();
    }

    @Override
    public synchronized boolean isReadable(int row) {
        int index = this.convertRowToIndex(row);
        if (index != -1) {
            return this.attributesInfo[index].isReadable();
        }
        return false;
    }

    @Override
    public synchronized boolean isCellError(int row, int col) {
        return this.isColumnEditable(col) && this.unavailableAttributes.containsKey(this.getValueName(row));
    }

    @Override
    public synchronized boolean isAttributeViewable(int row, int col) {
        Object obj;
        boolean isViewable = false;
        if (col == 1 && (obj = this.getModel().getValueAt(row, col)) instanceof ZoomedCell) {
            isViewable = true;
        }
        return isViewable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAttributes(final XMBean mbean, MBeanInfo mbeanInfo) {
        HashMap<String, Object> viewableAttributes;
        HashMap<String, String> unavailableAttributes;
        HashMap<String, Object> attributes;
        MBeanAttributeInfo[] attributesInfo;
        block17: {
            MBeanAttributeInfo attributeInfo;
            int i;
            if (mbean == null) {
                return;
            }
            attributesInfo = mbeanInfo.getAttributes();
            attributes = new HashMap<String, Object>(attributesInfo.length);
            unavailableAttributes = new HashMap<String, String>(attributesInfo.length);
            viewableAttributes = new HashMap<String, Object>(attributesInfo.length);
            AttributeList list = null;
            try {
                list = mbean.getAttributes(attributesInfo);
            }
            catch (Exception e) {
                list = new AttributeList();
                for (i = 0; i < attributesInfo.length; ++i) {
                    String name = null;
                    try {
                        name = attributesInfo[i].getName();
                        Object value = mbean.getAttribute(name);
                        list.add(new Attribute(name, value));
                        continue;
                    }
                    catch (Exception ex) {
                        if (!attributesInfo[i].isReadable()) continue;
                        unavailableAttributes.put(name, Utils.getActualException(ex).toString());
                    }
                }
            }
            try {
                int att_length = list.size();
                for (i = 0; i < att_length; ++i) {
                    Attribute attribute = (Attribute)list.get(i);
                    if (this.isViewable(attribute)) {
                        viewableAttributes.put(attribute.getName(), attribute.getValue());
                        continue;
                    }
                    attributes.put(attribute.getName(), attribute.getValue());
                }
                if (att_length >= attributesInfo.length) break block17;
                for (i = 0; i < attributesInfo.length; ++i) {
                    attributeInfo = attributesInfo[i];
                    if (attributes.containsKey(attributeInfo.getName()) || viewableAttributes.containsKey(attributeInfo.getName()) || unavailableAttributes.containsKey(attributeInfo.getName()) || !attributeInfo.isReadable()) continue;
                    try {
                        Object v = mbean.getAttribute(attributeInfo.getName());
                        attributes.put(attributeInfo.getName(), v);
                        continue;
                    }
                    catch (Exception e) {
                        unavailableAttributes.put(attributeInfo.getName(), Utils.getActualException(e).toString());
                    }
                }
            }
            catch (Exception e) {
                for (i = 0; i < attributesInfo.length; ++i) {
                    attributeInfo = attributesInfo[i];
                    if (!attributeInfo.isReadable()) continue;
                    unavailableAttributes.put(attributeInfo.getName(), Utils.getActualException(e).toString());
                }
            }
        }
        XMBeanAttributes xMBeanAttributes = this;
        synchronized (xMBeanAttributes) {
            this.mbean = mbean;
            this.mbeanInfo = mbeanInfo;
            this.attributesInfo = attributesInfo;
            this.attributes = attributes;
            this.unavailableAttributes = unavailableAttributes;
            this.viewableAttributes = viewableAttributes;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DefaultTableModel tableModel = (DefaultTableModel)XMBeanAttributes.this.getModel();
                    tableModel.removeTableModelListener(XMBeanAttributes.this.attributesListener);
                    XMBeanAttributes.this.emptyTable();
                    XMBeanAttributes.this.addTableData(tableModel, mbean, attributesInfo, attributes, unavailableAttributes, viewableAttributes);
                    tableModel.newDataAvailable(new TableModelEvent(tableModel));
                    tableModel.addTableModelListener(XMBeanAttributes.this.attributesListener);
                }
            });
        }
    }

    void collapse(String attributeName, Component c) {
        int row = this.getSelectedRow();
        Object obj = this.getModel().getValueAt(row, 1);
        if (obj instanceof ZoomedCell) {
            this.cancelCellEditing();
            ZoomedCell cell = (ZoomedCell)obj;
            cell.reset();
            this.setRowHeight(row, cell.getHeight());
            this.editCellAt(row, 1);
            this.invalidate();
            this.repaint();
        }
    }

    ZoomedCell updateZoomedCell(int row, int col) {
        Object obj = this.getModel().getValueAt(row, 1);
        ZoomedCell cell = null;
        if (obj instanceof ZoomedCell) {
            cell = (ZoomedCell)obj;
            if (!cell.isInited()) {
                Object elem = cell.getValue();
                String attributeName = (String)this.getModel().getValueAt(row, 0);
                Component comp = this.mbeansTab.getDataViewer().createAttributeViewer(elem, this.mbean, attributeName, this);
                if (comp != null) {
                    if (this.rowMinHeight == -1) {
                        this.rowMinHeight = this.getRowHeight(row);
                    }
                    cell.init(super.getCellRenderer(row, col), comp, this.rowMinHeight);
                    this.mbeansTab.getDataViewer();
                    XDataViewer.registerForMouseEvent(comp, this.mouseListener);
                } else {
                    return cell;
                }
            }
            cell.switchState();
            this.setRowHeight(row, cell.getHeight());
            if (!cell.isMaximized()) {
                this.cancelCellEditing();
                this.editCellAt(row, 1);
            }
            this.invalidate();
            this.repaint();
        }
        return cell;
    }

    public void refreshAttributes() {
        MBeanServerConnection mbsc = this.mbeansTab.getMBeanServerConnection();
        if (mbsc instanceof ProxyClient.SnapshotMBeanServerConnection) {
            ((ProxyClient.SnapshotMBeanServerConnection)mbsc).flush();
        }
        this.stopCellEditing();
        this.loadAttributes(this.mbean, this.mbeanInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emptyTable() {
        XMBeanAttributes xMBeanAttributes = this;
        synchronized (xMBeanAttributes) {
            ((DefaultTableModel)this.getModel()).removeTableModelListener(this.attributesListener);
            super.emptyTable();
        }
    }

    private boolean isViewable(Attribute attribute) {
        Object data = attribute.getValue();
        return XDataViewer.isViewableValue(data);
    }

    synchronized void removeAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
        if (this.unavailableAttributes != null) {
            this.unavailableAttributes.clear();
        }
        if (this.viewableAttributes != null) {
            this.viewableAttributes.clear();
        }
        this.mbean = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZoomedCell getZoomedCell(XMBean mbean, String attribute, Object value) {
        WeakHashMap<XMBean, HashMap<String, ZoomedCell>> weakHashMap = this.viewersCache;
        synchronized (weakHashMap) {
            ZoomedCell cell;
            HashMap<Object, Object> viewers = this.viewersCache.containsKey(mbean) ? this.viewersCache.get(mbean) : new HashMap();
            if (viewers.containsKey(attribute)) {
                cell = (ZoomedCell)viewers.get(attribute);
                cell.setValue(value);
                if (cell.isMaximized() && cell.getType() != 3) {
                    Component comp = this.mbeansTab.getDataViewer().createAttributeViewer(value, mbean, attribute, this);
                    cell.init(cell.getMinRenderer(), comp, cell.getMinHeight());
                    this.mbeansTab.getDataViewer();
                    XDataViewer.registerForMouseEvent(comp, this.mouseListener);
                }
            } else {
                cell = new ZoomedCell(value);
                viewers.put(attribute, cell);
            }
            this.viewersCache.put(mbean, viewers);
            return cell;
        }
    }

    protected void addTableData(DefaultTableModel tableModel, XMBean mbean, MBeanAttributeInfo[] attributesInfo, HashMap<String, Object> attributes, HashMap<String, Object> unavailableAttributes, HashMap<String, Object> viewableAttributes) {
        Object[] rowData = new Object[2];
        int col1Width = 0;
        int col2Width = 0;
        for (int i = 0; i < attributesInfo.length; ++i) {
            rowData[0] = attributesInfo[i].getName();
            if (unavailableAttributes.containsKey(rowData[0])) {
                rowData[1] = Resources.getText("Unavailable", new Object[0]);
            } else if (viewableAttributes.containsKey(rowData[0])) {
                rowData[1] = viewableAttributes.get(rowData[0]);
                if (!attributesInfo[i].isWritable() || !Utils.isEditableType(attributesInfo[i].getType())) {
                    rowData[1] = this.getZoomedCell(mbean, (String)rowData[0], rowData[1]);
                }
            } else {
                rowData[1] = attributes.get(rowData[0]);
            }
            tableModel.addRow(rowData);
            String str = null;
            if (rowData[0] != null && (str = rowData[0].toString()).length() > col1Width) {
                col1Width = str.length();
            }
            if (rowData[1] == null || (str = rowData[1].toString()).length() <= col2Width) continue;
            col2Width = str.length();
        }
        this.updateColumnWidth(col1Width, col2Width);
    }

    private void updateColumnWidth(int col1Width, int col2Width) {
        TableColumnModel colModel = this.getColumnModel();
        if ((col1Width *= 7) + (col2Width *= 7) < (int)this.getPreferredScrollableViewportSize().getWidth()) {
            col2Width = (int)this.getPreferredScrollableViewportSize().getWidth() - col1Width;
        }
        colModel.getColumn(0).setPreferredWidth(50);
    }

    class AttributesListener
    implements TableModelListener {
        private Component component;

        public AttributesListener(Component component) {
            this.component = component;
        }

        public void tableChanged(final TableModelEvent e) {
            final TableModel model = (TableModel)e.getSource();
            if (XMBeanAttributes.this.isColumnEditable(e.getColumn())) {
                XMBeanAttributes.this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            Object tableValue = model.getValueAt(e.getFirstRow(), e.getColumn());
                            if (tableValue instanceof String) {
                                tableValue = Utils.createObjectFromString(XMBeanAttributes.this.getClassName(e.getFirstRow()), (String)tableValue);
                            }
                            String attributeName = XMBeanAttributes.this.getValueName(e.getFirstRow());
                            Attribute attribute = new Attribute(attributeName, tableValue);
                            XMBeanAttributes.this.mbean.setAttribute(attribute);
                        }
                        catch (Throwable ex) {
                            if (JConsole.isDebug()) {
                                ex.printStackTrace();
                            }
                            String message = (ex = Utils.getActualException(ex)).getMessage() != null ? ex.getMessage() : ex.toString();
                            EventQueue.invokeLater(new ThreadDialog(AttributesListener.this.component, message + "\n", Resources.getText("Problem setting attribute", new Object[0]), 0));
                        }
                        XMBeanAttributes.this.refreshAttributes();
                    }
                });
            }
        }
    }

    class ZoomedCell {
        TableCellRenderer minRenderer;
        MaximizedCellRenderer maxRenderer;
        int minHeight;
        boolean minimized = true;
        boolean init = false;
        int type;
        Object value;

        ZoomedCell(Object value) {
            this.type = XDataViewer.getViewerType(value);
            this.value = value;
        }

        boolean isInited() {
            return this.init;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object value) {
            this.value = value;
        }

        void init(TableCellRenderer minRenderer, Component maxComponent, int minHeight) {
            this.minRenderer = minRenderer;
            this.maxRenderer = new MaximizedCellRenderer(maxComponent);
            this.minHeight = minHeight;
            this.init = true;
        }

        int getType() {
            return this.type;
        }

        void reset() {
            this.init = false;
            this.minimized = true;
        }

        void switchState() {
            this.minimized = !this.minimized;
        }

        boolean isMaximized() {
            return !this.minimized;
        }

        void minimize() {
            this.minimized = true;
        }

        void maximize() {
            this.minimized = false;
        }

        int getHeight() {
            if (this.minimized) {
                return this.minHeight;
            }
            return (int)this.maxRenderer.getComponent().getPreferredSize().getHeight();
        }

        int getMinHeight() {
            return this.minHeight;
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            if (this.value.getClass().isArray()) {
                String name = Utils.getArrayClassName(this.value.getClass().getName());
                int length = Array.getLength(this.value);
                return name + "[" + length + "]";
            }
            if (this.value instanceof CompositeData || this.value instanceof TabularData) {
                return this.value.getClass().getName();
            }
            return this.value.toString();
        }

        TableCellRenderer getRenderer() {
            if (this.minimized) {
                return this.minRenderer;
            }
            return this.maxRenderer;
        }

        TableCellRenderer getMinRenderer() {
            return this.minRenderer;
        }
    }

    class MaximizedCellRenderer
    extends DefaultTableCellRenderer {
        Component comp;

        MaximizedCellRenderer(Component comp) {
            this.comp = comp;
            Dimension d = comp.getPreferredSize();
            if (d.getHeight() > 200.0) {
                comp.setPreferredSize(new Dimension((int)d.getWidth(), 200));
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.comp;
        }

        public Component getComponent() {
            return this.comp;
        }
    }

    class ValueCellEditor
    extends XTextFieldEditor {
        ValueCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Object val = value;
            if (column == 1) {
                Object obj = XMBeanAttributes.this.getModel().getValueAt(row, column);
                if (obj instanceof ZoomedCell) {
                    ZoomedCell cell = (ZoomedCell)obj;
                    if (cell.getRenderer() instanceof MaximizedCellRenderer) {
                        MaximizedCellRenderer zr = (MaximizedCellRenderer)cell.getRenderer();
                        return zr.getComponent();
                    }
                } else {
                    Component comp = super.getTableCellEditorComponent(table, val, isSelected, row, column);
                    if (XMBeanAttributes.this.isCellError(row, column) || !XMBeanAttributes.this.isWritable(row) || !Utils.isEditableType(XMBeanAttributes.this.getClassName(row))) {
                        this.textField.setEditable(false);
                    }
                    return comp;
                }
            }
            return super.getTableCellEditorComponent(table, val, isSelected, row, column);
        }

        public boolean stopCellEditing() {
            ZoomedCell cell;
            Object obj;
            int editingRow = XMBeanAttributes.this.getEditingRow();
            int editingColumn = XMBeanAttributes.this.getEditingColumn();
            if (editingColumn == 1 && (obj = XMBeanAttributes.this.getModel().getValueAt(editingRow, editingColumn)) instanceof ZoomedCell && (cell = (ZoomedCell)obj).isMaximized()) {
                this.cancelCellEditing();
                return true;
            }
            return super.stopCellEditing();
        }
    }

    class AttributesMouseListener
    extends MouseAdapter {
        AttributesMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() >= 2) {
                int row = XMBeanAttributes.this.getSelectedRow();
                int col = XMBeanAttributes.this.getSelectedColumn();
                if (col != 1) {
                    return;
                }
                if (col == -1 || row == -1) {
                    return;
                }
                XMBeanAttributes.this.updateZoomedCell(row, col);
            }
        }
    }
}

