/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.jconsole.JConsolePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.login.FailedLoginException;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.BorderUIResource;
import sun.net.util.IPAddressUtil;
import sun.tools.jconsole.AboutDialog;
import sun.tools.jconsole.ConnectDialog;
import sun.tools.jconsole.CreateMBeanDialog;
import sun.tools.jconsole.LocalVirtualMachine;
import sun.tools.jconsole.OutputViewer;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMInternalFrame;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JConsole
extends JFrame
implements ActionListener,
InternalFrameListener {
    static boolean IS_GTK;
    static boolean IS_WIN;
    private static final String title;
    public static final String ROOT_URL = "service:jmx:";
    private static int updateInterval;
    private static String pluginPath;
    private JMenuBar menuBar;
    private JMenuItem hotspotMI;
    private JMenuItem connectMI;
    private JMenuItem exitMI;
    private WindowMenu windowMenu;
    private JMenuItem tileMI;
    private JMenuItem cascadeMI;
    private JMenuItem minimizeAllMI;
    private JMenuItem restoreAllMI;
    private JMenuItem userGuideMI;
    private JMenuItem aboutMI;
    private JButton connectButton;
    private JDesktopPane desktop;
    private ConnectDialog connectDialog;
    private CreateMBeanDialog createDialog;
    private ArrayList<VMInternalFrame> windows = new ArrayList();
    private int frameLoc = 5;
    static boolean debug;
    private static final boolean localAttachmentSupported;
    private static ServiceLoader<JConsolePlugin> pluginService;

    static void updateLafValues() {
        String lafName = UIManager.getLookAndFeel().getClass().getName();
        IS_GTK = lafName.equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        IS_WIN = lafName.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    }

    public JConsole(boolean hotspot) {
        super(title);
        this.setRootPane(new FixedJRootPane());
        Utilities.setAccessibleDescription(this, Resources.getText("JConsole.accessibleDescription", new Object[0]));
        this.setDefaultCloseOperation(3);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu connectionMenu = new JMenu(Resources.getText("Connection", new Object[0]));
        connectionMenu.setMnemonic(Resources.getMnemonicInt("Connection"));
        this.menuBar.add(connectionMenu);
        if (hotspot) {
            this.hotspotMI = new JMenuItem(Resources.getText("Hotspot MBeans...", new Object[0]));
            this.hotspotMI.setMnemonic(Resources.getMnemonicInt("Hotspot MBeans..."));
            this.hotspotMI.setAccelerator(KeyStroke.getKeyStroke(72, 2));
            this.hotspotMI.addActionListener(this);
            connectionMenu.add(this.hotspotMI);
            connectionMenu.addSeparator();
        }
        this.connectMI = new JMenuItem(Resources.getText("New Connection...", new Object[0]));
        this.connectMI.setMnemonic(Resources.getMnemonicInt("New Connection..."));
        this.connectMI.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.connectMI.addActionListener(this);
        connectionMenu.add(this.connectMI);
        connectionMenu.addSeparator();
        this.exitMI = new JMenuItem(Resources.getText("Exit", new Object[0]));
        this.exitMI.setMnemonic(Resources.getMnemonicInt("Exit"));
        this.exitMI.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.exitMI.addActionListener(this);
        connectionMenu.add(this.exitMI);
        JMenu helpMenu = new JMenu(Resources.getText("HelpMenu.title", new Object[0]));
        helpMenu.setMnemonic(Resources.getMnemonicInt("HelpMenu.title"));
        this.menuBar.add(helpMenu);
        if (AboutDialog.isBrowseSupported()) {
            this.userGuideMI = new JMenuItem(Resources.getText("HelpMenu.UserGuide.title", new Object[0]));
            this.userGuideMI.setMnemonic(Resources.getMnemonicInt("HelpMenu.UserGuide.title"));
            this.userGuideMI.addActionListener(this);
            helpMenu.add(this.userGuideMI);
            helpMenu.addSeparator();
        }
        this.aboutMI = new JMenuItem(Resources.getText("HelpMenu.About.title", new Object[0]));
        this.aboutMI.setMnemonic(Resources.getMnemonicInt("HelpMenu.About.title"));
        this.aboutMI.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.aboutMI.addActionListener(this);
        helpMenu.add(this.aboutMI);
    }

    public JDesktopPane getDesktopPane() {
        return this.desktop;
    }

    public List<VMInternalFrame> getInternalFrames() {
        return this.windows;
    }

    private void createMDI() {
        this.setTitle(title);
        Container cp = this.getContentPane();
        Component oldCenter = ((BorderLayout)cp.getLayout()).getLayoutComponent("Center");
        this.windowMenu = new WindowMenu(Resources.getText("Window", new Object[0]));
        this.windowMenu.setMnemonic(Resources.getMnemonicInt("Window"));
        this.menuBar.add((Component)this.windowMenu, this.menuBar.getComponentCount() - 1);
        this.desktop = new JDesktopPane();
        this.desktop.setBackground(new Color(235, 245, 255));
        cp.add((Component)this.desktop, "Center");
        if (oldCenter instanceof VMPanel) {
            this.addFrame((VMPanel)oldCenter);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JMenuItem mi;
        VMInternalFrame vmIF;
        Object src = ev.getSource();
        if (src == this.hotspotMI) {
            this.showCreateMBeanDialog();
        }
        if (src == this.connectButton || src == this.connectMI) {
            VMPanel vmPanel = null;
            JInternalFrame vmIF2 = this.desktop.getSelectedFrame();
            if (vmIF2 instanceof VMInternalFrame) {
                vmPanel = ((VMInternalFrame)vmIF2).getVMPanel();
            }
            String hostName = "";
            String url = "";
            if (vmPanel != null) {
                hostName = vmPanel.getHostName();
                if (vmPanel.getUrl() != null) {
                    url = vmPanel.getUrl();
                }
            }
            this.showConnectDialog(url, hostName, 0, null, null, null);
        } else if (src == this.tileMI) {
            this.tileWindows();
        } else if (src == this.cascadeMI) {
            this.cascadeWindows();
        } else if (src == this.minimizeAllMI) {
            for (VMInternalFrame vmIF3 : this.windows) {
                try {
                    vmIF3.setIcon(true);
                }
                catch (PropertyVetoException ex) {}
            }
        } else if (src == this.restoreAllMI) {
            for (VMInternalFrame vmIF4 : this.windows) {
                try {
                    vmIF4.setIcon(false);
                }
                catch (PropertyVetoException ex) {}
            }
        } else if (src == this.exitMI) {
            System.exit(0);
        } else if (src == this.userGuideMI) {
            AboutDialog.browseUserGuide(this);
        } else if (src == this.aboutMI) {
            AboutDialog.showAboutDialog(this);
        } else if (src instanceof JMenuItem && (vmIF = (VMInternalFrame)(mi = (JMenuItem)src).getClientProperty("JConsole.vmIF")) != null) {
            try {
                vmIF.setIcon(false);
                vmIF.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
            vmIF.moveToFront();
        }
    }

    public void tileWindows() {
        int w = -1;
        int h = -1;
        int n = 0;
        for (VMInternalFrame vmIF : this.windows) {
            if (vmIF.isIcon()) continue;
            ++n;
            if (w != -1) continue;
            try {
                vmIF.setMaximum(true);
                w = vmIF.getWidth();
                h = vmIF.getHeight();
            }
            catch (PropertyVetoException ex) {}
        }
        if (n > 0 && w > 0 && h > 0) {
            int cols;
            int rows = (int)Math.ceil(Math.sqrt(n));
            if (rows * (cols = n / rows) < n) {
                ++cols;
            }
            int x = 0;
            int y = 0;
            w /= cols;
            h /= rows;
            int col = 0;
            for (VMInternalFrame vmIF : this.windows) {
                if (vmIF.isIcon()) continue;
                try {
                    vmIF.setMaximum(n == 1);
                }
                catch (PropertyVetoException ex) {
                    // empty catch block
                }
                if (n > 1) {
                    vmIF.setBounds(x, y, w, h);
                }
                if (col < cols - 1) {
                    ++col;
                    x += w;
                    continue;
                }
                col = 0;
                x = 0;
                y += h;
            }
        }
    }

    public void cascadeWindows() {
        int n = 0;
        int w = -1;
        int h = -1;
        for (VMInternalFrame vmIF : this.windows) {
            if (vmIF.isIcon()) continue;
            try {
                vmIF.setMaximum(false);
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
            ++n;
            vmIF.pack();
            if (w != -1) continue;
            try {
                w = vmIF.getWidth();
                h = vmIF.getHeight();
                vmIF.setMaximum(true);
                w = vmIF.getWidth() - w;
                h = vmIF.getHeight() - h;
                vmIF.pack();
            }
            catch (PropertyVetoException ex) {}
        }
        int x = 0;
        int y = 0;
        int dX = n > 1 ? w / (n - 1) : 0;
        int dY = n > 1 ? h / (n - 1) : 0;
        for (VMInternalFrame vmIF : this.windows) {
            if (vmIF.isIcon()) continue;
            vmIF.setLocation(x, y);
            vmIF.moveToFront();
            x += dX;
            y += dY;
        }
    }

    void addHost(String hostName, int port, String userName, String password) {
        this.addHost(hostName, port, userName, password, false);
    }

    void addVmid(LocalVirtualMachine lvm) {
        this.addVmid(lvm, false);
    }

    void addVmid(final LocalVirtualMachine lvm, final boolean tile) {
        new Thread("JConsole.addVmid"){

            public void run() {
                try {
                    JConsole.this.addProxyClient(ProxyClient.getProxyClient(lvm), tile);
                }
                catch (SecurityException ex) {
                    JConsole.this.failed(ex, null, null, null);
                }
                catch (IOException ex) {
                    JConsole.this.failed(ex, null, null, null);
                }
            }
        }.start();
    }

    void addUrl(final String url, final String userName, final String password, final boolean tile) {
        new Thread("JConsole.addUrl"){

            public void run() {
                try {
                    JConsole.this.addProxyClient(ProxyClient.getProxyClient(url, userName, password), tile);
                }
                catch (MalformedURLException ex) {
                    JConsole.this.failed(ex, url, userName, password);
                }
                catch (SecurityException ex) {
                    JConsole.this.failed(ex, url, userName, password);
                }
                catch (IOException ex) {
                    JConsole.this.failed(ex, url, userName, password);
                }
            }
        }.start();
    }

    void addHost(final String hostName, final int port, final String userName, final String password, final boolean tile) {
        new Thread("JConsole.addHost"){

            public void run() {
                try {
                    JConsole.this.addProxyClient(ProxyClient.getProxyClient(hostName, port, userName, password), tile);
                }
                catch (IOException ex) {
                    JConsole.dbgStackTrace(ex);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JConsole.this.showConnectDialog(null, hostName, port, userName, password, JConsole.this.errorMessage(ex));
                        }
                    });
                }
            }
        }.start();
    }

    void addProxyClient(final ProxyClient proxyClient, final boolean tile) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VMPanel vmPanel = new VMPanel(proxyClient, updateInterval);
                JConsole.this.addFrame(vmPanel);
                if (tile) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JConsole.this.tileWindows();
                        }
                    });
                }
                vmPanel.connect();
            }
        });
    }

    private void failed(final Exception ex, final String url, final String userName, final String password) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JConsole.dbgStackTrace(ex);
                JConsole.this.showConnectDialog(url, null, -1, userName, password, JConsole.this.errorMessage(ex));
            }
        });
    }

    private VMInternalFrame addFrame(VMPanel vmPanel) {
        VMInternalFrame vmIF = new VMInternalFrame(vmPanel);
        for (VMInternalFrame f : this.windows) {
            try {
                f.setMaximum(false);
            }
            catch (PropertyVetoException ex) {}
        }
        this.desktop.add(vmIF);
        vmIF.setLocation(this.frameLoc, this.frameLoc);
        this.frameLoc += 30;
        vmIF.setVisible(true);
        this.windows.add(vmIF);
        if (this.windows.size() == 1) {
            try {
                vmIF.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        vmIF.addInternalFrameListener(this);
        this.windowMenu.add(vmIF);
        return vmIF;
    }

    private void showConnectDialog(String url, String hostName, int port, String userName, String password, String msg) {
        if (this.connectDialog == null) {
            this.connectDialog = new ConnectDialog(this);
        }
        this.connectDialog.setConnectionParameters(url, hostName, port, userName, password, msg);
        this.connectDialog.refresh();
        this.connectDialog.setVisible(true);
        try {
            this.connectDialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
    }

    private void showCreateMBeanDialog() {
        if (this.createDialog == null) {
            this.createDialog = new CreateMBeanDialog(this);
        }
        this.createDialog.setVisible(true);
        try {
            this.createDialog.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void removeVMInternalFrame(VMInternalFrame vmIF) {
        this.windowMenu.remove(vmIF);
        this.desktop.remove(vmIF);
        this.desktop.repaint();
        vmIF.getVMPanel().cleanUp();
        vmIF.dispose();
    }

    private boolean isProxyClientUsed(ProxyClient client) {
        for (VMInternalFrame frame : this.windows) {
            ProxyClient cli = frame.getVMPanel().getProxyClient(false);
            if (client != cli) continue;
            return true;
        }
        return false;
    }

    static boolean isValidRemoteString(String txt) {
        boolean valid = false;
        if (txt != null) {
            if ((txt = txt.trim()).startsWith(ROOT_URL)) {
                if (txt.length() > ROOT_URL.length()) {
                    valid = true;
                }
            } else if (txt.startsWith("[")) {
                String address;
                int index = txt.indexOf("]:");
                if (index != -1 && IPAddressUtil.isIPv6LiteralAddress(address = txt.substring(1, index))) {
                    try {
                        String portStr = txt.substring(index + 2);
                        int port = Integer.parseInt(portStr);
                        if (port >= 0 && port <= 65535) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        valid = false;
                    }
                }
            } else {
                String[] s = txt.split(":");
                if (s.length == 2) {
                    try {
                        int port = Integer.parseInt(s[1]);
                        if (port >= 0 && port <= 65535) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        valid = false;
                    }
                }
            }
        }
        return valid;
    }

    private String errorMessage(Exception ex) {
        String msg = Resources.getText("Connection failed", new Object[0]);
        if (ex instanceof IOException || ex instanceof SecurityException) {
            Throwable cause = null;
            for (Throwable c = ex.getCause(); c != null; c = c.getCause()) {
                cause = c;
            }
            if (cause instanceof ConnectException) {
                return msg + ": " + cause.getMessage();
            }
            if (cause instanceof UnknownHostException) {
                return Resources.getText("Unknown Host", cause.getMessage());
            }
            if (cause instanceof NoRouteToHostException) {
                return msg + ": " + cause.getMessage();
            }
            if (cause instanceof FailedLoginException) {
                return msg + ": " + cause.getMessage();
            }
            if (cause instanceof SSLHandshakeException) {
                return msg + ": " + cause.getMessage();
            }
        } else if (ex instanceof MalformedURLException) {
            return Resources.getText("Invalid URL", ex.getMessage());
        }
        return msg + ": " + ex.getMessage();
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        VMInternalFrame vmIF = (VMInternalFrame)e.getInternalFrame();
        this.removeVMInternalFrame(vmIF);
        this.windows.remove(vmIF);
        ProxyClient client = vmIF.getVMPanel().getProxyClient(false);
        if (!this.isProxyClientUsed(client)) {
            client.markAsDead();
        }
        if (this.windows.size() == 0) {
            this.showConnectDialog("", "", 0, null, null, null);
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    private static void usage() {
        System.err.println(Resources.getText("zz usage text", "jconsole"));
    }

    private static void mainInit(final List<String> urls, final List<String> hostNames, final List<Integer> ports, final List<LocalVirtualMachine> vmids, ProxyClient proxyClient, final boolean noTile, final boolean hotspot) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i;
                JConsole jConsole = new JConsole(hotspot);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                GraphicsConfiguration gc = jConsole.getGraphicsConfiguration();
                Dimension scrSize = toolkit.getScreenSize();
                Insets scrInsets = toolkit.getScreenInsets(gc);
                Rectangle scrBounds = new Rectangle(scrInsets.left, scrInsets.top, scrSize.width - scrInsets.left - scrInsets.right, scrSize.height - scrInsets.top - scrInsets.bottom);
                int w = Math.min(900, scrBounds.width);
                int h = Math.min(750, scrBounds.height);
                jConsole.setBounds(scrBounds.x + (scrBounds.width - w) / 2, scrBounds.y + (scrBounds.height - h) / 2, w, h);
                jConsole.setVisible(true);
                jConsole.createMDI();
                for (i = 0; i < hostNames.size(); ++i) {
                    jConsole.addHost((String)hostNames.get(i), (Integer)ports.get(i), null, null, i == hostNames.size() - 1 ? !noTile : false);
                }
                for (i = 0; i < urls.size(); ++i) {
                    jConsole.addUrl((String)urls.get(i), null, null, i == urls.size() - 1 ? !noTile : false);
                }
                for (i = 0; i < vmids.size(); ++i) {
                    jConsole.addVmid((LocalVirtualMachine)vmids.get(i), i == vmids.size() - 1 ? !noTile : false);
                }
                if (vmids.size() == 0 && hostNames.size() == 0 && urls.size() == 0) {
                    jConsole.showConnectDialog(null, null, 0, null, null, null);
                }
            }
        });
    }

    public static void main(String[] args) {
        boolean noTile = false;
        boolean hotspot = false;
        int argIndex = 0;
        ProxyClient proxyClient = null;
        if (System.getProperty("jconsole.showOutputViewer") != null) {
            OutputViewer.init();
        }
        while (args.length - argIndex > 0 && args[argIndex].startsWith("-")) {
            String arg;
            if ((arg = args[argIndex++]).equals("-h") || arg.equals("-help") || arg.equals("-?")) {
                JConsole.usage();
                return;
            }
            if (arg.startsWith("-interval=")) {
                try {
                    updateInterval = Integer.parseInt(arg.substring(10)) * 1000;
                    continue;
                }
                catch (NumberFormatException ex) {
                    JConsole.usage();
                    return;
                }
            }
            if (arg.equals("-pluginpath")) {
                if (argIndex < args.length && !args[argIndex].startsWith("-")) {
                    pluginPath = args[argIndex++];
                    continue;
                }
                JConsole.usage();
                return;
            }
            if (arg.equals("-notile")) {
                noTile = true;
                continue;
            }
            if (arg.equals("-version")) {
                Version.print(System.err);
                return;
            }
            if (arg.equals("-debug")) {
                debug = true;
                continue;
            }
            if (arg.equals("-fullversion")) {
                Version.printFullVersion(System.err);
                return;
            }
            JConsole.usage();
            return;
        }
        if (System.getProperty("jconsole.showUnsupported") != null) {
            hotspot = true;
        }
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> hostNames = new ArrayList<String>();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ArrayList<LocalVirtualMachine> vms = new ArrayList<LocalVirtualMachine>();
        for (int i = argIndex; i < args.length; ++i) {
            String arg = args[i];
            if (JConsole.isValidRemoteString(arg)) {
                if (arg.startsWith(ROOT_URL)) {
                    urls.add(arg);
                    continue;
                }
                if (!arg.matches(".*:[0-9]*")) continue;
                int p = arg.lastIndexOf(58);
                hostNames.add(arg.substring(0, p));
                try {
                    ports.add(Integer.parseInt(arg.substring(p + 1)));
                    continue;
                }
                catch (NumberFormatException ex) {
                    JConsole.usage();
                    return;
                }
            }
            if (!JConsole.isLocalAttachAvailable()) {
                System.err.println("Local process monitoring is not supported");
                return;
            }
            try {
                int vmid = Integer.parseInt(arg);
                LocalVirtualMachine lvm = LocalVirtualMachine.getLocalVirtualMachine(vmid);
                if (lvm == null) {
                    System.err.println("Invalid process id:" + vmid);
                    return;
                }
                vms.add(lvm);
                continue;
            }
            catch (NumberFormatException ex) {
                JConsole.usage();
                return;
            }
        }
        JConsole.mainInit(urls, hostNames, ports, vms, proxyClient, noTile, hotspot);
    }

    public static boolean isDebug() {
        return debug;
    }

    private static void dbgStackTrace(Exception ex) {
        if (debug) {
            ex.printStackTrace();
        }
    }

    public static boolean isLocalAttachAvailable() {
        return localAttachmentSupported;
    }

    static synchronized List<JConsolePlugin> getPlugins() {
        if (pluginService == null) {
            JConsole.initPluginService(pluginPath);
        } else {
            pluginService.reload();
        }
        ArrayList<JConsolePlugin> plugins = new ArrayList<JConsolePlugin>();
        for (JConsolePlugin p : pluginService) {
            plugins.add(p);
        }
        return plugins;
    }

    private static void initPluginService(String pluginPath) {
        if (pluginPath.length() > 0) {
            try {
                URLClassLoader pluginCL = new URLClassLoader(JConsole.pathToURLs(pluginPath));
                ServiceLoader<JConsolePlugin> plugins = ServiceLoader.load(JConsolePlugin.class, pluginCL);
                for (JConsolePlugin p : plugins) {
                    if (!JConsole.isDebug()) continue;
                    System.out.println("Plugin " + p.getClass() + " loaded.");
                }
                pluginService = plugins;
            }
            catch (ServiceConfigurationError e) {
                System.out.println(Resources.getText("Fail to load plugin", e.getMessage()));
            }
            catch (MalformedURLException e) {
                if (JConsole.isDebug()) {
                    e.printStackTrace();
                }
                System.out.println(Resources.getText("Invalid plugin path", e.getMessage()));
            }
        }
        if (pluginService == null) {
            JConsole.initEmptyPlugin();
        }
    }

    private static void initEmptyPlugin() {
        URLClassLoader pluginCL = new URLClassLoader(new URL[0]);
        pluginService = ServiceLoader.load(JConsolePlugin.class, pluginCL);
    }

    private static URL[] pathToURLs(String path) throws MalformedURLException {
        String[] names = path.split(File.pathSeparator);
        URL[] urls = new URL[names.length];
        int count = 0;
        for (String f : names) {
            URL url = JConsole.fileToURL(new File(f));
            urls[count++] = url;
        }
        return urls;
    }

    private static URL fileToURL(File file) throws MalformedURLException {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        return new URL("file", "", name);
    }

    static {
        boolean supported;
        String systemLaF;
        if (System.getProperty("swing.defaultlaf") == null && ((systemLaF = UIManager.getSystemLookAndFeelClassName()).equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") || systemLaF.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel"))) {
            try {
                UIManager.setLookAndFeel(systemLaF);
            }
            catch (Exception e) {
                System.err.println(Resources.getText("JConsole: ", e.getMessage()));
            }
        }
        JConsole.updateLafValues();
        title = Resources.getText("Java Monitoring & Management Console", new Object[0]);
        updateInterval = 4000;
        pluginPath = "";
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            Class.forName("sun.management.ConnectorAddressLink");
            supported = true;
        }
        catch (NoClassDefFoundError x) {
            supported = false;
        }
        catch (ClassNotFoundException x) {
            supported = false;
        }
        localAttachmentSupported = supported;
        pluginService = null;
    }

    private static class FixedJRootPane
    extends JRootPane {
        private FixedJRootPane() {
        }

        public void updateUI() {
            JConsole.updateLafValues();
            super.updateUI();
        }

        public void revalidate() {
            UIManager.put("TitledBorder.border", null);
            Border border = UIManager.getBorder("TitledBorder.border");
            if (border instanceof BorderUIResource.EtchedBorderUIResource) {
                Color highlight = UIManager.getColor("ToolBar.highlight");
                Color shadow = UIManager.getColor("ToolBar.shadow");
                border = new BorderUIResource.EtchedBorderUIResource(highlight, shadow);
                UIManager.put("TitledBorder.border", border);
            }
            if (IS_GTK) {
                UIManager.put("TitledBorder.titleColor", UIManager.getColor("Label.foreground"));
                UIManager.put("TitledBorder.font", UIManager.getFont("Label.font"));
            }
            super.revalidate();
        }
    }

    private class WindowMenu
    extends JMenu {
        VMInternalFrame[] windowMenuWindows;
        int separatorPosition;
        Rectangle viewR;
        Rectangle textR;
        Rectangle iconR;

        WindowMenu(String text) {
            super(text);
            this.windowMenuWindows = new VMInternalFrame[0];
            this.viewR = new Rectangle(0, 0, 400, 20);
            this.textR = new Rectangle(0, 0, 0, 0);
            this.iconR = new Rectangle(0, 0, 0, 0);
            JConsole.this.cascadeMI = new JMenuItem(Resources.getText("Cascade", new Object[0]));
            JConsole.this.cascadeMI.setMnemonic(Resources.getMnemonicInt("Cascade"));
            JConsole.this.cascadeMI.addActionListener(JConsole.this);
            this.add(JConsole.this.cascadeMI);
            JConsole.this.tileMI = new JMenuItem(Resources.getText("Tile", new Object[0]));
            JConsole.this.tileMI.setMnemonic(Resources.getMnemonicInt("Tile"));
            JConsole.this.tileMI.setAccelerator(KeyStroke.getKeyStroke(84, 2));
            JConsole.this.tileMI.addActionListener(JConsole.this);
            this.add(JConsole.this.tileMI);
            JConsole.this.minimizeAllMI = new JMenuItem(Resources.getText("Minimize All", new Object[0]));
            JConsole.this.minimizeAllMI.setMnemonic(Resources.getMnemonicInt("Minimize All"));
            JConsole.this.minimizeAllMI.addActionListener(JConsole.this);
            this.add(JConsole.this.minimizeAllMI);
            JConsole.this.restoreAllMI = new JMenuItem(Resources.getText("Restore All", new Object[0]));
            JConsole.this.restoreAllMI.setMnemonic(Resources.getMnemonicInt("Restore All"));
            JConsole.this.restoreAllMI.addActionListener(JConsole.this);
            this.add(JConsole.this.restoreAllMI);
            this.separatorPosition = this.getMenuComponentCount();
        }

        private void add(VMInternalFrame vmIF) {
            if (this.separatorPosition == this.getMenuComponentCount()) {
                this.addSeparator();
            }
            int index = -1;
            int position = this.separatorPosition + 1;
            int n = this.windowMenuWindows.length;
            for (int i = 0; i < n; ++i) {
                if (this.windowMenuWindows[i] != null) {
                    ++position;
                    continue;
                }
                index = i;
                break;
            }
            if (index == -1) {
                VMInternalFrame[] newArray = new VMInternalFrame[n + 1];
                System.arraycopy(this.windowMenuWindows, 0, newArray, 0, n);
                this.windowMenuWindows = newArray;
                index = n;
            }
            this.windowMenuWindows[index] = vmIF;
            String indexString = "" + (index + 1);
            String vmName = vmIF.getVMPanel().getDisplayName();
            String text = SwingUtilities.layoutCompoundLabel(this, this.getGraphics().getFontMetrics(this.getFont()), indexString + " " + vmName, null, 0, 0, 0, 0, this.viewR, this.iconR, this.textR, 0);
            JMenuItem mi = new JMenuItem(text);
            if (text.endsWith("...")) {
                mi.setToolTipText(vmName);
            }
            int nDigits = indexString.length();
            mi.setMnemonic(indexString.charAt(nDigits - 1));
            mi.setDisplayedMnemonicIndex(nDigits - 1);
            mi.putClientProperty("JConsole.vmIF", vmIF);
            mi.addActionListener(JConsole.this);
            vmIF.putClientProperty("JConsole.menuItem", mi);
            this.add((Component)mi, position);
        }

        private void remove(VMInternalFrame vmIF) {
            for (int i = 0; i < this.windowMenuWindows.length; ++i) {
                if (this.windowMenuWindows[i] != vmIF) continue;
                this.windowMenuWindows[i] = null;
            }
            JMenuItem mi = (JMenuItem)vmIF.getClientProperty("JConsole.menuItem");
            this.remove(mi);
            mi.putClientProperty("JConsole.vmIF", null);
            vmIF.putClientProperty("JConsole.menuItem", null);
            if (this.separatorPosition == this.getMenuComponentCount() - 1) {
                this.remove(this.getMenuComponent(this.getMenuComponentCount() - 1));
            }
        }
    }
}

