/*
 * Decompiled with CFR 0.152.
 */
package com.sun.inputmethods.internal.indicim;

import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.spi.InputMethodContext;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

class IndicInputMethodImpl {
    protected char[] KBD_MAP;
    private static final char SUBSTITUTION_BASE = '\uff00';
    protected char[][] SUBSTITUTION_TABLE;
    private static final char INVALID_CHAR = '\uffff';
    private static final char KEY_SIGN_VIRAMA = 'd';
    private static final char KEY_SIGN_NUKTA = ']';
    private static final char ZWJ = '\u200d';
    private static final char ZWNJ = '\u200c';
    private static final char BACKSPACE = '\b';
    protected char[] JOIN_WITH_NUKTA;
    protected char[] NUKTA_FORM;
    private int log2;
    private int power;
    private int extra;
    private static final TextHitInfo ZERO_TRAILING_HIT_INFO = TextHitInfo.trailing(0);
    private char[] text = new char[4];
    private int committedChars = 0;
    private int totalChars = 0;
    private boolean lastCharWasVirama = false;
    private InputMethodContext context;

    private int nuktaIndex(char ch) {
        if (this.JOIN_WITH_NUKTA == null) {
            return -1;
        }
        int probe = this.power;
        int index = 0;
        if (this.JOIN_WITH_NUKTA[this.extra] <= ch) {
            index = this.extra;
        }
        while (probe > 1) {
            if (this.JOIN_WITH_NUKTA[index + (probe >>= 1)] > ch) continue;
            index += probe;
        }
        if (this.JOIN_WITH_NUKTA[index] != ch) {
            index = -1;
        }
        return index;
    }

    private char getMappedChar(char originalChar) {
        if (originalChar <= this.KBD_MAP.length) {
            return this.KBD_MAP[originalChar];
        }
        return originalChar;
    }

    private static byte highBit(int n) {
        if (n <= 0) {
            return -32;
        }
        byte bit = 0;
        if (n >= 65536) {
            n >>= 16;
            bit = (byte)(bit + 16);
        }
        if (n >= 256) {
            n >>= 8;
            bit = (byte)(bit + 8);
        }
        if (n >= 16) {
            n >>= 4;
            bit = (byte)(bit + 4);
        }
        if (n >= 4) {
            n >>= 2;
            bit = (byte)(bit + 2);
        }
        if (n >= 2) {
            n >>= 1;
            bit = (byte)(bit + 1);
        }
        return bit;
    }

    IndicInputMethodImpl(char[] keyboardMap, char[] joinWithNukta, char[] nuktaForm, char[][] substitutionTable) {
        this.KBD_MAP = keyboardMap;
        this.JOIN_WITH_NUKTA = joinWithNukta;
        this.NUKTA_FORM = nuktaForm;
        this.SUBSTITUTION_TABLE = substitutionTable;
        if (this.JOIN_WITH_NUKTA != null) {
            byte log2 = IndicInputMethodImpl.highBit(this.JOIN_WITH_NUKTA.length);
            this.power = 1 << log2;
            this.extra = this.JOIN_WITH_NUKTA.length - this.power;
        } else {
            this.extra = 0;
            this.power = 0;
        }
    }

    void setInputMethodContext(InputMethodContext context) {
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleKeyTyped(KeyEvent kevent) {
        int nuktaIndex;
        char keyChar = kevent.getKeyChar();
        char currentChar = this.getMappedChar(keyChar);
        if (this.lastCharWasVirama) {
            switch (keyChar) {
                case ']': {
                    currentChar = '\u200d';
                    break;
                }
                case 'd': {
                    currentChar = '\u200c';
                    break;
                }
            }
        }
        if (currentChar == '\uffff') {
            kevent.consume();
            return;
        }
        if (currentChar == '\b') {
            this.lastCharWasVirama = false;
            if (this.totalChars <= 0) return;
            this.committedChars = 0;
            this.totalChars = 0;
        } else if (keyChar == ']') {
            nuktaIndex = this.nuktaIndex(this.text[0]);
            if (nuktaIndex != -1) {
                this.text[0] = this.NUKTA_FORM[nuktaIndex];
            } else {
                this.text[this.totalChars++] = currentChar;
            }
            ++this.committedChars;
        } else {
            nuktaIndex = this.nuktaIndex(currentChar);
            if (nuktaIndex != -1) {
                this.text[this.totalChars++] = currentChar;
                this.committedChars = this.totalChars - 1;
            } else {
                if (currentChar >= '\uff00') {
                    char[] sub = this.SUBSTITUTION_TABLE[currentChar - 65280];
                    System.arraycopy(sub, 0, this.text, this.totalChars, sub.length);
                    this.totalChars += sub.length;
                } else {
                    this.text[this.totalChars++] = currentChar;
                }
                this.committedChars = this.totalChars;
            }
        }
        ACIText aText = new ACIText(this.text, 0, this.totalChars, this.committedChars);
        int composedCharLength = this.totalChars - this.committedChars;
        TextHitInfo caret = null;
        TextHitInfo visiblePosition = null;
        switch (composedCharLength) {
            case 0: {
                break;
            }
            case 1: {
                visiblePosition = caret = ZERO_TRAILING_HIT_INFO;
                break;
            }
            default: {
                assert (false) : "The code should not reach here. There is no case where there can be more than one character pending.";
                break;
            }
        }
        this.context.dispatchInputMethodEvent(1100, aText, this.committedChars, caret, visiblePosition);
        this.text[0] = this.totalChars == 0 ? 65535 : this.text[this.totalChars - 1];
        this.lastCharWasVirama = keyChar == 'd' && !this.lastCharWasVirama;
        this.totalChars -= this.committedChars;
        this.committedChars = 0;
        kevent.consume();
    }

    void endComposition() {
        if (this.totalChars != 0) {
            ACIText aText = new ACIText(this.text, 0, this.totalChars, this.totalChars);
            this.context.dispatchInputMethodEvent(1100, aText, this.totalChars, null, null);
            this.committedChars = 0;
            this.totalChars = 0;
            this.text[0] = 65535;
            this.lastCharWasVirama = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ACIText
    implements AttributedCharacterIterator {
        private char[] text = null;
        private int committed = 0;
        private int index = 0;

        ACIText(char[] chArray, int offset, int length, int committed) {
            this.text = new char[length];
            this.committed = committed;
            System.arraycopy(chArray, offset, this.text, 0, length);
        }

        @Override
        public char first() {
            return this._setIndex(0);
        }

        @Override
        public char last() {
            if (this.text.length == 0) {
                return this._setIndex(this.text.length);
            }
            return this._setIndex(this.text.length - 1);
        }

        @Override
        public char current() {
            if (this.index == this.text.length) {
                return '\uffff';
            }
            return this.text[this.index];
        }

        @Override
        public char next() {
            if (this.index == this.text.length) {
                return '\uffff';
            }
            return this._setIndex(this.index + 1);
        }

        @Override
        public char previous() {
            if (this.index == 0) {
                return '\uffff';
            }
            return this._setIndex(this.index - 1);
        }

        @Override
        public char setIndex(int position) {
            if (position < 0 || position > this.text.length) {
                throw new IllegalArgumentException();
            }
            return this._setIndex(position);
        }

        @Override
        public int getBeginIndex() {
            return 0;
        }

        @Override
        public int getEndIndex() {
            return this.text.length;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object clone() {
            try {
                ACIText clone = (ACIText)super.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        @Override
        public int getRunStart() {
            return this.index >= this.committed ? this.committed : 0;
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            return this.index >= this.committed && attribute == TextAttribute.INPUT_METHOD_UNDERLINE ? this.committed : 0;
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            return this.index >= this.committed && attributes.contains(TextAttribute.INPUT_METHOD_UNDERLINE) ? this.committed : 0;
        }

        @Override
        public int getRunLimit() {
            return this.index < this.committed ? this.committed : this.text.length;
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            return this.index < this.committed && attribute == TextAttribute.INPUT_METHOD_UNDERLINE ? this.committed : this.text.length;
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            return this.index < this.committed && attributes.contains(TextAttribute.INPUT_METHOD_UNDERLINE) ? this.committed : this.text.length;
        }

        public Map getAttributes() {
            Hashtable<TextAttribute, Integer> result = new Hashtable<TextAttribute, Integer>();
            if (this.index >= this.committed && this.committed < this.text.length) {
                result.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            return result;
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            if (this.index >= this.committed && this.committed < this.text.length && attribute == TextAttribute.INPUT_METHOD_UNDERLINE) {
                return TextAttribute.UNDERLINE_LOW_ONE_PIXEL;
            }
            return null;
        }

        public Set getAllAttributeKeys() {
            HashSet<TextAttribute> result = new HashSet<TextAttribute>();
            if (this.committed < this.text.length) {
                result.add(TextAttribute.INPUT_METHOD_UNDERLINE);
            }
            return result;
        }

        private char _setIndex(int i) {
            this.index = i;
            if (i == this.text.length) {
                return '\uffff';
            }
            return this.text[i];
        }
    }
}

