/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Encoder;
import sun.nio.cs.ext.SJIS;

public class PCK
extends Charset
implements HistoricallyNamedCharset {
    public PCK() {
        super("x-PCK", ExtendedCharsets.aliasesFor("x-PCK"));
    }

    public String historicalName() {
        return "PCK";
    }

    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof JIS_X_0201 || cs instanceof PCK;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        byte[] replacementBytes = new byte[]{63};
        return new Encoder(this).replaceWith(replacementBytes);
    }

    private static class Encoder
    extends SJIS.Encoder {
        private JIS_X_0201.Encoder jis0201;
        private JIS_X_0208_Solaris_Encoder jis0208;
        short[] j0208Index1;
        String[] j0208Index2;

        private Encoder(Charset cs) {
            super(cs);
            this.jis0201 = new JIS_X_0201.Encoder(cs);
            this.jis0208 = new JIS_X_0208_Solaris_Encoder(cs);
            Encoder encoder = this;
            this.j0208Index1 = encoder.jis0208.getIndex1();
            Encoder encoder2 = this;
            this.j0208Index2 = encoder2.jis0208.getIndex2();
        }

        protected int encodeDouble(char ch) {
            int result = 0;
            switch (ch) {
                case '\u2015': {
                    return 33116;
                }
                case '\u2014': {
                    return 0;
                }
            }
            result = super.encodeDouble(ch);
            if (result != 0) {
                return result;
            }
            int offset = this.j0208Index1[ch >> 8] << 8;
            char pos = this.j0208Index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
            if (pos != '\u0000') {
                int rowOffset;
                int c1 = pos >> 8 & 0xFF;
                int c2 = pos & 0xFF;
                int n = rowOffset = c1 < 95 ? 112 : 176;
                int cellOffset = c1 % 2 == 1 ? (c2 > 95 ? 32 : 31) : 126;
                result = (c1 + 1 >> 1) + rowOffset << 8 | c2 + cellOffset;
            }
            return result;
        }
    }

    private static class Decoder
    extends SJIS.Decoder {
        JIS_X_0208_Solaris_Decoder jis0208;
        private static final char REPLACE_CHAR = '\ufffd';

        private Decoder(Charset cs) {
            super(cs);
            this.jis0208 = new JIS_X_0208_Solaris_Decoder(cs);
        }

        protected char decodeDouble(int c1, int c2) {
            int rowOffset;
            char outChar = super.decodeDouble(c1, c2);
            if (outChar != '\ufffd') {
                return outChar != '\u2014' ? outChar : (char)'\u2015';
            }
            int adjust = c2 < 159 ? 1 : 0;
            int n = rowOffset = c1 < 160 ? 112 : 176;
            int cellOffset = adjust == 1 ? (c2 > 127 ? 32 : 31) : 126;
            int b1 = (c1 - rowOffset << 1) - adjust;
            int b2 = c2 - cellOffset;
            char outChar2 = this.jis0208.decodeDouble(b1, b2);
            return outChar2;
        }
    }
}

