/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.Big5;
import sun.nio.cs.ext.ExtendedCharsets;

public class Big5_Solaris
extends Charset
implements HistoricallyNamedCharset {
    public Big5_Solaris() {
        super("x-Big5-Solaris", ExtendedCharsets.aliasesFor("x-Big5-Solaris"));
    }

    public String historicalName() {
        return "Big5_Solaris";
    }

    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof Big5 || cs instanceof Big5_Solaris;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends Big5.Encoder {
        protected int encodeDouble(char ch) {
            int r = super.encodeDouble(ch);
            if (r == 0) {
                switch (ch) {
                    case '\u7881': {
                        r = 63958;
                        break;
                    }
                    case '\u92b9': {
                        r = 63959;
                        break;
                    }
                    case '\u88cf': {
                        r = 63960;
                        break;
                    }
                    case '\u58bb': {
                        r = 63961;
                        break;
                    }
                    case '\u6052': {
                        r = 63962;
                        break;
                    }
                    case '\u7ca7': {
                        r = 63963;
                        break;
                    }
                    case '\u5afa': {
                        r = 63964;
                    }
                }
            }
            return r;
        }

        private Encoder(Charset cs) {
            super(cs);
        }
    }

    private static class Decoder
    extends Big5.Decoder {
        protected char decodeDouble(int byte1, int byte2) {
            int c = super.decodeDouble(byte1, byte2);
            if (c == 65533 && byte1 == 249) {
                switch (byte2) {
                    case 214: {
                        c = 30849;
                        break;
                    }
                    case 215: {
                        c = 37561;
                        break;
                    }
                    case 216: {
                        c = 35023;
                        break;
                    }
                    case 217: {
                        c = 22715;
                        break;
                    }
                    case 218: {
                        c = 24658;
                        break;
                    }
                    case 219: {
                        c = 31911;
                        break;
                    }
                    case 220: {
                        c = 23290;
                    }
                }
            }
            return (char)c;
        }

        private Decoder(Charset cs) {
            super(cs);
        }
    }
}

