/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.IBM949;

public class CharToByteCp949
extends CharToByteConverter {
    private static final char SBase = '\uac00';
    private static final char LBase = '\u1100';
    private static final char VBase = '\u1161';
    private static final char TBase = '\u11a7';
    private static final int VCount = 21;
    private static final int TCount = 28;
    private static final byte G0 = 0;
    private static final byte G1 = 1;
    private static final byte G2 = 2;
    private static final byte G3 = 3;
    private byte charState = 0;
    private char l;
    private char v;
    private char t;
    private byte[] outputByte = new byte[2];
    private char highHalfZoneCode = '\u0000';
    private int mask1 = 65528;
    private int mask2 = 7;
    private int shift = 3;
    private short[] index1 = nioCoder.getEncoderIndex1();
    private String index2 = nioCoder.getEncoderIndex2();
    private String index2a = nioCoder.getEncoderIndex2a();
    private static final IBM949 nioCoder = new IBM949();

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException, ConversionBufferFullException {
        this.byteOff = outStart;
        if (this.highHalfZoneCode != '\u0000') {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        if (this.charState != 0) {
            try {
                this.unicodeToBuffer(this.composeHangul(), output, outEnd);
            }
            catch (UnknownCharacterException e) {
                this.reset();
                this.badInputLength = 0;
                throw new MalformedInputException();
            }
            this.charState = 0;
        }
        int bytesOut = this.byteOff - outStart;
        this.reset();
        return bytesOut;
    }

    public void reset() {
        this.highHalfZoneCode = '\u0000';
        this.charState = 0;
        this.byteOff = 0;
        this.charOff = 0;
    }

    public boolean canConvert(char ch) {
        int index = this.index1[(ch & this.mask1) >> this.shift] + (ch & this.mask2);
        char theBytes = index < 15000 ? this.index2.charAt(index) : this.index2a.charAt(index - 15000);
        if (theBytes != '\u0000') {
            return true;
        }
        return ch == '\u0000';
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        this.charOff = inOff;
        this.byteOff = outOff;
        while (this.charOff < inEnd) {
            int inputSize;
            block27: {
                char inputChar;
                if (this.highHalfZoneCode == '\u0000') {
                    inputChar = input[this.charOff];
                    inputSize = 1;
                } else {
                    inputChar = this.highHalfZoneCode;
                    inputSize = 0;
                    this.highHalfZoneCode = '\u0000';
                }
                switch (this.charState) {
                    case 0: {
                        this.l = (char)4352;
                        this.v = (char)4449;
                        this.t = (char)4519;
                        if (this.isLeadingC(inputChar)) {
                            this.l = inputChar;
                            this.charState = 1;
                            break;
                        }
                        if (this.isVowel(inputChar)) {
                            this.v = inputChar;
                            this.charState = (byte)2;
                            break;
                        }
                        if (!this.isTrailingC(inputChar)) break;
                        this.t = inputChar;
                        this.charState = (byte)3;
                        break;
                    }
                    case 1: {
                        if (this.isLeadingC(inputChar)) {
                            this.l = this.composeLL(this.l, inputChar);
                            break;
                        }
                        if (this.isVowel(inputChar)) {
                            this.v = inputChar;
                            this.charState = (byte)2;
                            break;
                        }
                        if (this.isTrailingC(inputChar)) {
                            this.t = inputChar;
                            this.charState = (byte)3;
                            break;
                        }
                        this.unicodeToBuffer(this.composeHangul(), output, outEnd);
                        this.charState = 0;
                        break;
                    }
                    case 2: {
                        if (this.isLeadingC(inputChar)) {
                            this.unicodeToBuffer(this.composeHangul(), output, outEnd);
                            this.l = inputChar;
                            this.v = (char)4449;
                            this.t = (char)4519;
                            this.charState = 1;
                            break;
                        }
                        if (this.isVowel(inputChar)) {
                            this.v = this.composeVV(this.l, inputChar);
                            this.charState = (byte)2;
                            break;
                        }
                        if (this.isTrailingC(inputChar)) {
                            this.t = inputChar;
                            this.charState = (byte)3;
                            break;
                        }
                        this.unicodeToBuffer(this.composeHangul(), output, outEnd);
                        this.charState = 0;
                        break;
                    }
                    case 3: {
                        if (this.isTrailingC(inputChar)) {
                            this.t = this.composeTT(this.t, inputChar);
                            this.charState = (byte)3;
                            break;
                        }
                        this.unicodeToBuffer(this.composeHangul(), output, outEnd);
                        this.charState = 0;
                        break;
                    }
                }
                if (this.charState != 0) {
                    ++this.charOff;
                    continue;
                }
                if (inputChar >= '\ud800' && inputChar <= '\udbff') {
                    if (this.charOff + inputSize >= inEnd) {
                        this.highHalfZoneCode = inputChar;
                        this.charOff += inputSize;
                        return this.byteOff - outOff;
                    }
                    inputChar = input[this.charOff + inputSize];
                    if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                        if (!this.subMode) {
                            this.badInputLength = 2;
                            throw new UnknownCharacterException();
                        }
                        if (this.subBytes.length == 1) {
                            this.outputByte[0] = 0;
                            this.outputByte[1] = this.subBytes[0];
                        } else {
                            this.outputByte[0] = this.subBytes[0];
                            this.outputByte[1] = this.subBytes[1];
                        }
                        this.bytesToBuffer(this.outputByte, output, outEnd);
                        ++inputSize;
                        break block27;
                    } else {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                }
                if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                this.unicodeToBuffer(inputChar, output, outEnd);
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }

    private char composeHangul() {
        int lIndex = this.l - 4352;
        int vIndex = this.v - 4449;
        int tIndex = this.t - 4519;
        return (char)((lIndex * 21 + vIndex) * 28 + tIndex + 44032);
    }

    private char composeLL(char l1, char l2) {
        return l2;
    }

    private char composeVV(char v1, char v2) {
        return v2;
    }

    private char composeTT(char t1, char t2) {
        return t2;
    }

    private boolean isLeadingC(char c) {
        return c >= '\u1100' && c <= '\u1159';
    }

    private boolean isVowel(char c) {
        return c >= '\u1161' && c <= '\u11a2';
    }

    private boolean isTrailingC(char c) {
        return c >= '\u11a7' && c <= '\u11f9';
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public String getCharacterEncoding() {
        return "Cp949";
    }

    private void bytesToBuffer(byte[] theBytes, byte[] output, int outEnd) throws ConversionBufferFullException, UnknownCharacterException {
        int spaceNeeded = theBytes[0] == 0 ? 1 : 2;
        if (this.byteOff + spaceNeeded > outEnd) {
            throw new ConversionBufferFullException();
        }
        if (spaceNeeded == 1) {
            output[this.byteOff++] = theBytes[1];
        } else {
            output[this.byteOff++] = theBytes[0];
            output[this.byteOff++] = theBytes[1];
        }
    }

    private void unicodeToBuffer(char unicode, byte[] output, int outEnd) throws ConversionBufferFullException, UnknownCharacterException {
        int index = this.index1[(unicode & this.mask1) >> this.shift] + (unicode & this.mask2);
        char theBytes = index < 15000 ? this.index2.charAt(index) : this.index2a.charAt(index - 15000);
        this.outputByte[0] = (byte)((theBytes & 0xFF00) >> 8);
        this.outputByte[1] = (byte)(theBytes & 0xFF);
        if (this.outputByte[0] == 0 && this.outputByte[1] == 0 && unicode != '\u0000') {
            if (this.subMode) {
                if (this.subBytes.length == 1) {
                    this.outputByte[0] = 0;
                    this.outputByte[1] = this.subBytes[0];
                } else {
                    this.outputByte[0] = this.subBytes[0];
                    this.outputByte[1] = this.subBytes[1];
                }
            } else {
                this.badInputLength = 1;
                throw new UnknownCharacterException();
            }
        }
        this.bytesToBuffer(this.outputByte, output, outEnd);
    }
}

