/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;

public class DeadlockDetector {
    private static Threads threads;
    private static ObjectHeap heap;
    private static HashMap threadTable;

    public static void print(PrintStream tty) {
        DeadlockDetector.print(tty, true);
    }

    public static void print(PrintStream tty, boolean concurrentLocks) {
        tty.println("Deadlock Detection:");
        tty.println();
        int globalDfn = 0;
        int numberOfDeadlocks = 0;
        JavaThread currentThread = null;
        JavaThread previousThread = null;
        ObjectMonitor waitingToLockMonitor = null;
        Oop waitingToLockBlocker = null;
        threads = VM.getVM().getThreads();
        heap = VM.getVM().getObjectHeap();
        DeadlockDetector.createThreadTable();
        Iterator i = threadTable.entrySet().iterator();
        block6: while (i.hasNext()) {
            JavaThread thread;
            Map.Entry e = i.next();
            if (DeadlockDetector.dfn(e) >= 0) continue;
            int thisDfn = globalDfn;
            previousThread = thread = (JavaThread)e.getKey();
            try {
                waitingToLockMonitor = thread.getCurrentPendingMonitor();
            }
            catch (RuntimeException re) {
                tty.println("This version of HotSpot VM doesn't support deadlock detection.");
                return;
            }
            InstanceKlass abstractOwnableSyncKlass = null;
            if (concurrentLocks) {
                waitingToLockBlocker = thread.getCurrentParkBlocker();
                SystemDictionary sysDict = VM.getVM().getSystemDictionary();
                abstractOwnableSyncKlass = sysDict.getAbstractOwnableSynchronizerKlass();
            }
            while (waitingToLockMonitor != null || waitingToLockBlocker != null) {
                Oop threadOop;
                if (waitingToLockMonitor != null) {
                    currentThread = threads.owningThreadFromMonitor(waitingToLockMonitor);
                } else if (concurrentLocks && waitingToLockBlocker.isA(abstractOwnableSyncKlass) && (threadOop = OopUtilities.abstractOwnableSynchronizerGetOwnerThread(waitingToLockBlocker)) != null) {
                    currentThread = OopUtilities.threadOopGetJavaThread(threadOop);
                }
                if (currentThread == null) continue block6;
                if (DeadlockDetector.dfn(currentThread) >= 0) {
                    if (DeadlockDetector.dfn(currentThread) < thisDfn || currentThread == previousThread) continue block6;
                    ++numberOfDeadlocks;
                    DeadlockDetector.printOneDeadlock(tty, currentThread, concurrentLocks);
                    continue block6;
                }
                threadTable.put(currentThread, new Integer(globalDfn++));
                previousThread = currentThread;
                waitingToLockMonitor = currentThread.getCurrentPendingMonitor();
                if (!concurrentLocks) continue;
                waitingToLockBlocker = currentThread.getCurrentParkBlocker();
            }
        }
        switch (numberOfDeadlocks) {
            case 0: {
                tty.println("No deadlocks found.");
                break;
            }
            case 1: {
                tty.println("Found a total of 1 deadlock.");
                break;
            }
            default: {
                tty.println("Found a total of " + numberOfDeadlocks + " deadlocks.");
            }
        }
        tty.println();
    }

    private static void createThreadTable() {
        threadTable = new HashMap();
        for (JavaThread cur = threads.first(); cur != null; cur = cur.next()) {
            threadTable.put(cur, new Integer(-1));
        }
    }

    private static int dfn(JavaThread thread) {
        Object obj = threadTable.get(thread);
        if (obj != null) {
            return (Integer)obj;
        }
        return -1;
    }

    private static int dfn(Map.Entry e) {
        return (Integer)e.getValue();
    }

    private static void printOneDeadlock(PrintStream tty, JavaThread thread, boolean concurrentLocks) {
        tty.println("Found one Java-level deadlock:");
        tty.println("=============================");
        ObjectMonitor waitingToLockMonitor = null;
        Oop waitingToLockBlocker = null;
        JavaThread currentThread = thread;
        do {
            tty.println();
            tty.println("\"" + currentThread.getThreadName() + "\":");
            waitingToLockMonitor = currentThread.getCurrentPendingMonitor();
            if (waitingToLockMonitor != null) {
                tty.print("  waiting to lock Monitor@" + waitingToLockMonitor.getAddress());
                OopHandle obj = waitingToLockMonitor.object();
                Oop oop = heap.newOop(obj);
                if (obj != null) {
                    tty.print(" (Object@");
                    Oop.printOopAddressOn(oop, tty);
                    tty.print(", a " + oop.getKlass().getName().asString() + ")");
                    tty.print(",\n  which is held by");
                } else {
                    tty.print(" (raw monitor),\n  which is held by");
                }
                currentThread = threads.owningThreadFromMonitor(waitingToLockMonitor);
                tty.print(" \"" + currentThread.getThreadName() + "\"");
                continue;
            }
            if (!concurrentLocks) continue;
            waitingToLockBlocker = currentThread.getCurrentParkBlocker();
            tty.print(" waiting for ownable synchronizer ");
            Oop.printOopAddressOn(waitingToLockBlocker, tty);
            tty.print(", (a " + waitingToLockBlocker.getKlass().getName().asString() + ")");
            Oop threadOop = OopUtilities.abstractOwnableSynchronizerGetOwnerThread(waitingToLockBlocker);
            currentThread = OopUtilities.threadOopGetJavaThread(threadOop);
            tty.print(",\n which is held by");
            tty.print(" \"" + currentThread.getThreadName() + "\"");
        } while (!currentThread.equals(thread));
        tty.println();
        tty.println();
    }
}

