/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.ParallelScavengeHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.memory.GenCollectedHeap;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VirtualConstructor;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Universe {
    private static AddressField collectedHeapField;
    private static VirtualConstructor heapConstructor;
    private static OopField mainThreadGroupField;
    private static OopField systemThreadGroupField;
    private static OopField boolArrayKlassObjField;
    private static OopField byteArrayKlassObjField;
    private static OopField charArrayKlassObjField;
    private static OopField intArrayKlassObjField;
    private static OopField shortArrayKlassObjField;
    private static OopField longArrayKlassObjField;
    private static OopField singleArrayKlassObjField;
    private static OopField doubleArrayKlassObjField;
    private static OopField systemObjArrayKlassObjField;
    private static AddressField heapBaseField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Universe");
        collectedHeapField = type.getAddressField("_collectedHeap");
        heapConstructor = new VirtualConstructor(db);
        heapConstructor.addMapping("GenCollectedHeap", GenCollectedHeap.class);
        heapConstructor.addMapping("ParallelScavengeHeap", ParallelScavengeHeap.class);
        mainThreadGroupField = type.getOopField("_main_thread_group");
        systemThreadGroupField = type.getOopField("_system_thread_group");
        boolArrayKlassObjField = type.getOopField("_boolArrayKlassObj");
        byteArrayKlassObjField = type.getOopField("_byteArrayKlassObj");
        charArrayKlassObjField = type.getOopField("_charArrayKlassObj");
        intArrayKlassObjField = type.getOopField("_intArrayKlassObj");
        shortArrayKlassObjField = type.getOopField("_shortArrayKlassObj");
        longArrayKlassObjField = type.getOopField("_longArrayKlassObj");
        singleArrayKlassObjField = type.getOopField("_singleArrayKlassObj");
        doubleArrayKlassObjField = type.getOopField("_doubleArrayKlassObj");
        systemObjArrayKlassObjField = type.getOopField("_systemObjArrayKlassObj");
        heapBaseField = type.getAddressField("_heap_base");
    }

    public CollectedHeap heap() {
        try {
            return (CollectedHeap)heapConstructor.instantiateWrapperFor(collectedHeapField.getValue());
        }
        catch (WrongTypeException e) {
            return new CollectedHeap(collectedHeapField.getValue());
        }
    }

    public static long getHeapBase() {
        if (heapBaseField.getValue() == null) {
            return 0L;
        }
        return heapBaseField.getValue().minus(null);
    }

    public boolean isIn(Address p) {
        return this.heap().isIn(p);
    }

    public boolean isInReserved(Address p) {
        return this.heap().isInReserved(p);
    }

    private Oop newOop(OopHandle handle) {
        return VM.getVM().getObjectHeap().newOop(handle);
    }

    public Oop mainThreadGroup() {
        return this.newOop(mainThreadGroupField.getValue());
    }

    public Oop systemThreadGroup() {
        return this.newOop(systemThreadGroupField.getValue());
    }

    public Oop systemObjArrayKlassObj() {
        return this.newOop(systemObjArrayKlassObjField.getValue());
    }

    public void basicTypeClassesDo(SystemDictionary.ClassVisitor visitor) {
        visitor.visit((Klass)this.newOop(boolArrayKlassObjField.getValue()));
        visitor.visit((Klass)this.newOop(byteArrayKlassObjField.getValue()));
        visitor.visit((Klass)this.newOop(charArrayKlassObjField.getValue()));
        visitor.visit((Klass)this.newOop(intArrayKlassObjField.getValue()));
        visitor.visit((Klass)this.newOop(shortArrayKlassObjField.getValue()));
        visitor.visit((Klass)this.newOop(longArrayKlassObjField.getValue()));
        visitor.visit((Klass)this.newOop(singleArrayKlassObjField.getValue()));
        visitor.visit((Klass)this.newOop(doubleArrayKlassObjField.getValue()));
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        this.heap().printOn(tty);
    }

    public static boolean elementTypeShouldBeAligned(BasicType type) {
        return type == BasicType.T_DOUBLE || type == BasicType.T_LONG;
    }

    public static boolean fieldTypeShouldBeAligned(BasicType type) {
        return type == BasicType.T_DOUBLE || type == BasicType.T_LONG;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Universe.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

