/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;

public class LocalGregorianCalendar
extends BaseCalendar {
    private String name;
    private Era[] eras;

    static LocalGregorianCalendar getLocalGregorianCalendar(String name) {
        Properties calendarProps = null;
        try {
            String homeDir = AccessController.doPrivileged(new GetPropertyAction("java.home"));
            final String fname = homeDir + File.separator + "lib" + File.separator + "calendars.properties";
            calendarProps = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Properties props = new Properties();
                    props.load(new FileInputStream(fname));
                    return props;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getException());
        }
        String props = calendarProps.getProperty("calendar." + name + ".eras");
        if (props == null) {
            return null;
        }
        ArrayList<Era> eras = new ArrayList<Era>();
        StringTokenizer eraTokens = new StringTokenizer(props, ";");
        while (eraTokens.hasMoreTokens()) {
            String items = eraTokens.nextToken().trim();
            StringTokenizer itemTokens = new StringTokenizer(items, ",");
            String eraName = null;
            boolean localTime = true;
            long since = 0L;
            String abbr = null;
            while (itemTokens.hasMoreTokens()) {
                String item = itemTokens.nextToken();
                int index = item.indexOf(61);
                if (index == -1) {
                    return null;
                }
                String key = item.substring(0, index);
                String value = item.substring(index + 1);
                if ("name".equals(key)) {
                    eraName = value;
                    continue;
                }
                if ("since".equals(key)) {
                    if (value.endsWith("u")) {
                        localTime = false;
                        since = Long.parseLong(value.substring(0, value.length() - 1));
                        continue;
                    }
                    since = Long.parseLong(value);
                    continue;
                }
                if ("abbr".equals(key)) {
                    abbr = value;
                    continue;
                }
                throw new RuntimeException("Unknown key word: " + key);
            }
            Era era = new Era(eraName, abbr, since, localTime);
            eras.add(era);
        }
        Era[] eraArray = new Era[eras.size()];
        eras.toArray(eraArray);
        return new LocalGregorianCalendar(name, eraArray);
    }

    private LocalGregorianCalendar(String name, Era[] eras) {
        this.name = name;
        this.eras = eras;
        this.setEras(eras);
    }

    public String getName() {
        return this.name;
    }

    public Date getCalendarDate() {
        return this.getCalendarDate(System.currentTimeMillis(), this.newCalendarDate());
    }

    public Date getCalendarDate(long millis) {
        return this.getCalendarDate(millis, this.newCalendarDate());
    }

    public Date getCalendarDate(long millis, TimeZone zone) {
        return this.getCalendarDate(millis, this.newCalendarDate(zone));
    }

    public Date getCalendarDate(long millis, CalendarDate date) {
        Date ldate = (Date)super.getCalendarDate(millis, date);
        return this.adjustYear(ldate, millis, ldate.getZoneOffset());
    }

    private Date adjustYear(Date ldate, long millis, int zoneOffset) {
        int i;
        for (i = this.eras.length - 1; i >= 0; --i) {
            Era era = this.eras[i];
            long since = era.getSince(null);
            if (era.isLocalTime()) {
                since -= (long)zoneOffset;
            }
            if (millis < since) continue;
            ldate.setLocalEra(era);
            int y = ldate.getNormalizedYear() - era.getSinceDate().getYear() + 1;
            ldate.setLocalYear(y);
            break;
        }
        if (i < 0) {
            ldate.setLocalEra(null);
            ldate.setLocalYear(ldate.getNormalizedYear());
        }
        ldate.setNormalized(true);
        return ldate;
    }

    public Date newCalendarDate() {
        return new Date();
    }

    public Date newCalendarDate(TimeZone zone) {
        return new Date(zone);
    }

    public boolean validate(CalendarDate date) {
        Date ldate = (Date)date;
        Era era = ldate.getEra();
        if (era != null) {
            if (!this.validateEra(era)) {
                return false;
            }
            ldate.setNormalizedYear(era.getSinceDate().getYear() + ldate.getYear());
        } else {
            ldate.setNormalizedYear(ldate.getYear());
        }
        return super.validate(ldate);
    }

    private boolean validateEra(Era era) {
        for (int i = 0; i < this.eras.length; ++i) {
            if (era != this.eras[i]) continue;
            return true;
        }
        return false;
    }

    public boolean normalize(CalendarDate date) {
        int i;
        if (date.isNormalized()) {
            return true;
        }
        this.normalizeYear(date);
        Date ldate = (Date)date;
        super.normalize(ldate);
        boolean hasMillis = false;
        long millis = 0L;
        int year = ldate.getNormalizedYear();
        Era era = null;
        for (i = this.eras.length - 1; i >= 0; --i) {
            long since;
            era = this.eras[i];
            if (era.isLocalTime()) {
                long sinceTimeOfDay;
                int sinceDay;
                int sinceMonth;
                CalendarDate sinceDate = era.getSinceDate();
                int sinceYear = sinceDate.getYear();
                if (year > sinceYear) break;
                if (year != sinceYear) continue;
                int month = ldate.getMonth();
                if (month > (sinceMonth = sinceDate.getMonth())) break;
                if (month != sinceMonth) continue;
                int day = ldate.getDayOfMonth();
                if (day > (sinceDay = sinceDate.getDayOfMonth())) break;
                if (day != sinceDay) continue;
                long timeOfDay = ldate.getTimeOfDay();
                if (timeOfDay >= (sinceTimeOfDay = sinceDate.getTimeOfDay())) break;
                --i;
                break;
            }
            if (!hasMillis) {
                millis = super.getTime(date);
                hasMillis = true;
            }
            if (millis >= (since = era.getSince(date.getZone()))) break;
        }
        if (i >= 0) {
            ldate.setLocalEra(era);
            int y = ldate.getNormalizedYear() - era.getSinceDate().getYear() + 1;
            ldate.setLocalYear(y);
        } else {
            ldate.setEra(null);
            ldate.setLocalYear(year);
            ldate.setNormalizedYear(year);
        }
        ldate.setNormalized(true);
        return true;
    }

    void normalizeMonth(CalendarDate date) {
        this.normalizeYear(date);
        super.normalizeMonth(date);
    }

    void normalizeYear(CalendarDate date) {
        Date ldate = (Date)date;
        Era era = ldate.getEra();
        if (era == null || !this.validateEra(era)) {
            ldate.setNormalizedYear(ldate.getYear());
        } else {
            ldate.setNormalizedYear(era.getSinceDate().getYear() + ldate.getYear() - 1);
        }
    }

    public boolean isLeapYear(int gregorianYear) {
        return CalendarUtils.isGregorianLeapYear(gregorianYear);
    }

    public boolean isLeapYear(Era era, int year) {
        if (era == null) {
            return this.isLeapYear(year);
        }
        int gyear = era.getSinceDate().getYear() + year - 1;
        return this.isLeapYear(gyear);
    }

    public void getCalendarDateFromFixedDate(CalendarDate date, long fixedDate) {
        Date ldate = (Date)date;
        super.getCalendarDateFromFixedDate(ldate, fixedDate);
        this.adjustYear(ldate, (fixedDate - 719163L) * 86400000L, 0);
    }

    public static class Date
    extends BaseCalendar.Date {
        private int gregorianYear = Integer.MIN_VALUE;

        protected Date() {
        }

        protected Date(TimeZone zone) {
            super(zone);
        }

        public Date setEra(Era era) {
            if (this.getEra() != era) {
                super.setEra(era);
                this.gregorianYear = Integer.MIN_VALUE;
            }
            return this;
        }

        public Date addYear(int localYear) {
            super.addYear(localYear);
            this.gregorianYear += localYear;
            return this;
        }

        public Date setYear(int localYear) {
            if (this.getYear() != localYear) {
                super.setYear(localYear);
                this.gregorianYear = Integer.MIN_VALUE;
            }
            return this;
        }

        public int getNormalizedYear() {
            return this.gregorianYear;
        }

        public void setNormalizedYear(int normalizedYear) {
            this.gregorianYear = normalizedYear;
        }

        void setLocalEra(Era era) {
            super.setEra(era);
        }

        void setLocalYear(int year) {
            super.setYear(year);
        }

        public String toString() {
            String abbr;
            String time = super.toString();
            time = time.substring(time.indexOf(84));
            StringBuffer sb = new StringBuffer();
            Era era = this.getEra();
            if (era != null && (abbr = era.getAbbreviation()) != null) {
                sb.append(abbr);
            }
            sb.append(this.getYear()).append('.');
            CalendarUtils.sprintf0d(sb, this.getMonth(), 2).append('.');
            CalendarUtils.sprintf0d(sb, this.getDayOfMonth(), 2);
            sb.append(time);
            return sb.toString();
        }
    }
}

