/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.misc.BASE64Encoder;
import sun.net.www.MessageHeader;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.tools.jar.JarException;
import sun.tools.jar.Manifest;

public class SignatureFile {
    static final boolean debug = false;
    private Vector entries = new Vector();
    static final String[] hashes = new String[]{"SHA"};
    private Manifest manifest;
    private String rawName;
    private PKCS7 signatureBlock;
    private Hashtable digests = new Hashtable();

    static final void debug(String s) {
    }

    private SignatureFile(String name) throws JarException {
        this.entries = new Vector();
        if (name != null) {
            if (name.length() > 8 || name.indexOf(46) != -1) {
                throw new JarException("invalid file name");
            }
            this.rawName = name.toUpperCase();
        }
    }

    private SignatureFile(String name, boolean newFile) throws JarException {
        this(name);
        if (newFile) {
            MessageHeader globals = new MessageHeader();
            globals.set("Signature-Version", "1.0");
            this.entries.addElement(globals);
        }
    }

    public SignatureFile(Manifest manifest, String name) throws JarException {
        this(name, true);
        this.manifest = manifest;
        Enumeration enum_ = manifest.entries();
        while (enum_.hasMoreElements()) {
            MessageHeader mh = (MessageHeader)enum_.nextElement();
            String entryName = mh.findValue("Name");
            if (entryName == null) continue;
            this.add(entryName);
        }
    }

    public SignatureFile(Manifest manifest, String[] entries, String filename) throws JarException {
        this(filename, true);
        this.manifest = manifest;
        this.add(entries);
    }

    public SignatureFile(InputStream is, String filename) throws IOException {
        this(filename);
        while (is.available() > 0) {
            MessageHeader m = new MessageHeader(is);
            this.entries.addElement(m);
        }
    }

    public SignatureFile(InputStream is) throws IOException {
        this(is, null);
    }

    public SignatureFile(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes));
    }

    public String getName() {
        return "META-INF/" + this.rawName + ".SF";
    }

    public String getBlockName() {
        String suffix = "DSA";
        if (this.signatureBlock != null) {
            SignerInfo info = this.signatureBlock.getSignerInfos()[0];
            suffix = info.getDigestEncryptionAlgorithmId().getName();
            suffix = suffix.substring(suffix.length() - 3);
        }
        return "META-INF/" + this.rawName + "." + suffix;
    }

    public PKCS7 getBlock() {
        return this.signatureBlock;
    }

    public void setBlock(PKCS7 block) {
        this.signatureBlock = block;
    }

    public void add(String[] entries) throws JarException {
        for (int i = 0; i < entries.length; ++i) {
            this.add(entries[i]);
        }
    }

    public void add(String entry) throws JarException {
        MessageHeader smh;
        MessageHeader mh = this.manifest.getEntry(entry);
        if (mh == null) {
            throw new JarException("entry " + entry + " not in manifest");
        }
        try {
            smh = this.computeEntry(mh);
        }
        catch (IOException e) {
            throw new JarException(e.getMessage());
        }
        this.entries.addElement(smh);
    }

    public MessageHeader getEntry(String name) {
        Enumeration enum_ = this.entries();
        while (enum_.hasMoreElements()) {
            MessageHeader mh = (MessageHeader)enum_.nextElement();
            if (!name.equals(mh.findValue("Name"))) continue;
            return mh;
        }
        return null;
    }

    public MessageHeader entryAt(int n) {
        return (MessageHeader)this.entries.elementAt(n);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    private MessageHeader computeEntry(MessageHeader mh) throws IOException {
        MessageHeader smh = new MessageHeader();
        String name = mh.findValue("Name");
        if (name == null) {
            return null;
        }
        smh.set("Name", name);
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            for (int i = 0; i < hashes.length; ++i) {
                MessageDigest dig = this.getDigest(hashes[i]);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                mh.print(ps);
                byte[] headerBytes = baos.toByteArray();
                byte[] digest = dig.digest(headerBytes);
                smh.set(hashes[i] + "-Digest", encoder.encode(digest));
            }
            return smh;
        }
        catch (NoSuchAlgorithmException e) {
            throw new JarException(e.getMessage());
        }
    }

    private MessageDigest getDigest(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest dig = (MessageDigest)this.digests.get(algorithm);
        if (dig == null) {
            dig = MessageDigest.getInstance(algorithm);
            this.digests.put(algorithm, dig);
        }
        dig.reset();
        return dig;
    }

    public void stream(OutputStream os) throws IOException {
        MessageHeader globals = (MessageHeader)this.entries.elementAt(0);
        if (globals.findValue("Signature-Version") == null) {
            throw new JarException("Signature file requires Signature-Version: 1.0 in 1st header");
        }
        PrintStream ps = new PrintStream(os);
        globals.print(ps);
        for (int i = 1; i < this.entries.size(); ++i) {
            MessageHeader mh = (MessageHeader)this.entries.elementAt(i);
            mh.print(ps);
        }
    }
}

