/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import sun.text.normalizer.UCharacter;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;

public final class Utility {
    private static final char[] UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'e', '\u001b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static final String escape(String s) {
        int c;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(c)) {
            c = UTF16.charAt(s, i);
            if (c >= 32 && c <= 127) {
                if (c == 92) {
                    buf.append("\\\\");
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            boolean four = c <= 65535;
            buf.append(four ? "\\u" : "\\U");
            Utility.hex(c, four ? 4 : 8, buf);
        }
        return buf.toString();
    }

    public static int unescapeAt(String s, int[] offset16) {
        int dig;
        int result = 0;
        int n = 0;
        int minDig = 0;
        int maxDig = 0;
        int bitsPerDigit = 4;
        boolean braces = false;
        int offset = offset16[0];
        int length = s.length();
        if (offset < 0 || offset >= length) {
            return -1;
        }
        int c = UTF16.charAt(s, offset);
        offset += UTF16.getCharCount(c);
        switch (c) {
            case 117: {
                maxDig = 4;
                minDig = 4;
                break;
            }
            case 85: {
                maxDig = 8;
                minDig = 8;
                break;
            }
            case 120: {
                minDig = 1;
                if (offset < length && UTF16.charAt(s, offset) == 123) {
                    ++offset;
                    braces = true;
                    maxDig = 8;
                    break;
                }
                maxDig = 2;
                break;
            }
            default: {
                dig = UCharacter.digit(c, 8);
                if (dig < 0) break;
                minDig = 1;
                maxDig = 3;
                n = 1;
                bitsPerDigit = 3;
                result = dig;
            }
        }
        if (minDig != 0) {
            while (offset < length && n < maxDig && (dig = UCharacter.digit(c = UTF16.charAt(s, offset), bitsPerDigit == 3 ? 8 : 16)) >= 0) {
                result = result << bitsPerDigit | dig;
                offset += UTF16.getCharCount(c);
                ++n;
            }
            if (n < minDig) {
                return -1;
            }
            if (braces) {
                if (c != 125) {
                    return -1;
                }
                ++offset;
            }
            if (result < 0 || result >= 0x110000) {
                return -1;
            }
            if (offset < length && UTF16.isLeadSurrogate((char)result)) {
                int ahead = offset + 1;
                c = s.charAt(offset);
                if (c == 92 && ahead < length) {
                    int[] o = new int[]{ahead};
                    c = Utility.unescapeAt(s, o);
                    ahead = o[0];
                }
                if (UTF16.isTrailSurrogate((char)c)) {
                    offset = ahead;
                    result = UCharacterProperty.getRawSupplementary((char)result, (char)c);
                }
            }
            offset16[0] = offset;
            return result;
        }
        for (int i = 0; i < UNESCAPE_MAP.length; i += 2) {
            if (c == UNESCAPE_MAP[i]) {
                offset16[0] = offset;
                return UNESCAPE_MAP[i + 1];
            }
            if (c < UNESCAPE_MAP[i]) break;
        }
        if (c == 99 && offset < length) {
            c = UTF16.charAt(s, offset);
            offset16[0] = offset + UTF16.getCharCount(c);
            return 0x1F & c;
        }
        offset16[0] = offset;
        return c;
    }

    public static StringBuffer hex(int ch, int width, StringBuffer output) {
        return Utility.appendNumber(output, ch, 16, width);
    }

    public static String hex(int ch, int width) {
        StringBuffer buf = new StringBuffer();
        return Utility.appendNumber(buf, ch, 16, width).toString();
    }

    public static int skipWhitespace(String str, int pos) {
        int c;
        while (pos < str.length() && UCharacterProperty.isRuleWhiteSpace(c = UTF16.charAt(str, pos))) {
            pos += UTF16.getCharCount(c);
        }
        return pos;
    }

    private static void recursiveAppendNumber(StringBuffer result, int n, int radix, int minDigits) {
        int digit = n % radix;
        if (n >= radix || minDigits > 1) {
            Utility.recursiveAppendNumber(result, n / radix, radix, minDigits - 1);
        }
        result.append(DIGITS[digit]);
    }

    public static StringBuffer appendNumber(StringBuffer result, int n, int radix, int minDigits) throws IllegalArgumentException {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Illegal radix " + radix);
        }
        int abs = n;
        if (n < 0) {
            abs = -n;
            result.append("-");
        }
        Utility.recursiveAppendNumber(result, abs, radix, minDigits);
        return result;
    }

    public static boolean isUnprintable(int c) {
        return c < 32 || c > 126;
    }

    public static boolean escapeUnprintable(StringBuffer result, int c) {
        if (Utility.isUnprintable(c)) {
            result.append('\\');
            if ((c & 0xFFFF0000) != 0) {
                result.append('U');
                result.append(DIGITS[0xF & c >> 28]);
                result.append(DIGITS[0xF & c >> 24]);
                result.append(DIGITS[0xF & c >> 20]);
                result.append(DIGITS[0xF & c >> 16]);
            } else {
                result.append('u');
            }
            result.append(DIGITS[0xF & c >> 12]);
            result.append(DIGITS[0xF & c >> 8]);
            result.append(DIGITS[0xF & c >> 4]);
            result.append(DIGITS[0xF & c]);
            return true;
        }
        return false;
    }

    public static void getChars(StringBuffer src, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin == srcEnd) {
            return;
        }
        src.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public static final boolean arrayRegionMatches(char[] source, int sourceStart, char[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        for (int i = sourceStart; i < sourceEnd; ++i) {
            if (source[i] == target[i + delta]) continue;
            return false;
        }
        return true;
    }
}

