/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.UniqueIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateIssuerUniqueIdentity
implements CertAttrSet<String> {
    private UniqueIdentity id;
    public static final String IDENT = "x509.info.issuerID";
    public static final String NAME = "issuerID";
    public static final String ID = "id";

    public CertificateIssuerUniqueIdentity(UniqueIdentity id) {
        this.id = id;
    }

    public CertificateIssuerUniqueIdentity(DerInputStream in) throws IOException {
        this.id = new UniqueIdentity(in);
    }

    public CertificateIssuerUniqueIdentity(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.id = new UniqueIdentity(val);
    }

    public CertificateIssuerUniqueIdentity(DerValue val) throws IOException {
        this.id = new UniqueIdentity(val);
    }

    @Override
    public String toString() {
        if (this.id == null) {
            return "";
        }
        return this.id.toString();
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.id.encode(tmp, DerValue.createTag((byte)-128, false, (byte)1));
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof UniqueIdentity)) {
            throw new IOException("Attribute must be of type UniqueIdentity.");
        }
        if (!name.equalsIgnoreCase(ID)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
        }
        this.id = (UniqueIdentity)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(ID)) {
            return this.id;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(ID)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
        }
        this.id = null;
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(ID);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

