/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import sun.security.provider.certpath.CertId;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.x509.SerialNumber;
import sun.security.x509.X509CertImpl;

class OCSPRequest {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private SerialNumber serialNumber;
    private X509CertImpl issuerCert;
    private CertId certId = null;

    OCSPRequest(X509CertImpl userCert, X509CertImpl issuerCert) throws CertPathValidatorException {
        if (issuerCert == null) {
            throw new CertPathValidatorException("Null IssuerCertificate");
        }
        this.issuerCert = issuerCert;
        this.serialNumber = userCert.getSerialNumberObject();
    }

    byte[] encodeBytes() throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream derSingleReqList = new DerOutputStream();
        SingleRequest singleRequest = null;
        try {
            singleRequest = new SingleRequest(this.issuerCert, this.serialNumber);
        }
        catch (Exception e) {
            throw new IOException("Error encoding OCSP request");
        }
        this.certId = singleRequest.getCertId();
        singleRequest.encode(derSingleReqList);
        tmp.write((byte)48, derSingleReqList);
        DerOutputStream tbsRequest = new DerOutputStream();
        tbsRequest.write((byte)48, tmp);
        DerOutputStream ocspRequest = new DerOutputStream();
        ocspRequest.write((byte)48, tbsRequest);
        byte[] bytes = ocspRequest.toByteArray();
        return bytes;
    }

    CertId getCertId() {
        return this.certId;
    }

    private static class SingleRequest {
        private CertId certId;

        private SingleRequest(X509CertImpl cert, SerialNumber serialNo) throws Exception {
            this.certId = new CertId(cert, serialNo);
        }

        private void encode(DerOutputStream out) throws IOException {
            DerOutputStream tmp = new DerOutputStream();
            this.certId.encode(tmp);
            out.write((byte)48, tmp);
        }

        private CertId getCertId() {
            return this.certId;
        }
    }
}

