/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.misc.IOUtils;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.CertificateRevokedException;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.SerialNumber;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCSPChecker
extends PKIXCertPathChecker {
    public static final String OCSP_ENABLE_PROP = "ocsp.enable";
    public static final String OCSP_URL_PROP = "ocsp.responderURL";
    public static final String OCSP_CERT_SUBJECT_PROP = "ocsp.responderCertSubjectName";
    public static final String OCSP_CERT_ISSUER_PROP = "ocsp.responderCertIssuerName";
    public static final String OCSP_CERT_NUMBER_PROP = "ocsp.responderCertSerialNumber";
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private static final int[] OCSP_NONCE_DATA = new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2};
    private static final ObjectIdentifier OCSP_NONCE_OID = ObjectIdentifier.newInternal(OCSP_NONCE_DATA);
    private int remainingCerts;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;

    OCSPChecker(CertPath certPath, PKIXParameters pkixParams) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pkixParams;
        List<? extends Certificate> tmp = this.cp.getCertificates();
        this.certs = tmp.toArray(new X509Certificate[tmp.size()]);
        this.init(false);
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certs.length;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int contentLength;
            byte[] response;
            OCSPResponse ocspResponse;
            X509Certificate responderCert = null;
            boolean seekResponderCert = false;
            X500Principal responderSubjectName = null;
            X500Principal responderIssuerName = null;
            BigInteger responderSerialNumber = null;
            String[] properties = OCSPChecker.getOCSPProperties();
            if (properties[1] != null) {
                responderSubjectName = new X500Principal(properties[1]);
            } else if (properties[2] != null && properties[3] != null) {
                responderIssuerName = new X500Principal(properties[2]);
                String value = OCSPChecker.stripOutSeparators(properties[3]);
                responderSerialNumber = new BigInteger(value, 16);
            } else if (properties[2] != null || properties[3] != null) {
                throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
            }
            if (responderSubjectName != null || responderIssuerName != null) {
                seekResponderCert = true;
            }
            boolean seekIssuerCert = true;
            X509CertImpl issuerCertImpl = null;
            X509CertImpl currCertImpl = X509CertImpl.toImpl((X509Certificate)cert);
            --this.remainingCerts;
            if (this.remainingCerts != 0) {
                issuerCertImpl = X509CertImpl.toImpl(this.certs[this.remainingCerts]);
                seekIssuerCert = false;
                if (!seekResponderCert) {
                    responderCert = this.certs[this.remainingCerts];
                    if (DEBUG != null) {
                        DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                    }
                }
            }
            if (seekIssuerCert || seekResponderCert) {
                Iterator<TrustAnchor> anchors;
                if (DEBUG != null && seekResponderCert) {
                    DEBUG.println("Searching trust anchors for responder's certificate");
                }
                if (!(anchors = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                    throw new CertPathValidatorException("Must specify at least one trust anchor");
                }
                X500Principal certIssuerName = currCertImpl.getIssuerX500Principal();
                while (anchors.hasNext() && (seekIssuerCert || seekResponderCert)) {
                    TrustAnchor anchor = anchors.next();
                    X509Certificate anchorCert = anchor.getTrustedCert();
                    X500Principal anchorSubjectName = anchorCert.getSubjectX500Principal();
                    if (seekIssuerCert && certIssuerName.equals(anchorSubjectName)) {
                        issuerCertImpl = X509CertImpl.toImpl(anchorCert);
                        seekIssuerCert = false;
                        if (!seekResponderCert && responderCert == null) {
                            responderCert = anchorCert;
                            if (DEBUG != null) {
                                DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                            }
                        }
                    }
                    if (!seekResponderCert || (responderSubjectName == null || !responderSubjectName.equals(anchorSubjectName)) && (responderIssuerName == null || responderSerialNumber == null || !responderIssuerName.equals(anchorCert.getIssuerX500Principal()) || !responderSerialNumber.equals(anchorCert.getSerialNumber()))) continue;
                    responderCert = anchorCert;
                    seekResponderCert = false;
                }
                if (issuerCertImpl == null) {
                    throw new CertPathValidatorException("No trusted certificate for " + currCertImpl.getIssuerDN());
                }
                if (seekResponderCert) {
                    if (DEBUG != null) {
                        DEBUG.println("Searching cert stores for responder's certificate");
                    }
                    X509CertSelector filter = null;
                    if (responderSubjectName != null) {
                        filter = new X509CertSelector();
                        filter.setSubject(responderSubjectName.getName());
                    } else if (responderIssuerName != null && responderSerialNumber != null) {
                        filter = new X509CertSelector();
                        filter.setIssuer(responderIssuerName.getName());
                        filter.setSerialNumber(responderSerialNumber);
                    }
                    if (filter != null) {
                        List<CertStore> certStores = this.pkixParams.getCertStores();
                        AlgorithmChecker algChecker = AlgorithmChecker.getInstance();
                        for (CertStore certStore : certStores) {
                            for (Certificate certificate : certStore.getCertificates(filter)) {
                                try {
                                    AlgorithmChecker.check(certificate);
                                    responderCert = (X509Certificate)certificate;
                                    seekResponderCert = false;
                                    break;
                                }
                                catch (CertPathValidatorException cpve) {
                                    if (DEBUG == null) continue;
                                    DEBUG.println("OCSP responder certificate algorithm check failed: " + cpve);
                                }
                            }
                            if (seekResponderCert) continue;
                            break;
                        }
                    }
                }
            }
            if (seekResponderCert) {
                throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
            }
            OCSPRequest ocspRequest = new OCSPRequest(currCertImpl, issuerCertImpl);
            URL url = OCSPChecker.getOCSPServerURL(currCertImpl, properties);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            if (DEBUG != null) {
                DEBUG.println("connecting to OCSP service at: " + url);
            }
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            byte[] bytes = ocspRequest.encodeBytes();
            CertId certId = ocspRequest.getCertId();
            con.setRequestProperty("Content-length", String.valueOf(bytes.length));
            out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            if (DEBUG != null && con.getResponseCode() != 200) {
                DEBUG.println("Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
            }
            if (!certId.equals((ocspResponse = new OCSPResponse(response = IOUtils.readFully(in = con.getInputStream(), contentLength = con.getContentLength(), false), this.pkixParams, responderCert)).getCertId())) {
                throw new CertPathValidatorException("Certificate in the OCSP response does not match the certificate supplied in the OCSP request.");
            }
            SerialNumber serialNumber = currCertImpl.getSerialNumberObject();
            int certOCSPStatus = ocspResponse.getCertStatus(serialNumber);
            if (DEBUG != null) {
                DEBUG.println("Status of certificate (with serial number " + serialNumber.getNumber() + ") is: " + OCSPResponse.certStatusToText(certOCSPStatus));
            }
            if (certOCSPStatus == 1) {
                throw new CertificateRevokedException("Certificate has been revoked", this.cp, this.remainingCerts);
            }
            if (certOCSPStatus == 2) {
                throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.remainingCerts);
            }
        }
        catch (CertificateRevokedException cre) {
            throw cre;
        }
        catch (CertPathValidatorException cpve) {
            throw cpve;
        }
        catch (Exception e) {
            throw new CertPathValidatorException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    throw new CertPathValidatorException(ioe);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    throw new CertPathValidatorException(ioe);
                }
            }
        }
    }

    private static URL getOCSPServerURL(X509CertImpl currCertImpl, String[] properties) throws CertificateParsingException, CertPathValidatorException {
        if (properties[0] != null) {
            try {
                return new URL(properties[0]);
            }
            catch (MalformedURLException e) {
                throw new CertPathValidatorException(e);
            }
        }
        AuthorityInfoAccessExtension aia = currCertImpl.getAuthorityInfoAccessExtension();
        if (aia == null) {
            throw new CertPathValidatorException("Must specify the location of an OCSP Responder");
        }
        List<AccessDescription> descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            try {
                URIName uri = (URIName)generalName.getName();
                return new URL(uri.getName());
            }
            catch (MalformedURLException e) {
                throw new CertPathValidatorException(e);
            }
        }
        throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
    }

    private static String[] getOCSPProperties() {
        final String[] properties = new String[4];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                properties[0] = Security.getProperty(OCSPChecker.OCSP_URL_PROP);
                properties[1] = Security.getProperty(OCSPChecker.OCSP_CERT_SUBJECT_PROP);
                properties[2] = Security.getProperty(OCSPChecker.OCSP_CERT_ISSUER_PROP);
                properties[3] = Security.getProperty(OCSPChecker.OCSP_CERT_NUMBER_PROP);
                return null;
            }
        });
        return properties;
    }

    private static String stripOutSeparators(String value) {
        char[] chars = value.toCharArray();
        StringBuilder hexNumber = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (HEX_DIGITS.indexOf(chars[i]) == -1) continue;
            hexNumber.append(chars[i]);
        }
        return hexNumber.toString();
    }
}

