/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import sun.security.x509.AlgorithmId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlgorithmChecker
extends PKIXCertPathChecker {
    private static final String[] disabledAlgorithms = new String[]{"md2"};
    static final AlgorithmChecker INSTANCE = new AlgorithmChecker();

    private AlgorithmChecker() {
    }

    static AlgorithmChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        AlgorithmChecker.check(cert);
    }

    public static void check(Certificate cert) throws CertPathValidatorException {
        X509Certificate xcert = (X509Certificate)cert;
        AlgorithmChecker.check(xcert.getSigAlgName());
    }

    static void check(AlgorithmId aid) throws CertPathValidatorException {
        AlgorithmChecker.check(aid.getName());
    }

    static void check(X509CRL crl) throws CertPathValidatorException {
        AlgorithmChecker.check(crl.getSigAlgName());
    }

    private static void check(String algName) throws CertPathValidatorException {
        String lowerCaseAlgName = algName.toLowerCase(Locale.ENGLISH);
        for (String disabled : disabledAlgorithms) {
            if (lowerCaseAlgName.indexOf(disabled) == -1) continue;
            throw new CertPathValidatorException("algorithm check failed: " + algName + " is disabled");
        }
    }
}

