/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.krb5.KrbCryptoException;

public final class Des {
    private static final long[] bad_keys = new long[]{0x101010101010101L, -72340172838076674L, 0x1F1F1F1F1F1F1F1FL, -2242545357980376864L, 143554428589179390L, -143554428589179391L, 2296870857142767345L, -2296870857142767346L, 135110050437988849L, -2305315235293957887L, 2305315235293957886L, -135110050437988850L, 80784550989267214L, 2234100979542855169L, -2234100979542855170L, -80784550989267215L};
    private static final byte[] good_parity = new byte[]{1, 1, 2, 2, 4, 4, 7, 7, 8, 8, 11, 11, 13, 13, 14, 14, 16, 16, 19, 19, 21, 21, 22, 22, 25, 25, 26, 26, 28, 28, 31, 31, 32, 32, 35, 35, 37, 37, 38, 38, 41, 41, 42, 42, 44, 44, 47, 47, 49, 49, 50, 50, 52, 52, 55, 55, 56, 56, 59, 59, 61, 61, 62, 62, 64, 64, 67, 67, 69, 69, 70, 70, 73, 73, 74, 74, 76, 76, 79, 79, 81, 81, 82, 82, 84, 84, 87, 87, 88, 88, 91, 91, 93, 93, 94, 94, 97, 97, 98, 98, 100, 100, 103, 103, 104, 104, 107, 107, 109, 109, 110, 110, 112, 112, 115, 115, 117, 117, 118, 118, 121, 121, 122, 122, 124, 124, 127, 127, -128, -128, -125, -125, -123, -123, -122, -122, -119, -119, -118, -118, -116, -116, -113, -113, -111, -111, -110, -110, -108, -108, -105, -105, -104, -104, -101, -101, -99, -99, -98, -98, -95, -95, -94, -94, -92, -92, -89, -89, -88, -88, -85, -85, -83, -83, -82, -82, -80, -80, -77, -77, -75, -75, -74, -74, -71, -71, -70, -70, -68, -68, -65, -65, -63, -63, -62, -62, -60, -60, -57, -57, -56, -56, -53, -53, -51, -51, -50, -50, -48, -48, -45, -45, -43, -43, -42, -42, -39, -39, -38, -38, -36, -36, -33, -33, -32, -32, -29, -29, -27, -27, -26, -26, -23, -23, -22, -22, -20, -20, -17, -17, -15, -15, -14, -14, -12, -12, -9, -9, -8, -8, -5, -5, -3, -3, -2, -2};

    public static final byte[] set_parity(byte[] key) {
        for (int i = 0; i < 8; ++i) {
            key[i] = good_parity[key[i] & 0xFF];
        }
        return key;
    }

    public static final long set_parity(long key) {
        return Des.octet2long(Des.set_parity(Des.long2octet(key)));
    }

    public static final boolean bad_key(long key) {
        for (int i = 0; i < bad_keys.length; ++i) {
            if (bad_keys[i] != key) continue;
            return true;
        }
        return false;
    }

    public static final boolean bad_key(byte[] key) {
        return Des.bad_key(Des.octet2long(key));
    }

    public static long octet2long(byte[] input) {
        return Des.octet2long(input, 0);
    }

    public static long octet2long(byte[] input, int offset) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            if (i + offset >= input.length) continue;
            result |= ((long)input[i + offset] & 0xFFL) << (7 - i) * 8;
        }
        return result;
    }

    public static byte[] long2octet(long input) {
        byte[] output = new byte[8];
        for (int i = 0; i < 8; ++i) {
            output[i] = (byte)(input >>> (7 - i) * 8 & 0xFFL);
        }
        return output;
    }

    public static void long2octet(long input, byte[] output) {
        Des.long2octet(input, output, 0);
    }

    public static void long2octet(long input, byte[] output, int offset) {
        for (int i = 0; i < 8; ++i) {
            if (i + offset >= output.length) continue;
            output[i + offset] = (byte)(input >>> (7 - i) * 8 & 0xFFL);
        }
    }

    public static void cbc_encrypt(byte[] input, byte[] output, byte[] key, byte[] ivec, boolean encrypt) throws KrbCryptoException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException("JCE provider may not be installed. " + e.getMessage());
            ke.initCause(e);
            throw ke;
        }
        IvParameterSpec params = new IvParameterSpec(ivec);
        SecretKeySpec skSpec = new SecretKeySpec(key, "DES");
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            SecretKeySpec sk = skSpec;
            if (encrypt) {
                cipher.init(1, (Key)sk, params);
            } else {
                cipher.init(2, (Key)sk, params);
            }
            byte[] result = cipher.doFinal(input);
            System.arraycopy(result, 0, output, 0, result.length);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public static long char_to_key(char[] passwdChars) throws KrbCryptoException {
        long key = 0L;
        long octet2 = 0L;
        byte[] cbytes = null;
        try {
            cbytes = new String(passwdChars).getBytes();
        }
        catch (Exception e) {
            if (cbytes != null) {
                Arrays.fill(cbytes, 0, cbytes.length, (byte)0);
            }
            KrbCryptoException ce = new KrbCryptoException("Unable to convert passwd, " + e);
            ce.initCause(e);
            throw ce;
        }
        byte[] passwdBytes = Des.pad(cbytes);
        byte[] newkey = new byte[8];
        int length = passwdBytes.length / 8 + (passwdBytes.length % 8 == 0 ? 0 : 1);
        for (int i = 0; i < length; ++i) {
            long octet = Des.octet2long(passwdBytes, i * 8) & 0x7F7F7F7F7F7F7F7FL;
            if (i % 2 == 1) {
                long octet1 = 0L;
                for (int j = 0; j < 64; ++j) {
                    octet1 |= (octet & 1L << j) >>> j << 63 - j;
                }
                octet = octet1 >>> 1;
            }
            key ^= octet << 1;
        }
        if (Des.bad_key(key = Des.set_parity(key))) {
            byte[] temp = Des.long2octet(key);
            temp[7] = (byte)(temp[7] ^ 0xF0);
            key = Des.octet2long(temp);
        }
        if (Des.bad_key(key = Des.octet2long(Des.set_parity(newkey = Des.des_cksum(Des.long2octet(key), passwdBytes, Des.long2octet(key)))))) {
            byte[] temp = Des.long2octet(key);
            temp[7] = (byte)(temp[7] ^ 0xF0);
            key = Des.octet2long(temp);
        }
        if (cbytes != null) {
            Arrays.fill(cbytes, 0, cbytes.length, (byte)0);
        }
        if (passwdBytes != null) {
            Arrays.fill(passwdBytes, 0, passwdBytes.length, (byte)0);
        }
        return key;
    }

    public static byte[] des_cksum(byte[] ivec, byte[] msg, byte[] key) throws KrbCryptoException {
        Cipher cipher = null;
        byte[] result = new byte[8];
        try {
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (Exception e) {
            KrbCryptoException ke = new KrbCryptoException("JCE provider may not be installed. " + e.getMessage());
            ke.initCause(e);
            throw ke;
        }
        IvParameterSpec params = new IvParameterSpec(ivec);
        SecretKeySpec skSpec = new SecretKeySpec(key, "DES");
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            SecretKeySpec sk = skSpec;
            cipher.init(1, (Key)sk, params);
            for (int i = 0; i < msg.length / 8; ++i) {
                result = cipher.doFinal(msg, i * 8, 8);
                cipher.init(1, (Key)sk, new IvParameterSpec(result));
            }
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
        return result;
    }

    static byte[] pad(byte[] data) {
        int len = data.length < 8 ? data.length : data.length % 8;
        if (len == 0) {
            return data;
        }
        byte[] padding = new byte[8 - len + data.length];
        for (int i = padding.length - 1; i > data.length - 1; --i) {
            padding[i] = 0;
        }
        System.arraycopy(data, 0, padding, 0, data.length);
        return padding;
    }

    public static byte[] string_to_key_bytes(char[] passwdChars) throws KrbCryptoException {
        return Des.long2octet(Des.char_to_key(passwdChars));
    }
}

