/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import sun.java2d.Spans;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeekGraphics
extends Graphics2D
implements PrinterGraphics,
ImageObserver,
Cloneable {
    Graphics2D mGraphics;
    PrinterJob mPrinterJob;
    private Spans mDrawingArea = new Spans();
    private PeekMetrics mPrintMetrics = new PeekMetrics();
    private boolean mAWTDrawingOnly = false;

    public PeekGraphics(Graphics2D graphics, PrinterJob printerJob) {
        this.mGraphics = graphics;
        this.mPrinterJob = printerJob;
    }

    public Graphics2D getDelegate() {
        return this.mGraphics;
    }

    public void setDelegate(Graphics2D graphics) {
        this.mGraphics = graphics;
    }

    @Override
    public PrinterJob getPrinterJob() {
        return this.mPrinterJob;
    }

    public void setAWTDrawingOnly() {
        this.mAWTDrawingOnly = true;
    }

    public boolean getAWTDrawingOnly() {
        return this.mAWTDrawingOnly;
    }

    public Spans getDrawingArea() {
        return this.mDrawingArea;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return ((RasterPrinterJob)this.mPrinterJob).getPrinterGraphicsConfig();
    }

    @Override
    public Graphics create() {
        PeekGraphics newGraphics = null;
        try {
            newGraphics = (PeekGraphics)this.clone();
            newGraphics.mGraphics = (Graphics2D)this.mGraphics.create();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newGraphics;
    }

    @Override
    public void translate(int x, int y) {
        this.mGraphics.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.mGraphics.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.mGraphics.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.mGraphics.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.mGraphics.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.mGraphics.shear(shx, shy);
    }

    @Override
    public Color getColor() {
        return this.mGraphics.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.mGraphics.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.mGraphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.mGraphics.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.mGraphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.mGraphics.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.mGraphics.getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.mGraphics.getFontRenderContext();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.mGraphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.mGraphics.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.mGraphics.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.mGraphics.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.mGraphics.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.addStrokeShape(new Line2D.Float(x1, y1, x2, y2));
        this.mPrintMetrics.draw(this);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.addDrawingRect(new Rectangle2D.Float(x, y, width, height));
        this.mPrintMetrics.fill(this);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, width, height);
        this.addDrawingRect(rect);
        this.mPrintMetrics.clear(this);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.addStrokeShape(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
        this.mPrintMetrics.draw(this);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, width, height);
        this.addDrawingRect(rect);
        this.mPrintMetrics.fill(this);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.addStrokeShape(new Rectangle2D.Float(x, y, width, height));
        this.mPrintMetrics.draw(this);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, width, height);
        this.addDrawingRect(rect);
        this.mPrintMetrics.fill(this);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.addStrokeShape(new Rectangle2D.Float(x, y, width, height));
        this.mPrintMetrics.draw(this);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, width, height);
        this.addDrawingRect(rect);
        this.mPrintMetrics.fill(this);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            int x = xPoints[0];
            int y = yPoints[0];
            for (int i = 1; i < nPoints; ++i) {
                this.drawLine(x, y, xPoints[i], yPoints[i]);
                x = xPoints[i];
                y = yPoints[i];
            }
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            this.drawPolyline(xPoints, yPoints, nPoints);
            this.drawLine(xPoints[nPoints - 1], yPoints[nPoints - 1], xPoints[0], yPoints[0]);
        }
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            int minX = xPoints[0];
            int minY = yPoints[0];
            int maxX = xPoints[0];
            int maxY = yPoints[0];
            for (int i = 1; i < nPoints; ++i) {
                if (xPoints[i] < minX) {
                    minX = xPoints[i];
                } else if (xPoints[i] > maxX) {
                    maxX = xPoints[i];
                }
                if (yPoints[i] < minY) {
                    minY = yPoints[i];
                    continue;
                }
                if (yPoints[i] <= maxY) continue;
                maxY = yPoints[i];
            }
            this.addDrawingRect(minX, minY, maxX - minX, maxY - minY);
        }
        this.mPrintMetrics.fill(this);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (iterator == null) {
            throw new NullPointerException("AttributedCharacterIterator is null");
        }
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        ImageWaiter dim = new ImageWaiter(img);
        this.addDrawingRect(x, y, dim.getWidth(), dim.getHeight());
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        return this.mGraphics.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        this.addDrawingRect(x, y, width, height);
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        return this.mGraphics.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        ImageWaiter dim = new ImageWaiter(img);
        this.addDrawingRect(x, y, dim.getWidth(), dim.getHeight());
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        return this.mGraphics.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        this.addDrawingRect(x, y, width, height);
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        return this.mGraphics.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int width = dx2 - dx1;
        int height = dy2 - dy1;
        this.addDrawingRect(dx1, dy1, width, height);
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        return this.mGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int width = dx2 - dx1;
        int height = dy2 - dy1;
        this.addDrawingRect(dx1, dy1, width, height);
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        return this.mGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (img == null) {
            return;
        }
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        this.mDrawingArea.addInfinite();
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (img == null) {
            return;
        }
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        this.mDrawingArea.addInfinite();
    }

    @Override
    public void dispose() {
        this.mGraphics.dispose();
    }

    @Override
    public void finalize() {
    }

    @Override
    public void draw(Shape s) {
        this.addStrokeShape(s);
        this.mPrintMetrics.draw(this);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (img == null) {
            return true;
        }
        this.mDrawingArea.addInfinite();
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        return this.mGraphics.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (img == null) {
            return;
        }
        this.mPrintMetrics.drawImage((Graphics2D)this, img);
        this.mDrawingArea.addInfinite();
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str.length() == 0) {
            return;
        }
        FontRenderContext frc = this.getFontRenderContext();
        Rectangle2D bbox = this.getFont().getStringBounds(str, frc);
        this.addDrawingRect(bbox, x, y);
        this.mPrintMetrics.drawText(this);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Rectangle2D bbox = g.getLogicalBounds();
        this.addDrawingRect(bbox, x, y);
        this.mPrintMetrics.drawText(this);
    }

    @Override
    public void fill(Shape s) {
        this.addDrawingRect(s.getBounds());
        this.mPrintMetrics.fill(this);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.mGraphics.hit(rect, s, onStroke);
    }

    @Override
    public void setComposite(Composite comp) {
        this.mGraphics.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.mGraphics.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.mGraphics.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintCategory, Object hintValue) {
        this.mGraphics.setRenderingHint(hintCategory, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintCategory) {
        return this.mGraphics.getRenderingHint(hintCategory);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.mGraphics.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.mGraphics.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.mGraphics.getRenderingHints();
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.mGraphics.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.mGraphics.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.mGraphics.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.mGraphics.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.mGraphics.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.mGraphics.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.mGraphics.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.mGraphics.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.mGraphics.clip(s);
    }

    public boolean hitsDrawingArea(Rectangle rect) {
        return this.mDrawingArea.intersects((float)rect.getMinY(), (float)rect.getMaxY());
    }

    public PeekMetrics getMetrics() {
        return this.mPrintMetrics;
    }

    private void addDrawingRect(Rectangle2D rect, float x, float y) {
        this.addDrawingRect((float)(rect.getX() + (double)x), (float)(rect.getY() + (double)y), (float)rect.getWidth(), (float)rect.getHeight());
    }

    private void addDrawingRect(float x, float y, float width, float height) {
        Rectangle2D.Float bbox = new Rectangle2D.Float(x, y, width, height);
        this.addDrawingRect(bbox);
    }

    private void addDrawingRect(Rectangle2D rect) {
        AffineTransform matrix = this.getTransform();
        Shape transShape = matrix.createTransformedShape(rect);
        Rectangle2D transRect = transShape.getBounds2D();
        this.mDrawingArea.add((float)transRect.getMinY(), (float)transRect.getMaxY());
    }

    private void addStrokeShape(Shape s) {
        Shape transShape = this.getStroke().createStrokedShape(s);
        this.addDrawingRect(transShape.getBounds2D());
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoFlags, int x, int y, int width, int height) {
        boolean gotInfo = false;
        if ((infoFlags & 3) != 0) {
            gotInfo = true;
            this.notify();
        }
        return gotInfo;
    }

    private synchronized int getImageWidth(Image img) {
        while (img.getWidth(this) == -1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return img.getWidth(this);
    }

    private synchronized int getImageHeight(Image img) {
        while (img.getHeight(this) == -1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return img.getHeight(this);
    }

    protected class ImageWaiter
    implements ImageObserver {
        private int mWidth;
        private int mHeight;
        private boolean badImage = false;

        ImageWaiter(Image img) {
            this.waitForDimensions(img);
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        private synchronized void waitForDimensions(Image img) {
            this.mHeight = img.getHeight(this);
            this.mWidth = img.getWidth(this);
            while (!(this.badImage || this.mWidth >= 0 && this.mHeight >= 0)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mHeight = img.getHeight(this);
                this.mWidth = img.getWidth(this);
            }
            if (this.badImage) {
                this.mHeight = 0;
                this.mWidth = 0;
            }
        }

        public synchronized boolean imageUpdate(Image image, int flags, int x, int y, int w, int h) {
            boolean dontCallMeAgain = (flags & 0xC2) != 0;
            this.badImage = (flags & 0xC0) != 0;
            return dontCallMeAgain;
        }
    }
}

