/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileKey;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.Reflect;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.Util;
import sun.security.action.GetPropertyAction;

public class FileChannelImpl
extends FileChannel {
    private static NativeDispatcher nd;
    private static long allocationGranularity;
    private static Field isAMappedBufferField;
    private FileDescriptor fd;
    private boolean writable;
    private boolean readable;
    private boolean appending;
    private Object parent;
    private NativeThreadSet threads = new NativeThreadSet(2);
    private Object positionLock = new Object();
    private static volatile boolean transferSupported;
    private static volatile boolean pipeSupported;
    private static volatile boolean fileSupported;
    private static final int TRANSFER_SIZE = 8192;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    public static final int NO_LOCK = -1;
    public static final int LOCKED = 0;
    public static final int RET_EX_LOCK = 1;
    public static final int INTERRUPTED = 2;
    private volatile FileLockTable fileLockTable;
    private static boolean isSharedFileLockTable;
    private static volatile boolean propertyChecked;

    private FileChannelImpl(FileDescriptor fd, boolean readable, boolean writable, Object parent, boolean append) {
        this.fd = fd;
        this.readable = readable;
        this.writable = writable;
        this.parent = parent;
        this.appending = append;
    }

    public static FileChannel open(FileDescriptor fd, boolean readable, boolean writable, Object parent) {
        return new FileChannelImpl(fd, readable, writable, parent, false);
    }

    public static FileChannel open(FileDescriptor fd, boolean readable, boolean writable, Object parent, boolean append) {
        return new FileChannelImpl(fd, readable, writable, parent, append);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    protected void implCloseChannel() throws IOException {
        nd.preClose(this.fd);
        this.threads.signal();
        if (this.fileLockTable != null) {
            this.fileLockTable.removeAll(new FileLockTable.Releaser(){

                public void release(FileLock fl) throws IOException {
                    ((FileLockImpl)fl).invalidate();
                    FileChannelImpl.this.release0(FileChannelImpl.this.fd, fl.position(), fl.size());
                }
            });
        }
        if (this.parent != null) {
            if (this.parent instanceof FileInputStream) {
                ((FileInputStream)this.parent).close();
            } else if (this.parent instanceof FileOutputStream) {
                ((FileOutputStream)this.parent).close();
            } else if (this.parent instanceof RandomAccessFile) {
                ((RandomAccessFile)this.parent).close();
            } else assert (false);
        } else {
            nd.close(this.fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n;
            int ti;
            int n2;
            block12: {
                boolean bl;
                int n3;
                block11: {
                    n2 = 0;
                    ti = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var7_7 = null;
                            this.threads.remove(ti);
                            bl = n2 > 0;
                            break block11;
                        }
                        ti = this.threads.add();
                        while ((n2 = IOUtil.read(this.fd, dst, -1L, nd, this.positionLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.threads.remove(ti);
                        this.end(n2 > 0);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var7_8 = null;
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long read0(ByteBuffer[] dsts) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int ti;
            long n;
            block12: {
                boolean bl;
                long l2;
                block11: {
                    n = 0L;
                    ti = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l2 = 0L;
                            Object var9_7 = null;
                            this.threads.remove(ti);
                            bl = n > 0L;
                            break block11;
                        }
                        ti = this.threads.add();
                        while ((n = IOUtil.read(this.fd, dsts, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(n);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(ti);
                        this.end(n > 0L);
                        assert (IOStatus.check(n));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n));
                return l2;
            }
            Object var9_8 = null;
            this.threads.remove(ti);
            this.end(n > 0L);
            assert (IOStatus.check(n));
            return l;
        }
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > dsts.length - length) {
            throw new IndexOutOfBoundsException();
        }
        return this.read0(Util.subsequence(dsts, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer src) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n;
            int ti;
            int n2;
            block13: {
                boolean bl;
                int n3;
                block12: {
                    n2 = 0;
                    ti = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var7_7 = null;
                            this.threads.remove(ti);
                            bl = n2 > 0;
                            break block12;
                        }
                        ti = this.threads.add();
                        if (this.appending) {
                            this.position(this.size());
                        }
                        while ((n2 = IOUtil.write(this.fd, src, -1L, nd, this.positionLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.threads.remove(ti);
                        this.end(n2 > 0);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var7_8 = null;
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long write0(ByteBuffer[] srcs) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int ti;
            long n;
            block13: {
                boolean bl;
                long l2;
                block12: {
                    n = 0L;
                    ti = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l2 = 0L;
                            Object var9_7 = null;
                            this.threads.remove(ti);
                            bl = n > 0L;
                            break block12;
                        }
                        ti = this.threads.add();
                        if (this.appending) {
                            this.position(this.size());
                        }
                        while ((n = IOUtil.write(this.fd, srcs, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(n);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(ti);
                        this.end(n > 0L);
                        assert (IOStatus.check(n));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n));
                return l2;
            }
            Object var9_8 = null;
            this.threads.remove(ti);
            this.end(n > 0L);
            assert (IOStatus.check(n));
            return l;
        }
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        return this.write0(Util.subsequence(srcs, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int ti;
            long p;
            block11: {
                boolean bl;
                long l2;
                block10: {
                    p = -1L;
                    ti = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l2 = 0L;
                            Object var8_6 = null;
                            this.threads.remove(ti);
                            bl = p > -1L;
                            break block10;
                        }
                        ti = this.threads.add();
                        while ((p = this.position0(this.fd, -1L)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(p);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.threads.remove(ti);
                        this.end(p > -1L);
                        assert (IOStatus.check(p));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(p));
                return l2;
            }
            Object var8_7 = null;
            this.threads.remove(ti);
            this.end(p > -1L);
            assert (IOStatus.check(p));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        if (newPosition < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int ti;
            long p;
            block12: {
                boolean bl;
                FileChannel fileChannel;
                block11: {
                    p = -1L;
                    ti = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            fileChannel = null;
                            Object var9_7 = null;
                            this.threads.remove(ti);
                            bl = p > -1L;
                            break block11;
                        }
                        ti = this.threads.add();
                        while ((p = this.position0(this.fd, newPosition)) == -3L && this.isOpen()) {
                        }
                        fileChannelImpl = this;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(ti);
                        this.end(p > -1L);
                        assert (IOStatus.check(p));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(p));
                return fileChannel;
            }
            Object var9_8 = null;
            this.threads.remove(ti);
            this.end(p > -1L);
            assert (IOStatus.check(p));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long size() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l;
            int ti;
            long s;
            block11: {
                boolean bl;
                long l2;
                block10: {
                    s = -1L;
                    ti = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l2 = -1L;
                            Object var8_6 = null;
                            this.threads.remove(ti);
                            bl = s > -1L;
                            break block10;
                        }
                        ti = this.threads.add();
                        while ((s = this.size0(this.fd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(s);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.threads.remove(ti);
                        this.end(s > -1L);
                        assert (IOStatus.check(s));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(s));
                return l2;
            }
            Object var8_7 = null;
            this.threads.remove(ti);
            this.end(s > -1L);
            assert (IOStatus.check(s));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileChannel truncate(long size) throws IOException {
        this.ensureOpen();
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (size > this.size()) {
            return this;
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int ti;
            int rv;
            block24: {
                FileChannel fileChannel;
                block23: {
                    FileChannel fileChannel2;
                    block22: {
                        boolean bl;
                        FileChannel fileChannel3;
                        block21: {
                            rv = -1;
                            long p = -1L;
                            ti = -1;
                            try {
                                this.begin();
                                if (!this.isOpen()) {
                                    fileChannel3 = null;
                                    Object var10_10 = null;
                                    this.threads.remove(ti);
                                    bl = rv > -1;
                                    break block21;
                                }
                                ti = this.threads.add();
                                while ((p = this.position0(this.fd, -1L)) == -3L && this.isOpen()) {
                                }
                                if (!this.isOpen()) {
                                    fileChannel2 = null;
                                    break block22;
                                }
                                assert (p >= 0L);
                                while ((rv = this.truncate0(this.fd, size)) == -3 && this.isOpen()) {
                                }
                                if (!this.isOpen()) {
                                    fileChannel = null;
                                    break block23;
                                }
                                if (p > size) {
                                    p = size;
                                }
                                while ((rv = (int)this.position0(this.fd, p)) == -3 && this.isOpen()) {
                                }
                                fileChannelImpl = this;
                                break block24;
                            }
                            catch (Throwable throwable) {
                                Object var10_14 = null;
                                this.threads.remove(ti);
                                this.end(rv > -1);
                                assert (IOStatus.check(rv));
                                throw throwable;
                            }
                        }
                        this.end(bl);
                        assert (IOStatus.check(rv));
                        return fileChannel3;
                    }
                    Object var10_11 = null;
                    this.threads.remove(ti);
                    this.end(rv > -1);
                    assert (IOStatus.check(rv));
                    return fileChannel2;
                }
                Object var10_12 = null;
                this.threads.remove(ti);
                this.end(rv > -1);
                assert (IOStatus.check(rv));
                return fileChannel;
            }
            Object var10_13 = null;
            this.threads.remove(ti);
            this.end(rv > -1);
            assert (IOStatus.check(rv));
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void force(boolean metaData) throws IOException {
        int ti;
        int rv;
        block8: {
            boolean bl;
            block7: {
                this.ensureOpen();
                rv = -1;
                ti = -1;
                try {
                    this.begin();
                    if (!this.isOpen()) {
                        Object var5_4 = null;
                        this.threads.remove(ti);
                        bl = rv > -1;
                        break block7;
                    }
                    ti = this.threads.add();
                    while ((rv = this.force0(this.fd, metaData)) == -3) {
                        if (this.isOpen()) continue;
                        break block8;
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.threads.remove(ti);
                    this.end(rv > -1);
                    assert (IOStatus.check(rv));
                    throw throwable;
                }
            }
            this.end(bl);
            assert (IOStatus.check(rv));
            return;
        }
        Object var5_5 = null;
        this.threads.remove(ti);
        this.end(rv > -1);
        assert (IOStatus.check(rv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectly(long position, int icount, WritableByteChannel target) throws IOException {
        int ti;
        long n;
        block18: {
            block17: {
                long l;
                int targetFDVal;
                int thisFDVal;
                block16: {
                    if (!transferSupported) {
                        return -4L;
                    }
                    FileDescriptor targetFD = null;
                    if (target instanceof FileChannelImpl) {
                        if (!fileSupported) {
                            return -6L;
                        }
                        targetFD = ((FileChannelImpl)target).fd;
                    } else if (target instanceof SelChImpl) {
                        if (target instanceof SinkChannelImpl && !pipeSupported) {
                            return -6L;
                        }
                        targetFD = ((SelChImpl)((Object)target)).getFD();
                    }
                    if (targetFD == null) {
                        return -4L;
                    }
                    thisFDVal = IOUtil.fdVal(this.fd);
                    if (thisFDVal == (targetFDVal = IOUtil.fdVal(targetFD))) {
                        return -4L;
                    }
                    n = -1L;
                    ti = -1;
                    this.begin();
                    if (this.isOpen()) break block16;
                    long l2 = -1L;
                    Object var14_13 = null;
                    this.threads.remove(ti);
                    this.end(n > -1L);
                    return l2;
                }
                try {
                    ti = this.threads.add();
                    while ((n = this.transferTo0(thisFDVal, position, icount, targetFDVal)) == -3L && this.isOpen()) {
                    }
                    if (n != -6L) break block17;
                    if (target instanceof SinkChannelImpl) {
                        pipeSupported = false;
                    }
                    if (target instanceof FileChannelImpl) {
                        fileSupported = false;
                    }
                    l = -6L;
                    Object var14_14 = null;
                    this.threads.remove(ti);
                    this.end(n > -1L);
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    this.threads.remove(ti);
                    this.end(n > -1L);
                    throw throwable;
                }
                return l;
            }
            if (n != -4L) break block18;
            transferSupported = false;
            long l = -4L;
            Object var14_15 = null;
            this.threads.remove(ti);
            this.end(n > -1L);
            return l;
        }
        long l = IOStatus.normalize(n);
        Object var14_16 = null;
        this.threads.remove(ti);
        this.end(n > -1L);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToTrustedChannel(long position, int icount, WritableByteChannel target) throws IOException {
        long l;
        block3: {
            if (!(target instanceof FileChannelImpl) && !(target instanceof SelChImpl)) {
                return -4L;
            }
            MappedByteBuffer dbb = null;
            try {
                dbb = this.map(FileChannel.MapMode.READ_ONLY, position, icount);
                l = target.write(dbb);
                Object var9_6 = null;
                if (dbb == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_7 = null;
                    if (dbb == null) break block4;
                    FileChannelImpl.unmap(dbb);
                }
                throw throwable;
            }
            FileChannelImpl.unmap(dbb);
        }
        return l;
    }

    private long transferToArbitraryChannel(long position, int icount, WritableByteChannel target) throws IOException {
        long nr2;
        int c = Math.min(icount, 8192);
        ByteBuffer bb = Util.getTemporaryDirectBuffer(c);
        long tw = 0L;
        long pos = position;
        try {
            Util.erase(bb);
            while (tw < (long)icount) {
                bb.limit(Math.min((int)((long)icount - tw), 8192));
                int nr2 = this.read(bb, pos);
                if (nr2 <= 0) break;
                bb.flip();
                int nw = target.write(bb);
                tw += (long)nw;
                if (nw != nr2) break;
                pos += (long)nw;
                bb.clear();
            }
            nr2 = tw;
            Object var15_13 = null;
        }
        catch (IOException x) {
            block6: {
                long l;
                try {
                    if (tw <= 0L) break block6;
                    l = tw;
                    Object var15_14 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    Util.releaseTemporaryDirectBuffer(bb);
                    throw throwable;
                }
                Util.releaseTemporaryDirectBuffer(bb);
                return l;
            }
            throw x;
        }
        Util.releaseTemporaryDirectBuffer(bb);
        return nr2;
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        long n;
        this.ensureOpen();
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (target instanceof FileChannelImpl && !((FileChannelImpl)target).writable) {
            throw new NonWritableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        long sz = this.size();
        if (position > sz) {
            return 0L;
        }
        int icount = (int)Math.min(count, Integer.MAX_VALUE);
        if (sz - position < (long)icount) {
            icount = (int)(sz - position);
        }
        if ((n = this.transferToDirectly(position, icount, target)) >= 0L) {
            return n;
        }
        n = this.transferToTrustedChannel(position, icount, target);
        if (n >= 0L) {
            return n;
        }
        return this.transferToArbitraryChannel(position, icount, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long transferFromFileChannel(FileChannelImpl src, long position, long count) throws IOException {
        Object object = src.positionLock;
        synchronized (object) {
            long l;
            long p = src.position();
            int icount = (int)Math.min(Math.min(count, Integer.MAX_VALUE), src.size() - p);
            MappedByteBuffer bb = src.map(FileChannel.MapMode.READ_ONLY, p, icount);
            try {
                long n = this.write(bb, position);
                src.position(p + n);
                l = n;
                Object var16_10 = null;
            }
            catch (Throwable throwable) {
                Object var16_11 = null;
                FileChannelImpl.unmap(bb);
                throw throwable;
            }
            FileChannelImpl.unmap(bb);
            return l;
        }
    }

    private long transferFromArbitraryChannel(ReadableByteChannel src, long position, long count) throws IOException {
        long nr2;
        int c = (int)Math.min(count, 8192L);
        ByteBuffer bb = Util.getTemporaryDirectBuffer(c);
        long tw = 0L;
        long pos = position;
        try {
            Util.erase(bb);
            while (tw < count) {
                bb.limit((int)Math.min(count - tw, 8192L));
                int nr2 = src.read(bb);
                if (nr2 <= 0) break;
                bb.flip();
                int nw = this.write(bb, pos);
                tw += (long)nw;
                if (nw != nr2) break;
                pos += (long)nw;
                bb.clear();
            }
            nr2 = tw;
            Object var16_13 = null;
        }
        catch (IOException x) {
            block6: {
                long l;
                try {
                    if (tw <= 0L) break block6;
                    l = tw;
                    Object var16_14 = null;
                }
                catch (Throwable throwable) {
                    Object var16_15 = null;
                    Util.releaseTemporaryDirectBuffer(bb);
                    throw throwable;
                }
                Util.releaseTemporaryDirectBuffer(bb);
                return l;
            }
            throw x;
        }
        Util.releaseTemporaryDirectBuffer(bb);
        return nr2;
    }

    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.ensureOpen();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (position > this.size()) {
            return 0L;
        }
        if (src instanceof FileChannelImpl) {
            return this.transferFromFileChannel((FileChannelImpl)src, position, count);
        }
        return this.transferFromArbitraryChannel(src, position, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst, long position) throws IOException {
        int n;
        int ti;
        int n2;
        block10: {
            if (dst == null) {
                throw new NullPointerException();
            }
            if (position < 0L) {
                throw new IllegalArgumentException("Negative position");
            }
            if (!this.readable) {
                throw new NonReadableChannelException();
            }
            this.ensureOpen();
            n2 = 0;
            ti = -1;
            this.begin();
            if (this.isOpen()) break block10;
            int n3 = -1;
            Object var8_7 = null;
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            return n3;
        }
        try {
            ti = this.threads.add();
            while ((n2 = IOUtil.read(this.fd, dst, position, nd, this.positionLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            Object var8_8 = null;
            this.threads.remove(ti);
            this.end(n2 > 0);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            throw throwable;
        }
        assert (IOStatus.check(n2));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src, long position) throws IOException {
        int n;
        int ti;
        int n2;
        block10: {
            if (src == null) {
                throw new NullPointerException();
            }
            if (position < 0L) {
                throw new IllegalArgumentException("Negative position");
            }
            if (!this.writable) {
                throw new NonWritableChannelException();
            }
            this.ensureOpen();
            n2 = 0;
            ti = -1;
            this.begin();
            if (this.isOpen()) break block10;
            int n3 = -1;
            Object var8_7 = null;
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            return n3;
        }
        try {
            ti = this.threads.add();
            while ((n2 = IOUtil.write(this.fd, src, position, nd, this.positionLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            Object var8_8 = null;
            this.threads.remove(ti);
            this.end(n2 > 0);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.threads.remove(ti);
            this.end(n2 > 0);
            assert (IOStatus.check(n2));
            throw throwable;
        }
        assert (IOStatus.check(n2));
        return n;
    }

    private static void unmap(MappedByteBuffer bb) {
        Cleaner cl = ((DirectBuffer)((Object)bb)).cleaner();
        if (cl != null) {
            cl.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        Unmapper um;
        int isize;
        int pagePosition;
        int ti;
        long addr;
        block32: {
            int imode;
            block30: {
                block31: {
                    MappedByteBuffer rv2;
                    block29: {
                        this.ensureOpen();
                        if (position < 0L) {
                            throw new IllegalArgumentException("Negative position");
                        }
                        if (size < 0L) {
                            throw new IllegalArgumentException("Negative size");
                        }
                        if (position + size < 0L) {
                            throw new IllegalArgumentException("Position + size overflow");
                        }
                        if (size > Integer.MAX_VALUE) {
                            throw new IllegalArgumentException("Size exceeds Integer.MAX_VALUE");
                        }
                        imode = -1;
                        if (mode == FileChannel.MapMode.READ_ONLY) {
                            imode = 0;
                        } else if (mode == FileChannel.MapMode.READ_WRITE) {
                            imode = 1;
                        } else if (mode == FileChannel.MapMode.PRIVATE) {
                            imode = 2;
                        }
                        assert (imode >= 0);
                        if (mode != FileChannel.MapMode.READ_ONLY && !this.writable) {
                            throw new NonWritableChannelException();
                        }
                        if (!this.readable) {
                            throw new NonReadableChannelException();
                        }
                        addr = -1L;
                        ti = -1;
                        this.begin();
                        if (this.isOpen()) break block29;
                        MappedByteBuffer mappedByteBuffer = null;
                        Object var19_11 = null;
                        this.threads.remove(ti);
                        this.end(IOStatus.checkAll(addr));
                        return mappedByteBuffer;
                    }
                    try {
                        ti = this.threads.add();
                        if (this.size() < position + size) {
                            int rv2;
                            if (!this.writable) {
                                throw new IOException("Channel not open for writing - cannot extend file to required size");
                            }
                            while ((rv2 = this.truncate0(this.fd, position + size)) == -3 && this.isOpen()) {
                            }
                        }
                        if (size != 0L) break block30;
                        addr = 0L;
                        if (this.writable && imode != 0) break block31;
                        rv2 = Util.newMappedByteBufferR(0, 0L, null);
                        Object var19_12 = null;
                        this.threads.remove(ti);
                    }
                    catch (Throwable throwable) {
                        Object var19_16 = null;
                        this.threads.remove(ti);
                        this.end(IOStatus.checkAll(addr));
                        throw throwable;
                    }
                    this.end(IOStatus.checkAll(addr));
                    return rv2;
                }
                MappedByteBuffer rv2 = Util.newMappedByteBuffer(0, 0L, null);
                Object var19_13 = null;
                this.threads.remove(ti);
                this.end(IOStatus.checkAll(addr));
                return rv2;
            }
            pagePosition = (int)(position % allocationGranularity);
            long mapPosition = position - (long)pagePosition;
            long mapSize = size + (long)pagePosition;
            try {
                addr = this.map0(imode, mapPosition, mapSize);
            }
            catch (OutOfMemoryError x) {
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException y) {
                    Thread.currentThread().interrupt();
                }
                try {
                    addr = this.map0(imode, mapPosition, mapSize);
                }
                catch (OutOfMemoryError y) {
                    throw new IOException("Map failed", y);
                }
            }
            assert (IOStatus.checkAll(addr));
            assert (addr % allocationGranularity == 0L);
            isize = (int)size;
            um = new Unmapper(addr, size + (long)pagePosition);
            if (this.writable && imode != 0) break block32;
            MappedByteBuffer mappedByteBuffer = Util.newMappedByteBufferR(isize, addr + (long)pagePosition, um);
            Object var19_14 = null;
            this.threads.remove(ti);
            this.end(IOStatus.checkAll(addr));
            return mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(isize, addr + (long)pagePosition, um);
        Object var19_15 = null;
        this.threads.remove(ti);
        this.end(IOStatus.checkAll(addr));
        return mappedByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSharedFileLockTable() {
        if (propertyChecked) return isSharedFileLockTable;
        Class<FileChannelImpl> clazz = FileChannelImpl.class;
        synchronized (FileChannelImpl.class) {
            if (propertyChecked) return isSharedFileLockTable;
            String value = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.disableSystemWideOverlappingFileLockCheck"));
            isSharedFileLockTable = value == null || value.equals("false");
            propertyChecked = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return isSharedFileLockTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockTable fileLockTable() {
        if (this.fileLockTable == null) {
            FileChannelImpl fileChannelImpl = this;
            synchronized (fileChannelImpl) {
                if (this.fileLockTable == null) {
                    this.fileLockTable = FileChannelImpl.isSharedFileLockTable() ? new SharedFileLockTable(this) : new SimpleFileLockTable();
                }
            }
        }
        return this.fileLockTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        int ti;
        boolean i;
        FileLockImpl fli;
        block17: {
            FileLockImpl fileLockImpl;
            block16: {
                FileLock fileLock;
                block15: {
                    this.ensureOpen();
                    if (shared && !this.readable) {
                        throw new NonReadableChannelException();
                    }
                    if (!shared && !this.writable) {
                        throw new NonWritableChannelException();
                    }
                    fli = new FileLockImpl(this, position, size, shared);
                    FileLockTable flt = this.fileLockTable();
                    flt.add(fli);
                    i = true;
                    ti = -1;
                    try {
                        try {
                            this.begin();
                            if (!this.isOpen()) {
                                fileLock = null;
                                Object var14_11 = null;
                                this.threads.remove(ti);
                                break block15;
                            }
                            ti = this.threads.add();
                            int result = this.lock0(this.fd, true, position, size, shared);
                            if (result == 1) {
                                assert (shared);
                                FileLockImpl fli2 = new FileLockImpl(this, position, size, false);
                                flt.replace(fli, fli2);
                                fileLockImpl = fli2;
                                break block16;
                            }
                            if (result == 2 || result == -1) {
                                flt.remove(fli);
                                i = false;
                            }
                            break block17;
                        }
                        catch (IOException e) {
                            flt.remove(fli);
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        this.threads.remove(ti);
                        try {
                            this.end(i);
                            throw throwable;
                        }
                        catch (ClosedByInterruptException e) {
                            throw new FileLockInterruptionException();
                        }
                    }
                }
                try {}
                catch (ClosedByInterruptException e) {
                    throw new FileLockInterruptionException();
                }
                this.end(i);
                return fileLock;
            }
            Object var14_12 = null;
            this.threads.remove(ti);
            try {}
            catch (ClosedByInterruptException e) {
                throw new FileLockInterruptionException();
            }
            this.end(i);
            return fileLockImpl;
        }
        Object var14_13 = null;
        this.threads.remove(ti);
        try {}
        catch (ClosedByInterruptException e) {
            throw new FileLockInterruptionException();
        }
        this.end(i);
        return fli;
    }

    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        this.ensureOpen();
        if (shared && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fli = new FileLockImpl(this, position, size, shared);
        FileLockTable flt = this.fileLockTable();
        flt.add(fli);
        int result = this.lock0(this.fd, false, position, size, shared);
        if (result == -1) {
            flt.remove(fli);
            return null;
        }
        if (result == 1) {
            assert (shared);
            FileLockImpl fli2 = new FileLockImpl(this, position, size, false);
            flt.replace(fli, fli2);
            return fli2;
        }
        return fli;
    }

    void release(FileLockImpl fli) throws IOException {
        this.ensureOpen();
        this.release0(this.fd, fli.position(), fli.size());
        assert (this.fileLockTable != null);
        this.fileLockTable.remove(fli);
    }

    native int lock0(FileDescriptor var1, boolean var2, long var3, long var5, boolean var7) throws IOException;

    native void release0(FileDescriptor var1, long var2, long var4) throws IOException;

    private native long map0(int var1, long var2, long var4) throws IOException;

    private static native int unmap0(long var0, long var2);

    private native int force0(FileDescriptor var1, boolean var2);

    private native int truncate0(FileDescriptor var1, long var2);

    private native long transferTo0(int var1, long var2, long var4, int var6);

    private native long position0(FileDescriptor var1, long var2);

    private native long size0(FileDescriptor var1);

    private static native long initIDs();

    static {
        transferSupported = true;
        pipeSupported = true;
        fileSupported = true;
        Util.load();
        allocationGranularity = FileChannelImpl.initIDs();
        nd = new FileDispatcher();
        isAMappedBufferField = Reflect.lookupField("java.nio.MappedByteBuffer", "isAMappedBuffer");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SharedFileLockTable
    implements FileLockTable {
        private static ConcurrentHashMap<FileKey, ArrayList<FileLockReference>> lockMap = new ConcurrentHashMap();
        private static ReferenceQueue queue = new ReferenceQueue();
        private FileChannelImpl fci;
        private FileKey fileKey;

        public SharedFileLockTable(FileChannelImpl fci) {
            this.fci = fci;
            this.fileKey = FileKey.create(fci.fd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(FileLock fl) throws OverlappingFileLockException {
            ArrayList<FileLockReference> list = lockMap.get(this.fileKey);
            while (true) {
                if (list == null) {
                    ArrayList<FileLockReference> prev;
                    ArrayList<FileLockReference> arrayList = list = new ArrayList(2);
                    synchronized (arrayList) {
                        prev = lockMap.putIfAbsent(this.fileKey, list);
                        if (prev == null) {
                            list.add(new FileLockReference(fl, queue, this.fileKey));
                            break;
                        }
                    }
                    list = prev;
                }
                ArrayList<FileLockReference> arrayList = list;
                synchronized (arrayList) {
                    ArrayList<FileLockReference> current = lockMap.get(this.fileKey);
                    if (list == current) {
                        this.checkList(list, fl.position(), fl.size());
                        list.add(new FileLockReference(fl, queue, this.fileKey));
                        break;
                    }
                    list = current;
                }
            }
            this.removeStaleEntries();
        }

        private void removeKeyIfEmpty(FileKey fk, ArrayList<FileLockReference> list) {
            assert (Thread.holdsLock(list));
            assert (lockMap.get(fk) == list);
            if (list.isEmpty()) {
                lockMap.remove(fk);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(FileLock fl) {
            assert (fl != null);
            ArrayList<FileLockReference> list = lockMap.get(this.fileKey);
            assert (list != null);
            ArrayList<FileLockReference> arrayList = list;
            synchronized (arrayList) {
                for (int index = 0; index < list.size(); ++index) {
                    FileLockReference ref = list.get(index);
                    FileLock lock = (FileLock)ref.get();
                    if (lock != fl) continue;
                    assert (lock != null && lock.channel() == this.fci);
                    ref.clear();
                    list.remove(index);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAll(FileLockTable.Releaser releaser) throws IOException {
            ArrayList<FileLockReference> list = lockMap.get(this.fileKey);
            if (list != null) {
                ArrayList<FileLockReference> arrayList = list;
                synchronized (arrayList) {
                    int index = 0;
                    while (index < list.size()) {
                        FileLockReference ref = list.get(index);
                        FileLock lock = (FileLock)ref.get();
                        if (lock != null && lock.channel() == this.fci) {
                            releaser.release(lock);
                            ref.clear();
                            list.remove(index);
                            continue;
                        }
                        ++index;
                    }
                    this.removeKeyIfEmpty(this.fileKey, list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(FileLock fromLock, FileLock toLock) {
            ArrayList<FileLockReference> list = lockMap.get(this.fileKey);
            assert (list != null);
            ArrayList<FileLockReference> arrayList = list;
            synchronized (arrayList) {
                for (int index = 0; index < list.size(); ++index) {
                    FileLockReference ref = list.get(index);
                    FileLock lock = (FileLock)ref.get();
                    if (lock != fromLock) continue;
                    ref.clear();
                    list.set(index, new FileLockReference(toLock, queue, this.fileKey));
                    break;
                }
            }
        }

        private void checkList(List<FileLockReference> list, long position, long size) throws OverlappingFileLockException {
            assert (Thread.holdsLock(list));
            for (FileLockReference ref : list) {
                FileLock fl = (FileLock)ref.get();
                if (fl == null || !fl.overlaps(position, size)) continue;
                throw new OverlappingFileLockException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeStaleEntries() {
            FileLockReference ref;
            while ((ref = (FileLockReference)queue.poll()) != null) {
                FileKey fk = ref.fileKey();
                ArrayList<FileLockReference> list = lockMap.get(fk);
                if (list == null) continue;
                ArrayList<FileLockReference> arrayList = list;
                synchronized (arrayList) {
                    list.remove(ref);
                    this.removeKeyIfEmpty(fk, list);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileLockReference
    extends WeakReference<FileLock> {
        private FileKey fileKey;

        FileLockReference(FileLock referent, ReferenceQueue queue, FileKey key) {
            super(referent, queue);
            this.fileKey = key;
        }

        private FileKey fileKey() {
            return this.fileKey;
        }
    }

    private static class SimpleFileLockTable
    implements FileLockTable {
        private List<FileLock> lockList = new ArrayList<FileLock>(2);

        private void checkList(long position, long size) throws OverlappingFileLockException {
            assert (Thread.holdsLock(this.lockList));
            for (FileLock fl : this.lockList) {
                if (!fl.overlaps(position, size)) continue;
                throw new OverlappingFileLockException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(FileLock fl) throws OverlappingFileLockException {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.checkList(fl.position(), fl.size());
                this.lockList.add(fl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(FileLock fl) {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.lockList.remove(fl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll(FileLockTable.Releaser releaser) throws IOException {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                Iterator<FileLock> i = this.lockList.iterator();
                while (i.hasNext()) {
                    FileLock fl = i.next();
                    releaser.release(fl);
                    i.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replace(FileLock fl1, FileLock fl2) {
            List<FileLock> list = this.lockList;
            synchronized (list) {
                this.lockList.remove(fl1);
                this.lockList.add(fl2);
            }
        }
    }

    private static interface FileLockTable {
        public void add(FileLock var1) throws OverlappingFileLockException;

        public void remove(FileLock var1);

        public void removeAll(Releaser var1) throws IOException;

        public void replace(FileLock var1, FileLock var2);

        public static interface Releaser {
            public void release(FileLock var1) throws IOException;
        }
    }

    private static class Unmapper
    implements Runnable {
        private long address;
        private long size;

        private Unmapper(long address, long size) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        public void run() {
            if (this.address == 0L) {
                return;
            }
            FileChannelImpl.unmap0(this.address, this.size);
            this.address = 0L;
        }
    }
}

