/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarFileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarURLConnection
extends java.net.JarURLConnection {
    private static final boolean debug = false;
    private static JarFileFactory factory = new JarFileFactory();
    private URL jarFileURL = this.getJarFileURL();
    private Permission permission;
    private URLConnection jarFileURLConnection = this.jarFileURL.openConnection();
    private String entryName = this.getEntryName();
    private JarEntry jarEntry;
    private JarFile jarFile;
    private String contentType;

    public JarURLConnection(URL url, Handler handler) throws MalformedURLException, IOException {
        super(url);
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.jarFile = factory.get(this.getJarFileURL(), this.getUseCaches());
            if (this.getUseCaches()) {
                this.jarFileURLConnection = factory.getConnection(this.jarFile);
            }
            if (this.entryName != null) {
                this.jarEntry = (JarEntry)this.jarFile.getEntry(this.entryName);
                if (this.jarEntry == null) {
                    try {
                        if (!this.getUseCaches()) {
                            this.jarFile.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        JarURLInputStream result = null;
        if (this.entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
        }
        result = new JarURLInputStream(this.jarFile.getInputStream(this.jarEntry));
        return result;
    }

    @Override
    public int getContentLength() {
        int result = -1;
        try {
            this.connect();
            result = this.jarEntry == null ? this.jarFileURLConnection.getContentLength() : (int)this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Object getContent() throws IOException {
        Object result = null;
        this.connect();
        result = this.entryName == null ? this.jarFile : super.getContent();
        return result;
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream in = this.jarFile.getInputStream(this.jarEntry);
                    this.contentType = JarURLConnection.guessContentTypeFromStream(new BufferedInputStream(in));
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = JarURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    @Override
    public String getHeaderField(String name) {
        return this.jarFileURLConnection.getHeaderField(name);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.jarFileURLConnection.setRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return this.jarFileURLConnection.getRequestProperty(key);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.jarFileURLConnection.addRequestProperty(key, value);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.jarFileURLConnection.getRequestProperties();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.jarFileURLConnection.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.jarFileURLConnection.setUseCaches(usecaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.jarFileURLConnection.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.jarFileURLConnection.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }

    class JarURLInputStream
    extends FilterInputStream {
        JarURLInputStream(InputStream src) {
            super(src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            try {
                super.close();
                Object var2_1 = null;
                if (JarURLConnection.this.getUseCaches()) return;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (JarURLConnection.this.getUseCaches()) throw throwable;
                JarURLConnection.this.jarFile.close();
                throw throwable;
            }
            JarURLConnection.this.jarFile.close();
        }
    }
}

