/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.Negotiator;

class NegotiateAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private String scheme = null;
    static final char NEGOTIATE_AUTH = 'S';
    static final char KERBEROS_AUTH = 'K';
    static HashMap<String, Boolean> supported = null;
    static HashMap<String, Negotiator> cache = null;
    private Negotiator negotiator = null;

    public NegotiateAuthentication(boolean isProxy, URL url, PasswordAuthentication pw, String scheme) {
        super(isProxy ? (char)'p' : 's', 'S', url, "");
        this.scheme = scheme;
    }

    public NegotiateAuthentication(boolean isProxy, String host, int port, PasswordAuthentication pw, String scheme) {
        super(isProxy ? (char)'p' : 's', 'S', host, port, "");
        this.scheme = scheme;
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    public static synchronized boolean isSupported(String hostname, String scheme) {
        if (supported == null) {
            supported = new HashMap();
            cache = new HashMap();
        }
        if (supported.containsKey(hostname = hostname.toLowerCase())) {
            return supported.get(hostname);
        }
        try {
            Negotiator neg = Negotiator.getSupported(hostname, scheme);
            supported.put(hostname, true);
            cache.put(hostname, neg);
            return true;
        }
        catch (Exception e) {
            supported.put(hostname, false);
            return false;
        }
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-Authorization";
    }

    String getHeaderValue(URL url, String method) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    boolean isAuthorizationStale(String header) {
        return false;
    }

    synchronized boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        try {
            byte[] incoming = null;
            String[] parts = raw.split("\\s+");
            if (parts.length > 1) {
                incoming = new BASE64Decoder().decodeBuffer(parts[1]);
            }
            String response = this.scheme + " " + new B64Encoder().encode(incoming == null ? this.firstToken() : this.nextToken(incoming));
            conn.setAuthenticationProperty(this.getHeaderName(), response);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] firstToken() throws IOException {
        this.negotiator = null;
        if (cache != null) {
            HashMap<String, Negotiator> hashMap = cache;
            synchronized (hashMap) {
                this.negotiator = cache.get(this.getHost());
                if (this.negotiator != null) {
                    cache.remove(this.getHost());
                }
            }
        }
        if (this.negotiator == null) {
            try {
                this.negotiator = Negotiator.getSupported(this.getHost(), this.scheme);
            }
            catch (Exception e) {
                IOException ioe = new IOException("Cannot initialize Negotiator");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.negotiator.firstToken();
    }

    private byte[] nextToken(byte[] token) throws IOException {
        return this.negotiator.nextToken(token);
    }

    public void checkResponse(String header, String method, URL url) throws IOException {
    }

    class B64Encoder
    extends BASE64Encoder {
        B64Encoder() {
        }

        protected int bytesPerLine() {
            return 100000;
        }
    }
}

