/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import sun.misc.BASE64Decoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.B64Encoder;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetPropertyAction;
import sun.security.provider.MD4;

class NTLMAuthentication
extends AuthenticationInfo {
    static char NTLM_AUTH = (char)78;
    private byte[] type1;
    private byte[] type3;
    private SecretKeyFactory fac;
    private Cipher cipher;
    private MessageDigest md4;
    private String hostname;
    private static String defaultDomain = AccessController.doPrivileged(new GetPropertyAction("http.auth.ntlm.domain", "domain"));
    PasswordAuthentication pw;
    String username;
    String ntdomain;
    String password;

    static boolean supportsTransparentAuth() {
        return false;
    }

    private void init0() {
        block5: {
            this.type1 = new byte[256];
            this.type3 = new byte[256];
            System.arraycopy(new byte[]{78, 84, 76, 77, 83, 83, 80, 0, 1}, 0, this.type1, 0, 9);
            this.type1[12] = 3;
            this.type1[13] = -78;
            this.type1[28] = 32;
            System.arraycopy(new byte[]{78, 84, 76, 77, 83, 83, 80, 0, 3}, 0, this.type3, 0, 9);
            this.type3[12] = 24;
            this.type3[14] = 24;
            this.type3[20] = 24;
            this.type3[22] = 24;
            this.type3[32] = 64;
            this.type3[60] = 1;
            this.type3[61] = -126;
            try {
                this.hostname = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String localhost;
                        try {
                            localhost = InetAddress.getLocalHost().getHostName().toUpperCase();
                        }
                        catch (UnknownHostException e) {
                            localhost = "localhost";
                        }
                        return localhost;
                    }
                });
                int x = this.hostname.indexOf(46);
                if (x != -1) {
                    this.hostname = this.hostname.substring(0, x);
                }
                this.fac = SecretKeyFactory.getInstance("DES");
                this.cipher = Cipher.getInstance("DES/ECB/NoPadding");
                this.md4 = MD4.getInstance();
            }
            catch (NoSuchPaddingException e) {
                assert (false);
            }
            catch (NoSuchAlgorithmException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    public NTLMAuthentication(boolean isProxy, URL url, PasswordAuthentication pw) {
        super(isProxy ? (char)'p' : 's', NTLM_AUTH, url, "");
        this.init(pw);
    }

    private void init(PasswordAuthentication pw) {
        this.pw = pw;
        String s = pw.getUserName();
        int i = s.indexOf(92);
        if (i == -1) {
            this.username = s;
            this.ntdomain = defaultDomain;
        } else {
            this.ntdomain = s.substring(0, i).toUpperCase();
            this.username = s.substring(i + 1);
        }
        this.password = new String(pw.getPassword());
        this.init0();
    }

    public NTLMAuthentication(boolean isProxy, String host, int port, PasswordAuthentication pw) {
        super(isProxy ? (char)'p' : 's', NTLM_AUTH, host, port, "");
        this.init(pw);
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    String getHeaderValue(URL url, String method) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    boolean isAuthorizationStale(String header) {
        return false;
    }

    synchronized boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        try {
            String response;
            if (raw.length() < 6) {
                response = this.buildType1Msg();
            } else {
                String msg = raw.substring(5);
                response = this.buildType3Msg(msg);
            }
            conn.setAuthenticationProperty(this.getHeaderName(), response);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    public void checkResponse(String header, String method, URL url) throws IOException {
    }

    private void copybytes(byte[] dest, int destpos, String src, String enc) {
        block2: {
            try {
                byte[] x = src.getBytes(enc);
                System.arraycopy(x, 0, dest, destpos, x.length);
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private String buildType1Msg() {
        int dlen = this.ntdomain.length();
        this.type1[16] = (byte)(dlen % 256);
        this.type1[17] = (byte)(dlen / 256);
        this.type1[18] = this.type1[16];
        this.type1[19] = this.type1[17];
        int hlen = this.hostname.length();
        this.type1[24] = (byte)(hlen % 256);
        this.type1[25] = (byte)(hlen / 256);
        this.type1[26] = this.type1[24];
        this.type1[27] = this.type1[25];
        this.copybytes(this.type1, 32, this.hostname, "ISO8859_1");
        this.copybytes(this.type1, hlen + 32, this.ntdomain, "ISO8859_1");
        this.type1[20] = (byte)((hlen + 32) % 256);
        this.type1[21] = (byte)((hlen + 32) / 256);
        byte[] msg = new byte[32 + hlen + dlen];
        System.arraycopy(this.type1, 0, msg, 0, 32 + hlen + dlen);
        String result = "NTLM " + new B64Encoder().encode(msg);
        return result;
    }

    private byte[] makeDesKey(byte[] input, int off) {
        int[] in = new int[input.length];
        for (int i = 0; i < in.length; ++i) {
            in[i] = input[i] < 0 ? input[i] + 256 : input[i];
        }
        byte[] out = new byte[]{(byte)in[off + 0], (byte)(in[off + 0] << 7 & 0xFF | in[off + 1] >> 1), (byte)(in[off + 1] << 6 & 0xFF | in[off + 2] >> 2), (byte)(in[off + 2] << 5 & 0xFF | in[off + 3] >> 3), (byte)(in[off + 3] << 4 & 0xFF | in[off + 4] >> 4), (byte)(in[off + 4] << 3 & 0xFF | in[off + 5] >> 5), (byte)(in[off + 5] << 2 & 0xFF | in[off + 6] >> 6), (byte)(in[off + 6] << 1 & 0xFF)};
        return out;
    }

    private byte[] calcLMHash() throws GeneralSecurityException {
        byte[] magic = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] pwb = this.password.toUpperCase().getBytes();
        byte[] pwb1 = new byte[14];
        int len = this.password.length();
        if (len > 14) {
            len = 14;
        }
        System.arraycopy(pwb, 0, pwb1, 0, len);
        DESKeySpec dks1 = new DESKeySpec(this.makeDesKey(pwb1, 0));
        DESKeySpec dks2 = new DESKeySpec(this.makeDesKey(pwb1, 7));
        SecretKey key1 = this.fac.generateSecret(dks1);
        SecretKey key2 = this.fac.generateSecret(dks2);
        this.cipher.init(1, key1);
        byte[] out1 = this.cipher.doFinal(magic, 0, 8);
        this.cipher.init(1, key2);
        byte[] out2 = this.cipher.doFinal(magic, 0, 8);
        byte[] result = new byte[21];
        System.arraycopy(out1, 0, result, 0, 8);
        System.arraycopy(out2, 0, result, 8, 8);
        return result;
    }

    private byte[] calcNTHash() throws GeneralSecurityException {
        byte[] pw;
        block2: {
            pw = null;
            try {
                pw = this.password.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        byte[] out = this.md4.digest(pw);
        byte[] result = new byte[21];
        System.arraycopy(out, 0, result, 0, 16);
        return result;
    }

    private byte[] calcResponse(byte[] key, byte[] text) throws GeneralSecurityException {
        assert (key.length == 21);
        DESKeySpec dks1 = new DESKeySpec(this.makeDesKey(key, 0));
        DESKeySpec dks2 = new DESKeySpec(this.makeDesKey(key, 7));
        DESKeySpec dks3 = new DESKeySpec(this.makeDesKey(key, 14));
        SecretKey key1 = this.fac.generateSecret(dks1);
        SecretKey key2 = this.fac.generateSecret(dks2);
        SecretKey key3 = this.fac.generateSecret(dks3);
        this.cipher.init(1, key1);
        byte[] out1 = this.cipher.doFinal(text, 0, 8);
        this.cipher.init(1, key2);
        byte[] out2 = this.cipher.doFinal(text, 0, 8);
        this.cipher.init(1, key3);
        byte[] out3 = this.cipher.doFinal(text, 0, 8);
        byte[] result = new byte[24];
        System.arraycopy(out1, 0, result, 0, 8);
        System.arraycopy(out2, 0, result, 8, 8);
        System.arraycopy(out3, 0, result, 16, 8);
        return result;
    }

    private String buildType3Msg(String challenge) throws GeneralSecurityException, IOException {
        byte[] type2 = new BASE64Decoder().decodeBuffer(challenge);
        byte[] nonce = new byte[8];
        System.arraycopy(type2, 24, nonce, 0, 8);
        int ulen = this.username.length() * 2;
        this.type3[36] = this.type3[38] = (byte)(ulen % 256);
        this.type3[37] = this.type3[39] = (byte)(ulen / 256);
        int dlen = this.ntdomain.length() * 2;
        this.type3[28] = this.type3[30] = (byte)(dlen % 256);
        this.type3[29] = this.type3[31] = (byte)(dlen / 256);
        int hlen = this.hostname.length() * 2;
        this.type3[44] = this.type3[46] = (byte)(hlen % 256);
        this.type3[45] = this.type3[47] = (byte)(hlen / 256);
        int l = 64;
        this.copybytes(this.type3, l, this.ntdomain, "UnicodeLittleUnmarked");
        this.type3[32] = (byte)(l % 256);
        this.type3[33] = (byte)(l / 256);
        this.copybytes(this.type3, l += dlen, this.username, "UnicodeLittleUnmarked");
        this.type3[40] = (byte)(l % 256);
        this.type3[41] = (byte)(l / 256);
        this.copybytes(this.type3, l += ulen, this.hostname, "UnicodeLittleUnmarked");
        this.type3[48] = (byte)(l % 256);
        this.type3[49] = (byte)(l / 256);
        byte[] lmhash = this.calcLMHash();
        byte[] lmresponse = this.calcResponse(lmhash, nonce);
        byte[] nthash = this.calcNTHash();
        byte[] ntresponse = this.calcResponse(nthash, nonce);
        System.arraycopy(lmresponse, 0, this.type3, l += hlen, 24);
        this.type3[16] = (byte)(l % 256);
        this.type3[17] = (byte)(l / 256);
        System.arraycopy(ntresponse, 0, this.type3, l += 24, 24);
        this.type3[24] = (byte)(l % 256);
        this.type3[25] = (byte)(l / 256);
        this.type3[56] = (byte)((l += 24) % 256);
        this.type3[57] = (byte)(l / 256);
        byte[] msg = new byte[l];
        System.arraycopy(this.type3, 0, msg, 0, l);
        String result = "NTLM " + new B64Encoder().encode(msg);
        return result;
    }
}

