/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.IOException;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.ListIterator;
import sun.net.httpserver.ServerConfig;

public class SelectorCache {
    static SelectorCache cache = null;
    LinkedList<SelectorWrapper> freeSelectors = new LinkedList();

    private SelectorCache() {
        CacheCleaner c = AccessController.doPrivileged(new PrivilegedAction<CacheCleaner>(){

            @Override
            public CacheCleaner run() {
                CacheCleaner cleaner = new CacheCleaner();
                cleaner.setDaemon(true);
                return cleaner;
            }
        });
        c.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectorCache getSelectorCache() {
        Class<SelectorCache> clazz = SelectorCache.class;
        synchronized (SelectorCache.class) {
            if (cache == null) {
                cache = new SelectorCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    synchronized Selector getSelector() throws IOException {
        Selector selector;
        SelectorWrapper wrapper = null;
        if (this.freeSelectors.size() > 0) {
            wrapper = this.freeSelectors.remove();
            selector = wrapper.getSelector();
        } else {
            selector = Selector.open();
        }
        return selector;
    }

    synchronized void freeSelector(Selector selector) {
        this.freeSelectors.add(new SelectorWrapper(selector));
    }

    class CacheCleaner
    extends Thread {
        CacheCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long timeout = ServerConfig.getSelCacheTimeout() * 1000L;
            while (true) {
                try {
                    Thread.sleep(timeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LinkedList<SelectorWrapper> linkedList = SelectorCache.this.freeSelectors;
                synchronized (linkedList) {
                    ListIterator l = SelectorCache.this.freeSelectors.listIterator();
                    while (l.hasNext()) {
                        SelectorWrapper w = (SelectorWrapper)l.next();
                        if (w.getDeleteFlag()) {
                            try {
                                w.getSelector().close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            l.remove();
                            continue;
                        }
                        w.setDeleteFlag(true);
                    }
                }
            }
        }
    }

    private static class SelectorWrapper {
        private Selector sel;
        private boolean deleteFlag;

        private SelectorWrapper(Selector sel) {
            this.sel = sel;
            this.deleteFlag = false;
        }

        public Selector getSelector() {
            return this.sel;
        }

        public boolean getDeleteFlag() {
            return this.deleteFlag;
        }

        public void setDeleteFlag(boolean b) {
            this.deleteFlag = b;
        }
    }
}

