/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.util.Map;
import sun.management.snmp.jvminstr.JvmRTInputArgsEntryImpl;
import sun.management.snmp.jvminstr.JvmRuntimeImpl;
import sun.management.snmp.jvmmib.JvmRTInputArgsTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmRTInputArgsTableMetaImpl
extends JvmRTInputArgsTableMeta {
    private SnmpTableCache cache = new JvmRTInputArgsTableCache(this, -1L);
    static final MibLogger log = new MibLogger(JvmRTInputArgsTableMetaImpl.class);

    public JvmRTInputArgsTableMetaImpl(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib, objserv);
    }

    protected SnmpOid getNextOid(Object userData) throws SnmpStatusException {
        return this.getNextOid(null, userData);
    }

    protected SnmpOid getNextOid(SnmpOid oid, Object userData) throws SnmpStatusException {
        SnmpTableHandler handler;
        boolean dbg = log.isDebugOn();
        if (dbg) {
            log.debug("getNextOid", "previous=" + oid);
        }
        if ((handler = this.getHandler(userData)) == null) {
            if (dbg) {
                log.debug("getNextOid", "handler is null!");
            }
            throw new SnmpStatusException(224);
        }
        SnmpOid next = handler.getNext(oid);
        if (dbg) {
            log.debug("*** **** **** **** getNextOid", "next=" + next);
        }
        if (next == null) {
            throw new SnmpStatusException(224);
        }
        return next;
    }

    protected boolean contains(SnmpOid oid, Object userData) {
        SnmpTableHandler handler = this.getHandler(userData);
        if (handler == null) {
            return false;
        }
        return handler.contains(oid);
    }

    public Object getEntry(SnmpOid oid) throws SnmpStatusException {
        SnmpTableHandler handler;
        String entryTag;
        boolean dbg = log.isDebugOn();
        if (dbg) {
            log.debug("getEntry", "oid [" + oid + "]");
        }
        if (oid == null || oid.getLength() != 1) {
            if (dbg) {
                log.debug("getEntry", "Invalid oid [" + oid + "]");
            }
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> m = JvmContextFactory.getUserData();
        String string = entryTag = m == null ? null : "JvmRTInputArgsTable.entry." + oid.toString();
        if (m != null) {
            Object entry = m.get(entryTag);
            if (entry != null) {
                if (dbg) {
                    log.debug("getEntry", "Entry is already in the cache");
                }
                return entry;
            }
            if (dbg) {
                log.debug("getEntry", "Entry is not in the cache");
            }
        }
        if ((handler = this.getHandler(m)) == null) {
            throw new SnmpStatusException(224);
        }
        Object data = handler.getData(oid);
        if (data == null) {
            throw new SnmpStatusException(224);
        }
        if (dbg) {
            log.debug("getEntry", "data is a: " + data.getClass().getName());
        }
        JvmRTInputArgsEntryImpl entry = new JvmRTInputArgsEntryImpl((String)data, (int)oid.getOidArc(0));
        if (m != null && entry != null) {
            m.put(entryTag, entry);
        }
        return entry;
    }

    protected SnmpTableHandler getHandler(Object userData) {
        SnmpTableHandler handler;
        Map m = userData instanceof Map ? (Map)Util.cast(userData) : null;
        if (m != null && (handler = (SnmpTableHandler)m.get("JvmRTInputArgsTable.handler")) != null) {
            return handler;
        }
        handler = this.cache.getTableHandler();
        if (m != null && handler != null) {
            m.put("JvmRTInputArgsTable.handler", handler);
        }
        return handler;
    }

    private static class JvmRTInputArgsTableCache
    extends SnmpTableCache {
        private JvmRTInputArgsTableMetaImpl meta;

        JvmRTInputArgsTableCache(JvmRTInputArgsTableMetaImpl meta, long validity) {
            this.meta = meta;
            this.validity = validity;
        }

        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> userData = JvmContextFactory.getUserData();
            return this.getTableDatas(userData);
        }

        protected SnmpCachedData updateCachedDatas(Object userData) {
            Object[] args = JvmRuntimeImpl.getInputArguments(userData);
            long time = System.currentTimeMillis();
            SnmpOid[] indexes = new SnmpOid[args.length];
            for (int i = 0; i < args.length; ++i) {
                indexes[i] = new SnmpOid(i + 1);
            }
            return new SnmpCachedData(time, indexes, args);
        }
    }
}

