/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter.perf;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import sun.management.counter.AbstractCounter;
import sun.management.counter.ByteArrayCounter;
import sun.management.counter.Units;
import sun.management.counter.Variability;
import sun.management.counter.perf.ByteArrayCounterSnapshot;

public class PerfByteArrayCounter
extends AbstractCounter
implements ByteArrayCounter {
    ByteBuffer bb;

    PerfByteArrayCounter(String name, Units u, Variability v, int flags, int vectorLength, ByteBuffer bb) {
        super(name, u, v, flags, vectorLength);
        this.bb = bb;
    }

    public Object getValue() {
        return this.byteArrayValue();
    }

    public byte[] byteArrayValue() {
        this.bb.position(0);
        byte[] b = new byte[this.bb.limit()];
        this.bb.get(b);
        return b;
    }

    public byte byteAt(int index) {
        this.bb.position(index);
        return this.bb.get();
    }

    public String toString() {
        String result = this.getName() + ": " + new String(this.byteArrayValue()) + " " + this.getUnits();
        if (this.isInternal()) {
            return result + " [INTERNAL]";
        }
        return result;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new ByteArrayCounterSnapshot(this.getName(), this.getUnits(), this.getVariability(), this.getFlags(), this.getVectorLength(), this.byteArrayValue());
    }
}

