/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OSMBeanFactory;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementPermission;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.StandardEmitterMBean;
import javax.management.StandardMBean;
import sun.management.ClassLoadingImpl;
import sun.management.CompilationImpl;
import sun.management.GarbageCollectorImpl;
import sun.management.HotSpotDiagnostic;
import sun.management.HotspotClassLoading;
import sun.management.HotspotClassLoadingMBean;
import sun.management.HotspotCompilation;
import sun.management.HotspotCompilationMBean;
import sun.management.HotspotMemory;
import sun.management.HotspotMemoryMBean;
import sun.management.HotspotRuntime;
import sun.management.HotspotRuntimeMBean;
import sun.management.HotspotThread;
import sun.management.HotspotThreadMBean;
import sun.management.MemoryImpl;
import sun.management.MemoryManagerImpl;
import sun.management.MemoryPoolImpl;
import sun.management.OperatingSystemImpl;
import sun.management.RuntimeImpl;
import sun.management.ThreadImpl;
import sun.management.Util;
import sun.management.VMManagement;
import sun.management.VMManagementImpl;
import sun.misc.VM;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    private static VMManagement jvm;
    private static boolean mbeansCreated;
    private static ClassLoadingImpl classMBean;
    private static MemoryImpl memoryMBean;
    private static ThreadImpl threadMBean;
    private static RuntimeImpl runtimeMBean;
    private static CompilationImpl compileMBean;
    private static OperatingSystemImpl osMBean;
    private static HotSpotDiagnostic hsDiagMBean;
    private static HotspotRuntime hsRuntimeMBean;
    private static HotspotClassLoading hsClassMBean;
    private static HotspotThread hsThreadMBean;
    private static HotspotCompilation hsCompileMBean;
    private static HotspotMemory hsMemoryMBean;
    private static Permission monitorPermission;
    private static Permission controlPermission;
    private static final String HOTSPOT_DIAGNOSTIC_MXBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String HOTSPOT_CLASS_LOADING_MBEAN_NAME = "sun.management:type=HotspotClassLoading";
    private static final String HOTSPOT_COMPILATION_MBEAN_NAME = "sun.management:type=HotspotCompilation";
    private static final String HOTSPOT_MEMORY_MBEAN_NAME = "sun.management:type=HotspotMemory";
    private static final String HOTSPOT_RUNTIME_MBEAN_NAME = "sun.management:type=HotspotRuntime";
    private static final String HOTSPOT_THREAD_MBEAN_NAME = "sun.management:type=HotspotThreading";
    private static final String HOTSPOT_INTERNAL_MBEAN_NAME = "sun.management:type=HotspotInternal";
    private static ObjectName hsInternalObjName;
    private static final int JMM_THREAD_STATE_FLAG_MASK = -1048576;
    private static final int JMM_THREAD_STATE_FLAG_SUSPENDED = 0x100000;
    private static final int JMM_THREAD_STATE_FLAG_NATIVE = 0x400000;

    private ManagementFactory() {
    }

    public static synchronized ClassLoadingMXBean getClassLoadingMXBean() {
        if (classMBean == null) {
            classMBean = new ClassLoadingImpl(jvm);
        }
        return classMBean;
    }

    public static synchronized MemoryMXBean getMemoryMXBean() {
        if (memoryMBean == null) {
            memoryMBean = new MemoryImpl(jvm);
        }
        return memoryMBean;
    }

    public static synchronized ThreadMXBean getThreadMXBean() {
        if (threadMBean == null) {
            threadMBean = new ThreadImpl(jvm);
        }
        return threadMBean;
    }

    public static synchronized RuntimeMXBean getRuntimeMXBean() {
        if (runtimeMBean == null) {
            runtimeMBean = new RuntimeImpl(jvm);
        }
        return runtimeMBean;
    }

    public static synchronized CompilationMXBean getCompilationMXBean() {
        if (compileMBean == null && jvm.getCompilerName() != null) {
            compileMBean = new CompilationImpl(jvm);
        }
        return compileMBean;
    }

    public static synchronized OperatingSystemMXBean getOperatingSystemMXBean() {
        if (osMBean == null) {
            osMBean = (OperatingSystemImpl)OSMBeanFactory.getOperatingSystemMXBean(jvm);
        }
        return osMBean;
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        MemoryPoolMXBean[] pools = MemoryImpl.getMemoryPools();
        ArrayList<MemoryPoolMXBean> list = new ArrayList<MemoryPoolMXBean>(pools.length);
        for (int i = 0; i < pools.length; ++i) {
            MemoryPoolMXBean p = pools[i];
            list.add(p);
        }
        return list;
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        MemoryManagerMXBean[] mgrs = MemoryImpl.getMemoryManagers();
        ArrayList<MemoryManagerMXBean> result = new ArrayList<MemoryManagerMXBean>(mgrs.length);
        for (int i = 0; i < mgrs.length; ++i) {
            MemoryManagerMXBean m = mgrs[i];
            result.add(m);
        }
        return result;
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        MemoryManagerMXBean[] mgrs = MemoryImpl.getMemoryManagers();
        ArrayList<GarbageCollectorMXBean> result = new ArrayList<GarbageCollectorMXBean>(mgrs.length);
        for (int i = 0; i < mgrs.length; ++i) {
            if (!(mgrs[i] instanceof GarbageCollectorMXBean)) continue;
            GarbageCollectorMXBean gc = (GarbageCollectorMXBean)mgrs[i];
            result.add(gc);
        }
        return result;
    }

    public static synchronized HotSpotDiagnosticMXBean getDiagnosticMXBean() {
        if (hsDiagMBean == null) {
            hsDiagMBean = new HotSpotDiagnostic();
        }
        return hsDiagMBean;
    }

    public static synchronized HotspotRuntimeMBean getHotspotRuntimeMBean() {
        if (hsRuntimeMBean == null) {
            hsRuntimeMBean = new HotspotRuntime(jvm);
        }
        return hsRuntimeMBean;
    }

    public static synchronized HotspotClassLoadingMBean getHotspotClassLoadingMBean() {
        if (hsClassMBean == null) {
            hsClassMBean = new HotspotClassLoading(jvm);
        }
        return hsClassMBean;
    }

    public static synchronized HotspotThreadMBean getHotspotThreadMBean() {
        if (hsThreadMBean == null) {
            hsThreadMBean = new HotspotThread(jvm);
        }
        return hsThreadMBean;
    }

    public static synchronized HotspotMemoryMBean getHotspotMemoryMBean() {
        if (hsMemoryMBean == null) {
            hsMemoryMBean = new HotspotMemory(jvm);
        }
        return hsMemoryMBean;
    }

    public static synchronized HotspotCompilationMBean getHotspotCompilationMBean() {
        if (hsCompileMBean == null) {
            hsCompileMBean = new HotspotCompilation(jvm);
        }
        return hsCompileMBean;
    }

    static void checkAccess(Permission p) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    static void checkMonitorAccess() throws SecurityException {
        ManagementFactory.checkAccess(monitorPermission);
    }

    static void checkControlAccess() throws SecurityException {
        ManagementFactory.checkAccess(controlPermission);
    }

    private static void addMXBean(MBeanServer mbs, Object mbean, String mbeanName, NotificationEmitter emitter) {
        StandardMBean dmbean = emitter == null ? new StandardMBean(mbean, null, true) : new StandardEmitterMBean(mbean, null, true, emitter);
        ManagementFactory.addMBean(mbs, dmbean, mbeanName, false);
    }

    private static void addMBean(MBeanServer mbs, Object mbean, String mbeanName) {
        ManagementFactory.addMBean(mbs, mbean, mbeanName, false);
    }

    private static void addMBean(MBeanServer mbs, Object mbean, String mbeanName, boolean ignoreConflicts) {
        try {
            final ObjectName objName = new ObjectName(mbeanName);
            final MBeanServer mbs0 = mbs;
            final Object mbean0 = mbean;
            final boolean ignore = ignoreConflicts;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    try {
                        ObjectInstance o = mbs0.registerMBean(mbean0, objName);
                        return null;
                    }
                    catch (InstanceAlreadyExistsException e) {
                        if (!ignore) {
                            throw e;
                        }
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw Util.newException(e.getException());
        }
        catch (MalformedObjectNameException e) {
            throw Util.newException(e);
        }
    }

    public static MBeanServer createPlatformMBeanServer() {
        MBeanServer mbs = MBeanServerFactory.createMBeanServer();
        ManagementFactory.addMXBean(mbs, ManagementFactory.getClassLoadingMXBean(), "java.lang:type=ClassLoading", null);
        ManagementFactory.addMXBean(mbs, ManagementFactory.getMemoryMXBean(), "java.lang:type=Memory", (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean()));
        ManagementFactory.addMXBean(mbs, ManagementFactory.getOperatingSystemMXBean(), "java.lang:type=OperatingSystem", null);
        ManagementFactory.addMXBean(mbs, ManagementFactory.getRuntimeMXBean(), "java.lang:type=Runtime", null);
        ManagementFactory.addMXBean(mbs, ManagementFactory.getThreadMXBean(), "java.lang:type=Threading", null);
        ManagementFactory.addMXBean(mbs, ManagementFactory.getDiagnosticMXBean(), HOTSPOT_DIAGNOSTIC_MXBEAN_NAME, null);
        if (ManagementFactory.getCompilationMXBean() != null) {
            ManagementFactory.addMXBean(mbs, ManagementFactory.getCompilationMXBean(), "java.lang:type=Compilation", null);
        }
        ManagementFactory.addMemoryManagers(mbs);
        ManagementFactory.addMemoryPools(mbs);
        ManagementFactory.addMXBean(mbs, LogManager.getLoggingMXBean(), "java.util.logging:type=Logging", null);
        return mbs;
    }

    static synchronized ObjectName getHotspotInternalObjectName() {
        if (hsInternalObjName == null) {
            try {
                hsInternalObjName = new ObjectName(HOTSPOT_INTERNAL_MBEAN_NAME);
            }
            catch (MalformedObjectNameException e) {
                throw Util.newException(e);
            }
        }
        return hsInternalObjName;
    }

    static void registerInternalMBeans(MBeanServer mbs) {
        ManagementFactory.addMBean(mbs, ManagementFactory.getHotspotClassLoadingMBean(), HOTSPOT_CLASS_LOADING_MBEAN_NAME, true);
        ManagementFactory.addMBean(mbs, ManagementFactory.getHotspotMemoryMBean(), HOTSPOT_MEMORY_MBEAN_NAME, true);
        ManagementFactory.addMBean(mbs, ManagementFactory.getHotspotRuntimeMBean(), HOTSPOT_RUNTIME_MBEAN_NAME, true);
        ManagementFactory.addMBean(mbs, ManagementFactory.getHotspotThreadMBean(), HOTSPOT_THREAD_MBEAN_NAME, true);
        if (ManagementFactory.getCompilationMXBean() != null) {
            ManagementFactory.addMBean(mbs, ManagementFactory.getHotspotCompilationMBean(), HOTSPOT_COMPILATION_MBEAN_NAME, true);
        }
    }

    private static void unregisterMBean(MBeanServer mbs, String mbeanName) {
        try {
            final ObjectName objName = new ObjectName(mbeanName);
            final MBeanServer mbs0 = mbs;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws MBeanRegistrationException, RuntimeOperationsException {
                    try {
                        mbs0.unregisterMBean(objName);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw Util.newException(e.getException());
        }
        catch (MalformedObjectNameException e) {
            throw Util.newException(e);
        }
    }

    static void unregisterInternalMBeans(MBeanServer mbs) {
        ManagementFactory.unregisterMBean(mbs, HOTSPOT_CLASS_LOADING_MBEAN_NAME);
        ManagementFactory.unregisterMBean(mbs, HOTSPOT_MEMORY_MBEAN_NAME);
        ManagementFactory.unregisterMBean(mbs, HOTSPOT_RUNTIME_MBEAN_NAME);
        ManagementFactory.unregisterMBean(mbs, HOTSPOT_THREAD_MBEAN_NAME);
        if (ManagementFactory.getCompilationMXBean() != null) {
            ManagementFactory.unregisterMBean(mbs, HOTSPOT_COMPILATION_MBEAN_NAME);
        }
    }

    private static synchronized void addMemoryPools(MBeanServer mbs) {
        MemoryPoolMXBean[] newPools = MemoryImpl.getMemoryPools();
        for (int i = 0; i < newPools.length; ++i) {
            String poolObjNameString = Util.getMBeanObjectName(newPools[i]);
            ManagementFactory.addMXBean(mbs, newPools[i], poolObjNameString, null);
        }
    }

    private static synchronized void addMemoryManagers(MBeanServer mbs) {
        MemoryManagerMXBean[] newMgrs = MemoryImpl.getMemoryManagers();
        for (int i = 0; i < newMgrs.length; ++i) {
            String mgrObjNameString = Util.getMBeanObjectName(newMgrs[i]);
            ManagementFactory.addMXBean(mbs, newMgrs[i], mgrObjNameString, null);
        }
    }

    private static MemoryPoolMXBean createMemoryPool(String name, boolean isHeap, long uThreshold, long gcThreshold) {
        return new MemoryPoolImpl(name, isHeap, uThreshold, gcThreshold);
    }

    private static MemoryManagerMXBean createMemoryManager(String name) {
        return new MemoryManagerImpl(name);
    }

    private static GarbageCollectorMXBean createGarbageCollector(String name, String type) {
        return new GarbageCollectorImpl(name);
    }

    public static boolean isThreadSuspended(int state) {
        return (state & 0x100000) != 0;
    }

    public static boolean isThreadRunningNative(int state) {
        return (state & 0x400000) != 0;
    }

    public static Thread.State toThreadState(int state) {
        int threadStatus = state & 0xFFFFF;
        return VM.toThreadState(threadStatus);
    }

    static {
        mbeansCreated = false;
        classMBean = null;
        memoryMBean = null;
        threadMBean = null;
        runtimeMBean = null;
        compileMBean = null;
        osMBean = null;
        hsDiagMBean = null;
        hsRuntimeMBean = null;
        hsClassMBean = null;
        hsThreadMBean = null;
        hsCompileMBean = null;
        hsMemoryMBean = null;
        monitorPermission = new ManagementPermission("monitor");
        controlPermission = new ManagementPermission("control");
        hsInternalObjName = null;
        AccessController.doPrivileged(new LoadLibraryAction("management"));
        jvm = new VMManagementImpl();
    }
}

