/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.ListIterator;
import sun.management.GcInfoBuilder;
import sun.management.MemoryManagerImpl;

class GarbageCollectorImpl
extends MemoryManagerImpl
implements GarbageCollectorMXBean {
    private String[] poolNames = null;
    private GcInfoBuilder gcInfoBuilder;

    GarbageCollectorImpl(String name) {
        super(name);
    }

    public native long getCollectionCount();

    public native long getCollectionTime();

    synchronized String[] getAllPoolNames() {
        if (this.poolNames == null) {
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            this.poolNames = new String[pools.size()];
            int i = 0;
            ListIterator<MemoryPoolMXBean> iter = pools.listIterator();
            while (iter.hasNext()) {
                MemoryPoolMXBean p = iter.next();
                this.poolNames[i] = p.getName();
                ++i;
            }
        }
        return this.poolNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GcInfo getLastGcInfo() {
        GarbageCollectorImpl garbageCollectorImpl = this;
        synchronized (garbageCollectorImpl) {
            if (this.gcInfoBuilder == null) {
                this.gcInfoBuilder = new GcInfoBuilder(this, this.getAllPoolNames());
            }
        }
        GcInfo info = this.gcInfoBuilder.getLastGcInfo();
        return info;
    }
}

