/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;

public class ConnectorAddressLink {
    private static final String CONNECTOR_ADDRESS_COUNTER = "sun.management.JMXConnectorServer.address";

    public static void export(String address) {
        if (address == null || address.length() == 0) {
            throw new IllegalArgumentException("address not specified");
        }
        Perf perf = Perf.getPerf();
        perf.createString(CONNECTOR_ADDRESS_COUNTER, 1, Units.STRING.intValue(), address);
    }

    public static String importFrom(int vmid) throws IOException {
        ByteBuffer bb;
        Perf perf = Perf.getPerf();
        try {
            bb = perf.attach(vmid, "r");
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
        List<Counter> counters = new PerfInstrumentation(bb).findByPattern(CONNECTOR_ADDRESS_COUNTER);
        Iterator<Counter> i = counters.iterator();
        if (i.hasNext()) {
            Counter c = i.next();
            return (String)c.getValue();
        }
        return null;
    }
}

