/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LauncherHelp {
    private static final String defaultBundleName = "sun.launcher.resources.launcher";
    private static ResourceBundle javarb = ResourceBundle.getBundle("sun.launcher.resources.launcher");
    private static StringBuilder outBuf = new StringBuilder();

    private LauncherHelp() {
    }

    private static String getLocalizedMessage(String key, Object ... args) {
        String msg = javarb.getString(key);
        return args != null ? MessageFormat.format(msg, args) : msg;
    }

    static void initHelpMessage(String progname) {
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.header", progname == null ? "java" : progname));
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.datamodel", 32));
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.datamodel", 64));
    }

    static void appendVmSelectMessage(String vm1, String vm2) {
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.vmselect", vm1, vm2));
    }

    static void appendVmSynonymMessage(String vm1, String vm2) {
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.hotspot", vm1, vm2));
    }

    static void appendVmErgoMessage(boolean isServerClass, String vm) {
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.ergo.message1", vm));
        outBuf = isServerClass ? outBuf.append(",\n" + LauncherHelp.getLocalizedMessage("java.launcher.ergo.message2", new Object[0]) + "\n\n") : outBuf.append(".\n\n");
    }

    static void printHelpMessage(boolean printToStderr) {
        PrintStream ostream = printToStderr ? System.err : System.out;
        outBuf = outBuf.append(LauncherHelp.getLocalizedMessage("java.launcher.opt.footer", File.pathSeparator));
        ostream.println(outBuf.toString());
    }

    static void printXUsageMessage(boolean printToStderr) {
        PrintStream ostream = printToStderr ? System.err : System.out;
        ostream.println(LauncherHelp.getLocalizedMessage("java.launcher.X.usage", File.pathSeparator));
    }

    public static void main(String[] args) {
        LauncherHelp.initHelpMessage("java");
        LauncherHelp.appendVmSelectMessage("-client", "client");
        LauncherHelp.appendVmSelectMessage("-server", "server");
        LauncherHelp.appendVmSynonymMessage("-hotspot", "client");
        LauncherHelp.appendVmErgoMessage(true, "server");
        LauncherHelp.printHelpMessage(true);
        System.err.println("------------------------------------");
        LauncherHelp.printXUsageMessage(true);
    }
}

