/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.io.PrintStream;

public final class PiscesCache {
    int bboxX0;
    int bboxY0;
    int bboxX1;
    int bboxY1;
    byte[] rowAARLE;
    int alphaRLELength;
    int[] rowOffsetsRLE;
    int[] minTouched;
    int alphaRows;
    private static final float ROWAA_RLE_FACTOR = 1.5f;
    private static final float TOUCHED_FACTOR = 1.5f;
    private static final int MIN_TOUCHED_LEN = 64;

    private PiscesCache() {
    }

    public static PiscesCache createInstance() {
        return new PiscesCache();
    }

    private void reallocRowAARLE(int newLength) {
        if (this.rowAARLE == null) {
            this.rowAARLE = new byte[newLength];
        } else if (this.rowAARLE.length < newLength) {
            int len = Math.max(newLength, (int)((float)this.rowAARLE.length * 1.5f));
            byte[] newRowAARLE = new byte[len];
            System.arraycopy(this.rowAARLE, 0, newRowAARLE, 0, this.rowAARLE.length);
            this.rowAARLE = newRowAARLE;
        }
    }

    private void reallocRowInfo(int newHeight) {
        if (this.minTouched == null) {
            int len = Math.max(newHeight, 64);
            this.minTouched = new int[len];
            this.rowOffsetsRLE = new int[len];
        } else if (this.minTouched.length < newHeight) {
            int len = Math.max(newHeight, (int)((float)this.minTouched.length * 1.5f));
            int[] newMinTouched = new int[len];
            int[] newRowOffsetsRLE = new int[len];
            System.arraycopy(this.minTouched, 0, newMinTouched, 0, this.alphaRows);
            System.arraycopy(this.rowOffsetsRLE, 0, newRowOffsetsRLE, 0, this.alphaRows);
            this.minTouched = newMinTouched;
            this.rowOffsetsRLE = newRowOffsetsRLE;
        }
    }

    void addRLERun(byte val, int runLen) {
        this.reallocRowAARLE(this.alphaRLELength + 2);
        this.rowAARLE[this.alphaRLELength++] = val;
        this.rowAARLE[this.alphaRLELength++] = (byte)runLen;
    }

    void startRow(int y, int x0, int x1) {
        if (this.alphaRows == 0) {
            this.bboxY0 = y;
            this.bboxY1 = y + 1;
            this.bboxX0 = x0;
            this.bboxX1 = x1 + 1;
        } else {
            if (this.bboxX0 > x0) {
                this.bboxX0 = x0;
            }
            if (this.bboxX1 < x1) {
                this.bboxX1 = x1;
            }
            while (this.bboxY1++ < y) {
                this.reallocRowInfo(this.alphaRows + 1);
                this.minTouched[this.alphaRows] = 0;
                this.rowOffsetsRLE[this.alphaRows] = this.alphaRLELength - 2;
                ++this.alphaRows;
            }
        }
        this.reallocRowInfo(this.alphaRows + 1);
        this.minTouched[this.alphaRows] = x0;
        this.rowOffsetsRLE[this.alphaRows] = this.alphaRLELength;
        ++this.alphaRows;
    }

    public synchronized void dispose() {
        this.rowAARLE = null;
        this.alphaRLELength = 0;
        this.minTouched = null;
        this.rowOffsetsRLE = null;
        this.alphaRows = 0;
        this.bboxY1 = 0;
        this.bboxX1 = 0;
        this.bboxY0 = 0;
        this.bboxX0 = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println("bbox = [" + this.bboxX0 + ", " + this.bboxY0 + " => " + this.bboxX1 + ", " + this.bboxY1 + "]");
            out.println("alphRLELength = " + this.alphaRLELength);
            for (int y = this.bboxY0; y < this.bboxY1; ++y) {
                int i = y - this.bboxY0;
                out.println("row[" + i + "] == {" + "minX = " + this.minTouched[i] + ", off = " + this.rowOffsetsRLE[i] + "}");
            }
            for (int i = 0; i < this.alphaRLELength; i += 2) {
                out.println("rle[" + i + "] = " + (this.rowAARLE[i + 1] & 0xFF) + " of " + (this.rowAARLE[i] & 0xFF));
            }
        }
    }
}

