/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CharToByteISO8859_1
extends CharToByteConverter {
    private char highHalfZoneCode;

    public String getCharacterEncoding() {
        return "ISO8859_1";
    }

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            throw new MalformedInputException("String ends with <High Half Zone code> of UTF16");
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        int i;
        int outputSize;
        char inputChar;
        byte[] tmpArray = new byte[1];
        this.charOff = inOff;
        this.byteOff = outOff;
        if (this.highHalfZoneCode != '\u0000') {
            inputChar = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (input[inOff] >= '\udc00' && input[inOff] <= '\udfff') {
                if (!this.subMode) {
                    this.badInputLength = 1;
                    throw new UnknownCharacterException();
                }
                outputSize = this.subBytes.length;
                if (this.byteOff + outputSize > outEnd) {
                    throw new ConversionBufferFullException();
                }
                for (i = 0; i < outputSize; ++i) {
                    output[this.byteOff++] = this.subBytes[i];
                }
                ++this.charOff;
            } else {
                this.badInputLength = 0;
                throw new MalformedInputException("Previous converted string ends with <High Half Zone Code> of UTF16 , but this string is not begin with <Low Half Zone>");
            }
        }
        while (this.charOff < inEnd) {
            int inputSize;
            byte[] outputByte;
            block18: {
                outputByte = tmpArray;
                inputChar = input[this.charOff];
                outputSize = 1;
                inputSize = 1;
                if (inputChar >= '\ud800' && inputChar <= '\udbff') {
                    if (this.charOff + 1 == inEnd) {
                        this.highHalfZoneCode = inputChar;
                        return this.byteOff - outOff;
                    }
                    inputChar = input[this.charOff + 1];
                    if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                        if (!this.subMode) {
                            this.badInputLength = 2;
                            throw new UnknownCharacterException();
                        }
                        outputByte = this.subBytes;
                        outputSize = this.subBytes.length;
                        inputSize = 2;
                        break block18;
                    } else {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                }
                if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                if (inputChar <= '\u00ff') {
                    outputByte[0] = (byte)inputChar;
                } else {
                    if (!this.subMode) {
                        this.badInputLength = 1;
                        throw new UnknownCharacterException();
                    }
                    outputByte = this.subBytes;
                    outputSize = this.subBytes.length;
                }
            }
            if (this.byteOff + outputSize > outEnd) {
                throw new ConversionBufferFullException();
            }
            for (i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }

    public boolean canConvert(char ch) {
        return ch <= '\u00ff';
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

