/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;

public class ByteToCharUTF8
extends ByteToCharConverter {
    private int savedSize = 0;
    private byte[] savedBytes = new byte[5];

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.savedSize != 0) {
            this.savedSize = 0;
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws MalformedInputException, ConversionBufferFullException {
        int i;
        char[] outputChar = new char[2];
        int byteOffAdjustment = 0;
        if (this.savedSize != 0) {
            byte[] newBuf = new byte[inEnd - inOff + this.savedSize];
            for (i = 0; i < this.savedSize; ++i) {
                newBuf[i] = this.savedBytes[i];
            }
            System.arraycopy(input, inOff, newBuf, this.savedSize, inEnd - inOff);
            input = newBuf;
            inOff = 0;
            inEnd = newBuf.length;
            byteOffAdjustment = -this.savedSize;
            this.savedSize = 0;
        }
        this.charOff = outOff;
        this.byteOff = inOff;
        while (this.byteOff < inEnd) {
            int byte3;
            int byte2;
            int outputSize;
            int byte1;
            int startByteOff = this.byteOff;
            if (((byte1 = input[this.byteOff++] & 0xFF) & 0x80) == 0) {
                outputChar[0] = (char)byte1;
                outputSize = 1;
            } else if ((byte1 & 0xE0) == 192) {
                if (this.byteOff >= inEnd) {
                    this.savedSize = 1;
                    this.savedBytes[0] = (byte)byte1;
                    break;
                }
                if (((byte2 = input[this.byteOff++] & 0xFF) & 0xC0) != 128) {
                    this.badInputLength = 2;
                    this.byteOff += byteOffAdjustment;
                    throw new MalformedInputException();
                }
                outputChar[0] = (char)((byte1 & 0x1F) << 6 | byte2 & 0x3F);
                outputSize = 1;
            } else if ((byte1 & 0xF0) == 224) {
                if (this.byteOff + 1 >= inEnd) {
                    this.savedBytes[0] = (byte)byte1;
                    if (this.byteOff >= inEnd) {
                        this.savedSize = 1;
                        break;
                    }
                    this.savedSize = 2;
                    this.savedBytes[1] = input[this.byteOff++];
                    break;
                }
                byte2 = input[this.byteOff++] & 0xFF;
                byte3 = input[this.byteOff++] & 0xFF;
                if ((byte2 & 0xC0) != 128 || (byte3 & 0xC0) != 128) {
                    this.badInputLength = 3;
                    this.byteOff += byteOffAdjustment;
                    throw new MalformedInputException();
                }
                outputChar[0] = (char)((byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F);
                outputSize = 1;
            } else if ((byte1 & 0xF8) == 240) {
                if (this.byteOff + 2 >= inEnd) {
                    this.savedBytes[0] = (byte)byte1;
                    if (this.byteOff >= inEnd) {
                        this.savedSize = 1;
                        break;
                    }
                    if (this.byteOff + 1 >= inEnd) {
                        this.savedSize = 2;
                        this.savedBytes[1] = input[this.byteOff++];
                        break;
                    }
                    this.savedSize = 3;
                    this.savedBytes[1] = input[this.byteOff++];
                    this.savedBytes[2] = input[this.byteOff++];
                    break;
                }
                byte2 = input[this.byteOff++] & 0xFF;
                byte3 = input[this.byteOff++] & 0xFF;
                int byte4 = input[this.byteOff++] & 0xFF;
                if ((byte2 & 0xC0) != 128 || (byte3 & 0xC0) != 128 || (byte4 & 0xC0) != 128) {
                    this.badInputLength = 4;
                    this.byteOff += byteOffAdjustment;
                    throw new MalformedInputException();
                }
                int ucs4 = (7 & byte1) << 18 | (0x3F & byte2) << 12 | (0x3F & byte3) << 6 | 0x3F & byte4;
                outputChar[0] = (char)((ucs4 - 65536) / 1024 + 55296);
                outputChar[1] = (char)((ucs4 - 65536) % 1024 + 56320);
                outputSize = 2;
            } else {
                this.badInputLength = 1;
                this.byteOff += byteOffAdjustment;
                throw new MalformedInputException();
            }
            if (this.charOff + outputSize > outEnd) {
                this.byteOff = startByteOff;
                this.byteOff += byteOffAdjustment;
                throw new ConversionBufferFullException();
            }
            for (i = 0; i < outputSize; ++i) {
                output[this.charOff + i] = outputChar[i];
            }
            this.charOff += outputSize;
        }
        this.byteOff += byteOffAdjustment;
        return this.charOff - outOff;
    }

    public String getCharacterEncoding() {
        return "UTF8";
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.savedSize = 0;
    }
}

