/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.NativeStrike;
import sun.font.StrikeMetrics;

class DelegateStrike
extends NativeStrike {
    private FontStrike delegateStrike;

    DelegateStrike(NativeFont nativeFont, FontStrikeDesc desc, FontStrike delegate) {
        super(nativeFont, desc);
        this.delegateStrike = delegate;
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            if (this.pScalerContext != 0L) {
                this.strikeMetrics = super.getFontMetrics();
            }
            if (this.strikeMetrics == null) {
                this.strikeMetrics = this.delegateStrike.getFontMetrics();
            }
        }
        return this.strikeMetrics;
    }

    void getGlyphImagePtrs(int[] glyphCodes, long[] images, int len) {
        this.delegateStrike.getGlyphImagePtrs(glyphCodes, images, len);
    }

    long getGlyphImagePtr(int glyphCode) {
        return this.delegateStrike.getGlyphImagePtr(glyphCode);
    }

    void getGlyphImageBounds(int glyphCode, Point2D.Float pt, Rectangle result) {
        this.delegateStrike.getGlyphImageBounds(glyphCode, pt, result);
    }

    Point2D.Float getGlyphMetrics(int glyphCode) {
        return this.delegateStrike.getGlyphMetrics(glyphCode);
    }

    float getGlyphAdvance(int glyphCode) {
        return this.delegateStrike.getGlyphAdvance(glyphCode);
    }

    Point2D.Float getCharMetrics(char ch) {
        return this.delegateStrike.getCharMetrics(ch);
    }

    float getCodePointAdvance(int cp) {
        if (cp < 0 || cp >= 65536) {
            cp = 65535;
        }
        return this.delegateStrike.getGlyphAdvance(cp);
    }

    Rectangle2D.Float getGlyphOutlineBounds(int glyphCode) {
        return this.delegateStrike.getGlyphOutlineBounds(glyphCode);
    }

    GeneralPath getGlyphOutline(int glyphCode, float x, float y) {
        return this.delegateStrike.getGlyphOutline(glyphCode, x, y);
    }

    GeneralPath getGlyphVectorOutline(int[] glyphs, float x, float y) {
        return this.delegateStrike.getGlyphVectorOutline(glyphs, x, y);
    }
}

